/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.business.MailService;
import de.justsoftware.chat.config.ChatConfigProperties;
import de.justsoftware.chat.config.MailScheduler;
import de.justsoftware.chat.model.ClusterPosition;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0012J\"\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/chat/config/MailScheduler;", "", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "chatConfigProperties", "Lde/justsoftware/chat/config/ChatConfigProperties;", "mailService", "Lde/justsoftware/chat/business/MailService;", "clusterPosition", "Lde/justsoftware/chat/model/ClusterPosition;", "<init>", "(Lorg/springframework/scheduling/TaskScheduler;Lde/justsoftware/chat/config/ChatConfigProperties;Lde/justsoftware/chat/business/MailService;Lde/justsoftware/chat/model/ClusterPosition;)V", "scheduledThread", "Ljava/util/concurrent/ScheduledFuture;", "startMailCron", "", "schedule", "cronExpression", "", "task", "Ljava/lang/Runnable;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMailScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MailScheduler.kt\nde/justsoftware/chat/config/MailScheduler\n+ 2 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,61:1\n9#2:62\n8#2,3:63\n*S KotlinDebug\n*F\n+ 1 MailScheduler.kt\nde/justsoftware/chat/config/MailScheduler\n*L\n58#1:62\n58#1:63,3\n*E\n"})
public class MailScheduler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final ChatConfigProperties chatConfigProperties;
    @NotNull
    private final MailService mailService;
    @NotNull
    private final ClusterPosition clusterPosition;
    @Nullable
    private ScheduledFuture<?> scheduledThread;
    @NotNull
    private static final Logger LOG;

    public MailScheduler(@NotNull TaskScheduler taskScheduler, @NotNull ChatConfigProperties chatConfigProperties, @NotNull MailService mailService, @Value(value="${service.cluster-position}") @NotNull ClusterPosition clusterPosition) {
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)chatConfigProperties, (String)"chatConfigProperties");
        Intrinsics.checkNotNullParameter((Object)mailService, (String)"mailService");
        Intrinsics.checkNotNullParameter((Object)clusterPosition, (String)"clusterPosition");
        this.taskScheduler = taskScheduler;
        this.chatConfigProperties = chatConfigProperties;
        this.mailService = mailService;
        this.clusterPosition = clusterPosition;
        if (this.clusterPosition == ClusterPosition.PRIMARY) {
            this.chatConfigProperties.addMailCronListener(() -> MailScheduler._init_$lambda$0(this));
            this.startMailCron();
        }
    }

    private void startMailCron() {
        ScheduledFuture scheduledFuture = this.scheduledThread;
        if (scheduledFuture != null) {
            ScheduledFuture scheduledFuture2 = scheduledFuture;
            boolean bl = false;
            scheduledFuture2.cancel(false);
            LOG.info("Active MailCron was canceled due to a Zookeeper change.");
        }
        String string = this.chatConfigProperties.getMailCron();
        if (string == null) {
            MailScheduler $this$startMailCron_u24lambda_u242 = this;
            boolean bl = false;
            LOG.info("Cron expression is empty. MailCron won't be started.");
            return;
        }
        String cronExpression = string;
        LOG.info("Starting MailCron with {}.", (Object)cronExpression);
        this.scheduledThread = this.schedule(this.taskScheduler, cronExpression, () -> MailScheduler.startMailCron$lambda$3(this));
    }

    private ScheduledFuture<?> schedule(TaskScheduler $this$schedule, String cronExpression, Runnable task) {
        ScheduledFuture scheduledFuture;
        try {
            scheduledFuture = $this$schedule.schedule(task, (Trigger)new CronTrigger(cronExpression));
        }
        catch (IllegalArgumentException e) {
            LOG.error("An illegal argument exception was raised. Make sure the supplied cron expression is valid.", (Throwable)e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    private static final Unit _init_$lambda$0(MailScheduler this$0) {
        this$0.startMailCron();
        return Unit.INSTANCE;
    }

    private static final void startMailCron$lambda$3(MailScheduler this$0) {
        LOG.info("Starting MailCron job...");
        long numberOfSentMails = this$0.mailService.sendUnreadChatMails();
        LOG.info("MailCron job finished. " + numberOfSentMails + " mails were sent.");
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

