/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.client.RegisteredClients;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.UpsertStatement;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0012\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository;", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "<init>", "()V", "save", "", "registeredClient", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "findById", "id", "", "findByClientId", "clientId", "toRegisteredClient", "it", "Lorg/jetbrains/exposed/sql/ResultRow;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nExposedRegisteredClientRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedRegisteredClientRepository.kt\nde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1#2:124\n1557#3:125\n1628#3,3:126\n1557#3:129\n1628#3,3:130\n1557#3:133\n1628#3,3:134\n1557#3:137\n1628#3,3:138\n*S KotlinDebug\n*F\n+ 1 ExposedRegisteredClientRepository.kt\nde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository\n*L\n30#1:125\n30#1:126,3\n32#1:129\n32#1:130,3\n101#1:133\n101#1:134,3\n106#1:137\n106#1:138,3\n*E\n"})
public class ExposedRegisteredClientRepository
implements RegisteredClientRepository {
    public void save(@NotNull RegisteredClient registeredClient) {
        Intrinsics.checkNotNullParameter((Object)registeredClient, (String)"registeredClient");
        QueriesKt.upsert$default((Table)((Table)RegisteredClients.INSTANCE), (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> ExposedRegisteredClientRepository.save$lambda$2(registeredClient, arg_0, arg_1), (int)14, null);
    }

    @Nullable
    public RegisteredClient findById(@NotNull String id) {
        RegisteredClient registeredClient;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)RegisteredClients.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eqEntityIDValue((ExpressionWithColumnType)RegisteredClients.INSTANCE.getId(), (Object)UUID.fromString(id)))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            registeredClient = this.toRegisteredClient(it);
        } else {
            registeredClient = null;
        }
        return registeredClient;
    }

    @Nullable
    public RegisteredClient findByClientId(@NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)RegisteredClients.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)RegisteredClients.INSTANCE.getClientId(), (Object)clientId))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            return this.toRegisteredClient(it);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private RegisteredClient toRegisteredClient(ResultRow it) {
        TenantId tenantId;
        TokenSettings tokenSettings = TokenSettings.builder().accessTokenFormat(new OAuth2TokenFormat((String)it.get((Expression)RegisteredClients.INSTANCE.getAccessTokenFormat()))).accessTokenTimeToLive((Duration)it.get((Expression)RegisteredClients.INSTANCE.getAccessTokenTimeToLive())).refreshTokenTimeToLive((Duration)it.get((Expression)RegisteredClients.INSTANCE.getRefreshTokenTimeToLive())).reuseRefreshTokens(((Boolean)it.get((Expression)RegisteredClients.INSTANCE.getReuseRefreshTokens())).booleanValue()).authorizationCodeTimeToLive((Duration)it.get((Expression)RegisteredClients.INSTANCE.getAuthorizationCodeTimeToLive())).idTokenSignatureAlgorithm(SignatureAlgorithm.from((String)((String)it.get((Expression)RegisteredClients.INSTANCE.getIdTokenSignatureAlgorithm())))).x509CertificateBoundAccessTokens(((Boolean)it.get((Expression)RegisteredClients.INSTANCE.getX509CertificateBoundAccessTokens())).booleanValue()).build();
        UUID tenantId2 = (UUID)it.get((Expression)RegisteredClients.INSTANCE.getTenantId());
        ClientSettings.Builder builder = ClientSettings.builder().requireProofKey(((Boolean)it.get((Expression)RegisteredClients.INSTANCE.getRequireProofKey())).booleanValue()).requireAuthorizationConsent(((Boolean)it.get((Expression)RegisteredClients.INSTANCE.getRequireAuthorizationConsent())).booleanValue());
        ClientSettings.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"requireAuthorizationConsent(...)");
        UUID uUID = tenantId2;
        if (uUID != null) {
            void it2;
            UUID uUID2 = uUID;
            ClientSettings.Builder builder3 = builder2;
            boolean bl = false;
            tenantId = TenantId.Companion.fromValue((UUID)it2);
            builder2 = builder3;
        } else {
            tenantId = null;
        }
        ClientSettings clientSettings = ExposedRegisteredClientRepositoryKt.tenantId((ClientSettings.Builder)builder2, tenantId).build();
        RegisteredClient registeredClient = RegisteredClient.withId((String)((EntityID)it.get((Expression)RegisteredClients.INSTANCE.getId())).toString()).clientSecret((String)it.get((Expression)RegisteredClients.INSTANCE.getClientSecret())).clientId((String)it.get((Expression)RegisteredClients.INSTANCE.getClientId())).clientName((String)it.get((Expression)RegisteredClients.INSTANCE.getClientName())).clientAuthenticationMethods(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$7(it, arg_0)).authorizationGrantTypes(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$9(it, arg_0)).scopes(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$10(it, arg_0)).redirectUris(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$11(it, arg_0)).postLogoutRedirectUris(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$12(it, arg_0)).clientSettings(clientSettings).tokenSettings(tokenSettings).build();
        Intrinsics.checkNotNullExpressionValue((Object)registeredClient, (String)"build(...)");
        return registeredClient;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit save$lambda$2(RegisteredClient $registeredClient, RegisteredClients $this$upsert, UpsertStatement it) {
        AuthorizationGrantType m;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Column column = $this$upsert.getId();
        UUID uUID = UUID.fromString($registeredClient.getId().toString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        it.setWithEntityIdValue(column, (Object)uUID);
        it.set($this$upsert.getClientId(), (Object)$registeredClient.getClientId());
        it.set($this$upsert.getClientName(), (Object)$registeredClient.getClientName());
        it.set($this$upsert.getClientSecret(), (Object)$registeredClient.getClientSecret());
        Column column2 = $this$upsert.getAuthenticationMethods();
        Set set = $registeredClient.getClientAuthenticationMethods();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getClientAuthenticationMethods(...)");
        Iterable iterable = set;
        Column column3 = column2;
        UpsertStatement upsertStatement = it;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ClientAuthenticationMethod clientAuthenticationMethod = (ClientAuthenticationMethod)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(m.getValue());
        }
        collection = (List)destination$iv$iv;
        upsertStatement.set(column3, (Object)StringUtils.collectionToCommaDelimitedString((Collection)collection));
        Column column4 = $this$upsert.getAuthorizationGrantTypes();
        Set set2 = $registeredClient.getAuthorizationGrantTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAuthorizationGrantTypes(...)");
        $this$map$iv = set2;
        column3 = column4;
        upsertStatement = it;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void t;
            m = (AuthorizationGrantType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(t.getValue());
        }
        collection = (List)destination$iv$iv;
        upsertStatement.set(column3, (Object)StringUtils.collectionToCommaDelimitedString(collection));
        it.set($this$upsert.getScopes(), (Object)StringUtils.collectionToCommaDelimitedString((Collection)$registeredClient.getScopes()));
        it.set($this$upsert.getRedirectUris(), (Object)StringUtils.collectionToCommaDelimitedString((Collection)$registeredClient.getRedirectUris()));
        it.set($this$upsert.getPostLogoutRedirectUris(), (Object)StringUtils.collectionToCommaDelimitedString((Collection)$registeredClient.getPostLogoutRedirectUris()));
        TokenSettings tokenSettings = $registeredClient.getTokenSettings();
        it.set($this$upsert.getAccessTokenFormat(), (Object)tokenSettings.getAccessTokenFormat().getValue());
        it.set($this$upsert.getAccessTokenTimeToLive(), (Object)tokenSettings.getAccessTokenTimeToLive());
        it.set($this$upsert.getIdTokenSignatureAlgorithm(), (Object)tokenSettings.getIdTokenSignatureAlgorithm().name());
        it.set($this$upsert.getDeviceCodeTimeToLive(), (Object)tokenSettings.getDeviceCodeTimeToLive());
        it.set($this$upsert.getReuseRefreshTokens(), (Object)tokenSettings.isReuseRefreshTokens());
        it.set($this$upsert.getAuthorizationCodeTimeToLive(), (Object)tokenSettings.getAuthorizationCodeTimeToLive());
        it.set($this$upsert.getX509CertificateBoundAccessTokens(), (Object)tokenSettings.isX509CertificateBoundAccessTokens());
        it.set($this$upsert.getRefreshTokenTimeToLive(), (Object)tokenSettings.getRefreshTokenTimeToLive());
        TenantId tenantId = ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)$registeredClient);
        it.set($this$upsert.getTenantId(), (Object)(tenantId != null ? tenantId.getValue() : null));
        it.set($this$upsert.getRequireProofKey(), (Object)$registeredClient.getClientSettings().isRequireProofKey());
        it.set($this$upsert.getRequireAuthorizationConsent(), (Object)$registeredClient.getClientSettings().isRequireAuthorizationConsent());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void toRegisteredClient$lambda$7(ResultRow $it, Set methods) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getAuthenticationMethods())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        Iterable iterable = set;
        Set set2 = methods;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClientAuthenticationMethod((String)it));
        }
        set2.addAll((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final void toRegisteredClient$lambda$9(ResultRow $it, Set grantTypes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getAuthorizationGrantTypes())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        Iterable iterable = set;
        Set set2 = grantTypes;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AuthorizationGrantType((String)it));
        }
        set2.addAll((List)destination$iv$iv);
    }

    private static final void toRegisteredClient$lambda$10(ResultRow $it, Set scopes) {
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getScopes())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        scopes.addAll(set);
    }

    private static final void toRegisteredClient$lambda$11(ResultRow $it, Set uris) {
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getRedirectUris())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        uris.addAll(set);
    }

    private static final void toRegisteredClient$lambda$12(ResultRow $it, Set uris) {
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getPostLogoutRedirectUris())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        uris.addAll(set);
    }
}

