/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.toolbox.type;

import de.justsoftware.admin.mybatis.toolbox.type.TypeHandlers;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.LongFunction;
import java.util.function.ToLongFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;

@ParametersAreNonnullByDefault
@MappedJdbcTypes(value={JdbcType.BIGINT}, includeNullJdbcType=true)
public class LongBasedTypeHandler<ID>
extends BaseTypeHandler<ID> {
    private final ToLongFunction<ID> _toLong;
    private final LongFunction<ID> _fromLong;

    public LongBasedTypeHandler(Class<ID> clz, ToLongFunction<ID> toLong) {
        this(TypeHandlers.constructLong(clz), toLong);
    }

    public LongBasedTypeHandler(LongFunction<ID> fromLong, ToLongFunction<ID> toLong) {
        this._fromLong = fromLong;
        this._toLong = toLong;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, ID parameter, JdbcType jdbcType) throws SQLException {
        ps.setLong(i, this._toLong.applyAsLong(parameter));
    }

    public ID getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return (ID)this.getNullableResult(rs.getLong(columnName), rs.wasNull());
    }

    public ID getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return (ID)this.getNullableResult(rs.getLong(columnIndex), rs.wasNull());
    }

    public ID getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (ID)this.getNullableResult(cs.getLong(columnIndex), cs.wasNull());
    }

    private ID getNullableResult(long value, boolean wasNull) {
        return wasNull ? null : (ID)this._fromLong.apply(value);
    }
}

