/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.model;

import de.justsoftware.admin.kafka.publisher.model.KafkaPublishException;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0017\b\u0010\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB\u0015\b\u0010\u0012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "", "kafkaPublishOperations", "", "<init>", "(Ljava/util/List;)V", "waitForOffsets", "Lde/justsoftware/permission/client/kafka/WaitForOffsets;", "(Lde/justsoftware/permission/client/kafka/WaitForOffsets;)V", "waitForOffsetsStream", "Ljava/util/stream/Stream;", "(Ljava/util/stream/Stream;)V", "pendingOperations", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)V", "waitForCompletion", "", "maxWaitTime", "Ljava/time/Duration;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nKafkaPublishOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaPublishOperation.kt\nde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,84:1\n1563#2:85\n1634#2,3:86\n1617#2,9:89\n1869#2:98\n1870#2:100\n1626#2:101\n1#3:99\n37#4:102\n36#4,3:103\n*S KotlinDebug\n*F\n+ 1 KafkaPublishOperation.kt\nde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation\n*L\n24#1:85\n24#1:86,3\n31#1:89,9\n31#1:98\n31#1:100\n31#1:101\n31#1:99\n68#1:102\n68#1:103,3\n*E\n"})
public final class KafkaPublishOperation {
    @NotNull
    private final Stream<WaitForOffsets> waitForOffsets;
    @NotNull
    private final List<CompletableFuture<?>> pendingOperations;

    /*
     * WARNING - void declaration
     */
    public KafkaPublishOperation(@NotNull List<KafkaPublishOperation> kafkaPublishOperations) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(kafkaPublishOperations, (String)"kafkaPublishOperations");
        Iterable iterable = kafkaPublishOperations;
        KafkaPublishOperation kafkaPublishOperation = this;
        boolean $i$f$map22 = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KafkaPublishOperation kafkaPublishOperation2 = (KafkaPublishOperation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.waitForOffsets);
        }
        Stream stream = ((List)destination$iv$iv).stream().flatMap(arg_0 -> KafkaPublishOperation._init_$lambda$2(KafkaPublishOperation::_init_$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        kafkaPublishOperation.waitForOffsets = stream;
        Iterable iterable2 = kafkaPublishOperations;
        kafkaPublishOperation = this;
        boolean $i$f$mapNotNull = false;
        void $i$f$map22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KafkaPublishOperation it = (KafkaPublishOperation)element$iv$iv;
            boolean bl2 = false;
            if (it.pendingOperations == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        kafkaPublishOperation.pendingOperations = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
    }

    public KafkaPublishOperation(@NotNull WaitForOffsets waitForOffsets) {
        Intrinsics.checkNotNullParameter((Object)waitForOffsets, (String)"waitForOffsets");
        Stream<WaitForOffsets> stream = Stream.of(waitForOffsets);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
        this.waitForOffsets = stream;
        this.pendingOperations = CollectionsKt.emptyList();
    }

    public KafkaPublishOperation(@NotNull Stream<WaitForOffsets> waitForOffsetsStream) {
        Intrinsics.checkNotNullParameter(waitForOffsetsStream, (String)"waitForOffsetsStream");
        this.waitForOffsets = waitForOffsetsStream;
        this.pendingOperations = CollectionsKt.emptyList();
    }

    public KafkaPublishOperation(@NotNull CompletableFuture<?> pendingOperations) {
        Intrinsics.checkNotNullParameter(pendingOperations, (String)"pendingOperations");
        Stream<WaitForOffsets> stream = Stream.of(WaitForOffsets.EMPTY);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
        this.waitForOffsets = stream;
        this.pendingOperations = CollectionsKt.listOf(pendingOperations);
    }

    public final void waitForCompletion(@NotNull Duration maxWaitTime) {
        Intrinsics.checkNotNullParameter((Object)maxWaitTime, (String)"maxWaitTime");
        boolean isConsumed = new WaitForOffsets(this.waitForOffsets).waitForOffsets(maxWaitTime);
        if (!isConsumed) {
            throw new KafkaPublishException("WaitForOffsets not consumed within wait time (Kafka not online?)");
        }
        try {
            Collection $this$toTypedArray$iv = this.pendingOperations;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).get(maxWaitTime.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException exception) {
            throw new KafkaPublishException("Operation timed out. PendingOperations not completed within wait time (Kafka not online?)", (Exception)exception);
        }
    }

    public static /* synthetic */ void waitForCompletion$default(KafkaPublishOperation kafkaPublishOperation, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = Duration.ofSeconds(3L);
        }
        kafkaPublishOperation.waitForCompletion(duration);
    }

    private static final Stream _init_$lambda$1(Stream it) {
        return it;
    }

    private static final Stream _init_$lambda$2(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }
}

