/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.auth;

import de.justsoftware.admin.connector.auth.AuthConnector$getMfaMandatory$;
import de.justsoftware.admin.connector.auth.AuthSettings;
import de.justsoftware.admin.graphql.generated.types.ApiToken;
import de.justsoftware.admin.id.TenantId;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/admin/connector/auth/AuthConnector;", "", "authInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "getScimToken", "Lde/justsoftware/admin/graphql/generated/types/ApiToken;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "generateScimToken", "deleteScimToken", "", "setMfaMandatory", "", "mfaMandatory", "getMfaMandatory", "(Lde/justsoftware/admin/id/TenantId;)Ljava/lang/Boolean;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAuthConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthConnector.kt\nde/justsoftware/admin/connector/auth/AuthConnector\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,71:1\n43#2:72\n*S KotlinDebug\n*F\n+ 1 AuthConnector.kt\nde/justsoftware/admin/connector/auth/AuthConnector\n*L\n65#1:72\n*E\n"})
public class AuthConnector {
    @NotNull
    private final RestClient restClient;

    public AuthConnector(@Value(value="${just.auth.internal}") @NotNull String authInternalUrl, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)authInternalUrl, (String)"authInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        RestClient restClient = restClientBuilder.baseUrl(authInternalUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.restClient = restClient;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    @Nullable
    public ApiToken getScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (ApiToken)this.getRestClient().get().uri(arg_0 -> AuthConnector.getScimToken$lambda$0(tenantId, arg_0)).retrieve().toEntity(ApiToken.class).getBody();
    }

    @NotNull
    public ApiToken generateScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Object object = ((RestClient.RequestBodySpec)this.getRestClient().post().uri(arg_0 -> AuthConnector.generateScimToken$lambda$1(tenantId, arg_0))).retrieve().toEntity(ApiToken.class).getBody();
        Intrinsics.checkNotNull((Object)object);
        return (ApiToken)object;
    }

    public boolean deleteScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.getRestClient().delete().uri(arg_0 -> AuthConnector.deleteScimToken$lambda$2(tenantId, arg_0)).retrieve().toBodilessEntity();
        return true;
    }

    public void setMfaMandatory(@NotNull TenantId tenantId, boolean mfaMandatory) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ((RestClient.RequestBodySpec)this.getRestClient().post().uri("/settings/" + tenantId + "/mfaMandatory/" + mfaMandatory, new Object[0])).contentType(MediaType.APPLICATION_JSON).retrieve().toBodilessEntity();
    }

    @Nullable
    public Boolean getMfaMandatory(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = this.getRestClient().get().uri("/settings/" + tenantId, new Object[0]).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        AuthSettings authSettings = (AuthSettings)$this$body$iv.body((ParameterizedTypeReference)new getMfaMandatory$$inlined$body$1());
        return authSettings != null ? Boolean.valueOf(authSettings.getMfaMandatory()) : null;
    }

    private static final URI getScimToken$lambda$0(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI generateScimToken$lambda$1(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI deleteScimToken$lambda$2(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }
}

