/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.cloud.storage.transfermanager.DownloadResult;
import com.google.cloud.storage.transfermanager.ParallelDownloadConfig;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

@BetaApi
public final class DownloadJob {
    private final @NonNull List<ApiFuture<DownloadResult>> downloadResults;
    private final @NonNull ParallelDownloadConfig parallelDownloadConfig;

    private DownloadJob(@NonNull List<ApiFuture<DownloadResult>> downloadResults, @NonNull ParallelDownloadConfig parallelDownloadConfig) {
        this.downloadResults = downloadResults;
        this.parallelDownloadConfig = parallelDownloadConfig;
    }

    @BetaApi
    public @NonNull List<DownloadResult> getDownloadResults() {
        return (List)ApiExceptions.callAndTranslateApiException((ApiFuture)ApiFutures.allAsList(this.downloadResults));
    }

    @BetaApi
    public @NonNull ParallelDownloadConfig getParallelDownloadConfig() {
        return this.parallelDownloadConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadJob)) {
            return false;
        }
        DownloadJob that = (DownloadJob)o;
        return this.downloadResults.equals(that.downloadResults) && this.parallelDownloadConfig.equals(that.parallelDownloadConfig);
    }

    public int hashCode() {
        return Objects.hash(this.downloadResults, this.parallelDownloadConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("downloadResults", this.downloadResults).add("parallelDownloadConfig", (Object)this.parallelDownloadConfig).toString();
    }

    @BetaApi
    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi
    public static final class Builder {
        private @NonNull List<ApiFuture<DownloadResult>> downloadResults = ImmutableList.of();
        private @MonotonicNonNull ParallelDownloadConfig parallelDownloadConfig;

        private Builder() {
        }

        @BetaApi
        public Builder setDownloadResults(@NonNull List<ApiFuture<DownloadResult>> downloadResults) {
            this.downloadResults = ImmutableList.copyOf(downloadResults);
            return this;
        }

        @BetaApi
        public Builder setParallelDownloadConfig(@NonNull ParallelDownloadConfig parallelDownloadConfig) {
            this.parallelDownloadConfig = parallelDownloadConfig;
            return this;
        }

        @BetaApi
        public DownloadJob build() {
            Preconditions.checkNotNull(this.downloadResults);
            Preconditions.checkNotNull((Object)this.parallelDownloadConfig);
            return new DownloadJob(this.downloadResults, this.parallelDownloadConfig);
        }
    }
}

