/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

interface FloatComp {
    public int compare(float var1, float var2);

    public float resetValue();

    public static class FloatDesc
    implements FloatComp {
        @Override
        public float resetValue() {
            return -3.4028235E38f;
        }

        @Override
        public int compare(float a, float b) {
            return Float.compare(a, b);
        }
    }

    public static class FloatAsc
    implements FloatComp {
        @Override
        public float resetValue() {
            return Float.MAX_VALUE;
        }

        @Override
        public int compare(float a, float b) {
            return Float.compare(b, a);
        }
    }
}

