/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.common.cloud.SolrZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCpTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkCpTool() {
        this(CLIO.getOutStream());
    }

    public ZkCpTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"src").argName("src").hasArg().required(true).desc("Source file or directory, may be local or a Znode.").build(), Option.builder((String)"dst").argName("dst").hasArg().required(true).desc("Destination of copy, may be local or a Znode.").build(), SolrCLI.OPTION_RECURSE, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_VERBOSE);
    }

    @Override
    public String getName() {
        return "cp";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        if (zkHost == null) {
            throw new IllegalStateException("Solr at " + cli.getOptionValue("solrUrl") + " is running in standalone server mode, cp can only be used when running in SolrCloud mode.\n");
        }
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).build();){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            String src = cli.getOptionValue("src");
            String dst = cli.getOptionValue("dst");
            Boolean recurse = Boolean.parseBoolean(cli.getOptionValue("recurse"));
            this.echo("Copying from '" + src + "' to '" + dst + "'. ZooKeeper at " + zkHost);
            boolean srcIsZk = src.toLowerCase(Locale.ROOT).startsWith("zk:");
            boolean dstIsZk = dst.toLowerCase(Locale.ROOT).startsWith("zk:");
            String srcName = src;
            if (srcIsZk) {
                srcName = src.substring(3);
            } else if (srcName.toLowerCase(Locale.ROOT).startsWith("file:")) {
                srcName = srcName.substring(5);
            }
            String dstName = dst;
            if (dstIsZk) {
                dstName = dst.substring(3);
            } else if (dstName.toLowerCase(Locale.ROOT).startsWith("file:")) {
                dstName = dstName.substring(5);
            }
            zkClient.zkTransfer(srcName, Boolean.valueOf(srcIsZk), dstName, Boolean.valueOf(dstIsZk), recurse);
        }
        catch (Exception e) {
            log.error("Could not complete the zk operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

