/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.notificationservice.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/notificationservice/security/WebSecurityConfiguration;", "", "<init>", "()V", "configureSecurity", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "Companion", "notification-service"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] SWAGGER_RESOURCES;
    @NotNull
    private static final String MONITORING_RESOURCE = "/internal/monitoring/**";
    @NotNull
    private static final String MOBILE_PUSH_TOKEN_MIGRATION_RESOURCE = "/internal/mobile-push-token-migration/**";
    @NotNull
    private static final String INTERNAL_RESOURCE = "/internal/notification/**";

    @Bean
    @NotNull
    public SecurityFilterChain configureSecurity(@NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter = new JwtAuthenticationProcessingFilter(jwtVerifier).applyIgnoreFilterMatcher(WebSecurityConfiguration::configureSecurity$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)jwtAuthenticationProcessingFilter, (String)"applyIgnoreFilterMatcher(...)");
        JwtAuthenticationProcessingFilter jwt = jwtAuthenticationProcessingFilter;
        http.sessionManagement(WebSecurityConfiguration::configureSecurity$lambda$1).exceptionHandling(Customizer.withDefaults()).anonymous(Customizer.withDefaults()).csrf(WebSecurityConfiguration::configureSecurity$lambda$2).headers(WebSecurityConfiguration::configureSecurity$lambda$3).authorizeHttpRequests(WebSecurityConfiguration::configureSecurity$lambda$4).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final boolean configureSecurity$lambda$0(HttpServletRequest it) {
        return new AntPathRequestMatcher(MONITORING_RESOURCE).matches(it);
    }

    private static final void configureSecurity$lambda$1(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void configureSecurity$lambda$2(CsrfConfigurer it) {
        it.disable();
    }

    private static final void configureSecurity$lambda$3(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void configureSecurity$lambda$4(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        String[] stringArray = SWAGGER_RESOURCES;
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(Arrays.copyOf(stringArray, stringArray.length))).permitAll();
        stringArray = new String[]{MONITORING_RESOURCE};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{MOBILE_PUSH_TOKEN_MIGRATION_RESOURCE};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{INTERNAL_RESOURCE};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    static {
        String[] stringArray = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        SWAGGER_RESOURCES = stringArray;
    }
}

