/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import de.justsoftware.notificationservice.persistence.UserGroupMemberRepository;
import de.justsoftware.notificationservice.persistence.model.DbUserGroupMember;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/notificationservice/business/UserGroupMemberService;", "", "userGroupMemberRepository", "Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;", "<init>", "(Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;)V", "updateMembers", "", "membersToSave", "", "Lde/justsoftware/notificationservice/persistence/model/DbUserGroupMember;", "membersToDelete", "getUserGroupMembershipChecksum", "", "notification-service"})
public class UserGroupMemberService {
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;

    public UserGroupMemberService(@NotNull UserGroupMemberRepository userGroupMemberRepository) {
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        this.userGroupMemberRepository = userGroupMemberRepository;
    }

    @Transactional
    public void updateMembers(@NotNull List<? extends DbUserGroupMember> membersToSave, @NotNull List<? extends DbUserGroupMember> membersToDelete) {
        Intrinsics.checkNotNullParameter(membersToSave, (String)"membersToSave");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        this.userGroupMemberRepository.saveAll((Iterable)membersToSave);
        this.userGroupMemberRepository.deleteAll((Iterable)membersToDelete);
    }

    @NotNull
    public String getUserGroupMembershipChecksum() {
        String string = this.userGroupMemberRepository.getUserGroupMembershipChecksum();
        if (string == null) {
            string = "";
        }
        return string;
    }
}

