/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import de.justsoftware.notificationservice.business.CommonConfigProperties;
import de.justsoftware.notificationservice.business.JunoRestClientService;
import de.justsoftware.notificationservice.exception.JunoLoginException;
import de.justsoftware.notificationservice.exception.JunoUnauthorizedException;
import de.justsoftware.notificationservice.exception.NotFoundException;
import de.justsoftware.notificationservice.model.event.JustLicenseChangedEvent;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;
import reactor.netty.http.client.HttpClient;
import reactor.util.retry.Retry;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\"\u001a\u00020\rH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010$\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/justsoftware/notificationservice/business/JunoRestClientService;", "", "junoBasePath", "", "httpClient", "Lreactor/netty/http/client/HttpClient;", "commonConfigProperties", "Lde/justsoftware/notificationservice/business/CommonConfigProperties;", "<init>", "(Ljava/lang/String;Lreactor/netty/http/client/HttpClient;Lde/justsoftware/notificationservice/business/CommonConfigProperties;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "lastAccessToken", "Lde/justsoftware/notificationservice/business/JunoRestClientService$JunoOAuth2AccessTokenResponse;", "lastServiceDisabledException", "Lde/justsoftware/notificationservice/business/JunoRestClientService$ServiceDisabledException;", "sendPushNotifications", "Lde/justsoftware/pushnotification/client/model/PushNotificationResults;", "pushNotifications", "", "onLicenseChanged", "", "event", "Lde/justsoftware/notificationservice/model/event/JustLicenseChangedEvent;", "checkServiceNotDisabled", "Lreactor/core/publisher/Mono;", "", "getAccessToken", "login", "logout", "disableServiceIfFatalLicenseError", "error", "Lde/justsoftware/notificationservice/exception/JunoLoginException;", "performSendPushNotificationsRequest", "accessToken", "performLoginRequest", "license", "Companion", "JunoOAuth2AccessTokenResponse", "ServiceDisabledException", "notification-service"})
@SourceDebugExtension(value={"SMAP\nJunoRestClientService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JunoRestClientService.kt\nde/justsoftware/notificationservice/business/JunoRestClientService\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n+ 3 ClientResponseExtensions.kt\norg/springframework/web/reactive/function/client/ClientResponseExtensionsKt\n+ 4 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,168:1\n137#2:169\n137#2:170\n38#3:171\n8#4:172\n7#4,3:173\n*S KotlinDebug\n*F\n+ 1 JunoRestClientService.kt\nde/justsoftware/notificationservice/business/JunoRestClientService\n*L\n128#1:169\n144#1:170\n138#1:171\n147#1:172\n147#1:173,3\n*E\n"})
public final class JunoRestClientService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final CommonConfigProperties commonConfigProperties;
    @NotNull
    private final WebClient webClient;
    @Nullable
    private volatile JunoOAuth2AccessTokenResponse lastAccessToken;
    @Nullable
    private volatile ServiceDisabledException lastServiceDisabledException;
    @NotNull
    private static final Logger LOG;

    public JunoRestClientService(@NotNull String junoBasePath, @NotNull HttpClient httpClient, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePath, (String)"junoBasePath");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        this.commonConfigProperties = commonConfigProperties;
        String[] stringArray = new String[]{"application/json"};
        WebClient webClient = WebClient.builder().baseUrl(junoBasePath).defaultHeader("Accept", stringArray).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        this.webClient = webClient;
    }

    @NotNull
    public final PushNotificationResults sendPushNotifications(@NotNull List<? extends Object> pushNotifications) {
        Intrinsics.checkNotNullParameter(pushNotifications, (String)"pushNotifications");
        Mono mono = this.checkServiceNotDisabled().then(this.getAccessToken()).flatMap(arg_0 -> JunoRestClientService.sendPushNotifications$lambda$1(arg_0 -> JunoRestClientService.sendPushNotifications$lambda$0(this, pushNotifications, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        Mono mono2 = MonoExtensionsKt.doOnError((Mono)MonoExtensionsKt.doOnError((Mono)mono, (KClass)Reflection.getOrCreateKotlinClass(JunoLoginException.class), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (KClass)Reflection.getOrCreateKotlinClass(JunoUnauthorizedException.class), arg_0 -> JunoRestClientService.sendPushNotifications$lambda$2(this, arg_0)).retryWhen((Retry)Retry.max((long)1L).filter(arg_0 -> JunoRestClientService.sendPushNotifications$lambda$4(JunoRestClientService::sendPushNotifications$lambda$3, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"retryWhen(...)");
        PushNotificationResults pushNotificationResults = (PushNotificationResults)MonoExtensionsKt.onErrorMap((Mono)mono2, (KClass)Reflection.getOrCreateKotlinClass(ServiceDisabledException.class), (Function1)((Function1)sendPushNotifications.5.INSTANCE)).block();
        if (pushNotificationResults == null) {
            throw new NotFoundException("Juno did not return a result");
        }
        return pushNotificationResults;
    }

    @EventListener
    public final void onLicenseChanged(@NotNull JustLicenseChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.lastServiceDisabledException == null) {
            return;
        }
        LOG.info("Just license changed, retry logging into Juno");
        this.logout();
        this.lastServiceDisabledException = null;
    }

    private final Mono checkServiceNotDisabled() {
        Mono mono = Mono.fromSupplier(() -> JunoRestClientService.checkServiceNotDisabled$lambda$5(this)).flatMap(arg_0 -> JunoRestClientService.checkServiceNotDisabled$lambda$7(JunoRestClientService::checkServiceNotDisabled$lambda$6, arg_0)).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"ignoreElement(...)");
        return mono;
    }

    private final Mono<JunoOAuth2AccessTokenResponse> getAccessToken() {
        Mono mono = Mono.fromSupplier(() -> JunoRestClientService.getAccessToken$lambda$8(this)).filter(arg_0 -> JunoRestClientService.getAccessToken$lambda$10(JunoRestClientService::getAccessToken$lambda$9, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"filter(...)");
        return MonoExtensionsKt.switchIfEmpty((Mono)mono, () -> JunoRestClientService.getAccessToken$lambda$13(this));
    }

    private final Mono<JunoOAuth2AccessTokenResponse> login() {
        Mono mono = Mono.fromCallable(() -> JunoRestClientService.login$lambda$14((KMutableProperty0)new /* Unavailable Anonymous Inner Class!! */)).switchIfEmpty(Mono.error((Throwable)((Throwable)new JunoLoginException(JunoLoginException.ErrorCode.LICENSE_NOT_FOUND)))).flatMap(arg_0 -> JunoRestClientService.login$lambda$15((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private final void logout() {
        this.lastAccessToken = null;
    }

    private final void disableServiceIfFatalLicenseError(JunoLoginException error) {
        if (error.isFatalLicenseError()) {
            LOG.info("Received fatal Just license error, stop sending requests to Juno until license is updated");
            this.lastServiceDisabledException = new ServiceDisabledException(error);
        }
    }

    private final Mono<PushNotificationResults> performSendPushNotificationsRequest(List<? extends Object> pushNotifications, JunoOAuth2AccessTokenResponse accessToken) {
        String[] stringArray = new String[]{"application/json"};
        WebClient.RequestHeadersSpec requestHeadersSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/notification", new Object[0])).bodyValue(pushNotifications).header("Content-Type", stringArray);
        stringArray = new String[]{accessToken.getTokenType() + " " + accessToken.getAccessToken()};
        WebClient.ResponseSpec responseSpec = requestHeadersSpec.header("Authorization", stringArray).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), JunoRestClientService::performSendPushNotificationsRequest$lambda$16);
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono;
    }

    private final Mono<JunoOAuth2AccessTokenResponse> performLoginRequest(String license) {
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/login", new Object[0])).bodyValue((Object)license).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), JunoRestClientService::performLoginRequest$lambda$18).onStatus(JunoRestClientService::performLoginRequest$lambda$19, JunoRestClientService::performLoginRequest$lambda$20);
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono;
    }

    private static final Mono sendPushNotifications$lambda$0(JunoRestClientService this$0, List $pushNotifications, JunoOAuth2AccessTokenResponse accessToken) {
        Intrinsics.checkNotNull((Object)accessToken);
        return this$0.performSendPushNotificationsRequest($pushNotifications, accessToken);
    }

    private static final Mono sendPushNotifications$lambda$1(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Unit sendPushNotifications$lambda$2(JunoRestClientService this$0, JunoUnauthorizedException it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logout();
        return Unit.INSTANCE;
    }

    private static final boolean sendPushNotifications$lambda$3(Throwable it) {
        return it instanceof JunoUnauthorizedException;
    }

    private static final boolean sendPushNotifications$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Exception checkServiceNotDisabled$lambda$5(JunoRestClientService this$0) {
        return (Exception)this$0.lastServiceDisabledException;
    }

    private static final Mono checkServiceNotDisabled$lambda$6(Exception it) {
        return Mono.error((Throwable)it);
    }

    private static final Mono checkServiceNotDisabled$lambda$7(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final JunoOAuth2AccessTokenResponse getAccessToken$lambda$8(JunoRestClientService this$0) {
        return this$0.lastAccessToken;
    }

    private static final boolean getAccessToken$lambda$9(JunoOAuth2AccessTokenResponse it) {
        return it.isValid();
    }

    private static final boolean getAccessToken$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit getAccessToken$lambda$13$lambda$11(JunoRestClientService this$0, JunoOAuth2AccessTokenResponse it) {
        this$0.lastAccessToken = it;
        return Unit.INSTANCE;
    }

    private static final void getAccessToken$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Mono getAccessToken$lambda$13(JunoRestClientService this$0) {
        Mono mono = this$0.login().doOnNext(arg_0 -> JunoRestClientService.getAccessToken$lambda$13$lambda$12(arg_0 -> JunoRestClientService.getAccessToken$lambda$13$lambda$11(this$0, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
        return mono;
    }

    private static final String login$lambda$14(KMutableProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    private static final Mono login$lambda$15(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono performSendPushNotificationsRequest$lambda$16(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new JunoUnauthorizedException()));
    }

    private static final JunoLoginException performLoginRequest$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        return (JunoLoginException)$tmp0.invoke(p0);
    }

    private static final Mono performLoginRequest$lambda$18(ClientResponse response) {
        Intrinsics.checkNotNull((Object)response);
        ClientResponse $this$bodyToMono$iv = response;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono.map(arg_0 -> JunoRestClientService.performLoginRequest$lambda$18$lambda$17((Function1)performLoginRequest.2.1.INSTANCE, arg_0));
    }

    private static final boolean performLoginRequest$lambda$19(HttpStatusCode it) {
        return it.isError();
    }

    private static final Mono performLoginRequest$lambda$20(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new JunoLoginException(JunoLoginException.ErrorCode.OTHER)));
    }

    public static final /* synthetic */ void access$disableServiceIfFatalLicenseError(JunoRestClientService $this, JunoLoginException error) {
        $this.disableServiceIfFatalLicenseError(error);
    }

    public static final /* synthetic */ Mono access$performLoginRequest(JunoRestClientService $this, String license) {
        return $this.performLoginRequest(license);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

