/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Objects;

public class ProducerIdsBlock {
    public static final int PRODUCER_ID_BLOCK_SIZE = 1000;
    public static final ProducerIdsBlock EMPTY = new ProducerIdsBlock(-1, 0L, 0);
    private final int assignedBrokerId;
    private final long firstProducerId;
    private final int blockSize;

    public ProducerIdsBlock(int assignedBrokerId, long firstProducerId, int blockSize) {
        this.assignedBrokerId = assignedBrokerId;
        this.firstProducerId = firstProducerId;
        this.blockSize = blockSize;
    }

    public int assignedBrokerId() {
        return this.assignedBrokerId;
    }

    public long firstProducerId() {
        return this.firstProducerId;
    }

    public int size() {
        return this.blockSize;
    }

    public long lastProducerId() {
        return this.firstProducerId + (long)this.blockSize - 1L;
    }

    public long nextBlockFirstId() {
        return this.firstProducerId + (long)this.blockSize;
    }

    public String toString() {
        return "ProducerIdsBlock(assignedBrokerId=" + this.assignedBrokerId + ", firstProducerId=" + this.firstProducerId + ", size=" + this.blockSize + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProducerIdsBlock that = (ProducerIdsBlock)o;
        return this.assignedBrokerId == that.assignedBrokerId && this.firstProducerId == that.firstProducerId && this.blockSize == that.blockSize;
    }

    public int hashCode() {
        return Objects.hash(this.assignedBrokerId, this.firstProducerId, this.blockSize);
    }
}

