/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.model.Grantee;
import de.justsoftware.wikiservice.application.model.GroupGranteeDto;
import de.justsoftware.wikiservice.application.model.PermissionDto;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.application.model.ProfileGranteeDto;
import de.justsoftware.wikiservice.application.model.UpdatePermissionItemDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.UserGroupService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.DuplicateGranteeIdException;
import de.justsoftware.wikiservice.business.exceptions.NoGranteeException;
import de.justsoftware.wikiservice.business.model.Permission;
import de.justsoftware.wikiservice.business.model.Profile;
import de.justsoftware.wikiservice.business.model.UserGroup;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.PermissionId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.UserGroupId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0012J\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00120\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0012J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J,\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "userGroupService", "Lde/justsoftware/wikiservice/business/UserGroupService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/business/UserGroupService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "republishPermissions", "", "setPermissionsForWikiCreation", "", "Lde/justsoftware/wikiservice/application/model/PermissionDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "granteeId", "Lde/justsoftware/wikiservice/model/GranteeId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "setPermissions", "newPermissions", "", "Lde/justsoftware/wikiservice/model/PermissionType;", "toPermissionDtos", "Lde/justsoftware/wikiservice/model/PermissionId;", "permissions", "", "Lde/justsoftware/wikiservice/business/model/Permission;", "getWikiPermissions", "setWikiPermissions", "updatedPermissions", "Lde/justsoftware/wikiservice/application/model/UpdatePermissionItemDto;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nPermissionApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionApplicationService.kt\nde/justsoftware/wikiservice/application/PermissionApplicationService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,151:1\n136#2,9:152\n216#2:161\n217#2:163\n145#2:164\n136#2,9:165\n216#2:174\n217#2:176\n145#2:177\n1#3:162\n1#3:175\n1#3:188\n1#3:201\n1#3:230\n1#3:249\n1611#4,9:178\n1863#4:187\n1864#4:189\n1620#4:190\n1611#4,9:191\n1863#4:200\n1864#4:202\n1620#4:203\n1863#4,2:204\n1498#4:206\n1528#4,3:207\n1531#4,3:217\n1611#4,9:220\n1863#4:229\n1864#4:231\n1620#4:232\n1246#4,4:235\n1611#4,9:239\n1863#4:248\n1864#4:250\n1620#4:251\n1187#4,2:252\n1261#4,4:254\n1187#4,2:258\n1261#4,4:260\n381#5,7:210\n462#5:233\n412#5:234\n*S KotlinDebug\n*F\n+ 1 PermissionApplicationService.kt\nde/justsoftware/wikiservice/application/PermissionApplicationService\n*L\n50#1:152,9\n50#1:161\n50#1:163\n50#1:164\n51#1:165,9\n51#1:174\n51#1:176\n51#1:177\n50#1:162\n51#1:175\n72#1:188\n74#1:201\n103#1:230\n107#1:249\n72#1:178,9\n72#1:187\n72#1:189\n72#1:190\n74#1:191,9\n74#1:200\n74#1:202\n74#1:203\n81#1:204,2\n91#1:206\n91#1:207,3\n91#1:217,3\n103#1:220,9\n103#1:229\n103#1:231\n103#1:232\n104#1:235,4\n107#1:239,9\n107#1:248\n107#1:250\n107#1:251\n110#1:252,2\n110#1:254,4\n148#1:258,2\n148#1:260,4\n91#1:210,7\n104#1:233\n104#1:234\n*E\n"})
public class PermissionApplicationService {
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final AuthorizationService authorizationService;

    public PermissionApplicationService(@NotNull WikiService wikiService, @NotNull PermissionService permissionService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.wikiService = wikiService;
        this.permissionService = permissionService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.authorizationService = authorizationService;
    }

    public void republishPermissions() {
        this.permissionService.republishPermissions();
    }

    @NotNull
    public List<PermissionDto> setPermissionsForWikiCreation(@NotNull WikiId wikiId, @NotNull GranteeId granteeId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        return this.setPermissions(wikiId, MapsKt.mapOf((Pair)TuplesKt.to((Object)granteeId, (Object)PermissionType.MANAGER)), authContext);
    }

    /*
     * WARNING - void declaration
     */
    private List<PermissionDto> setPermissions(WikiId wikiId, Map<GranteeId, ? extends PermissionType> newPermissions, AuthContext authContext) {
        void $this$groupByTo$iv$iv;
        Iterable element$iv22;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        void $this$mapNotNullTo$iv$iv4;
        Map<GranteeId, ? extends PermissionType> $this$mapNotNull$iv = newPermissions;
        boolean $i$f$mapNotNull = false;
        Map<GranteeId, ? extends PermissionType> map = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv4;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ProfileId it$iv$iv;
            Map.Entry entry;
            Map.Entry element$iv$iv = entry = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (((GranteeId)it.getKey()).toProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set newProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Map<GranteeId, ? extends PermissionType> $this$mapNotNull$iv2 = newPermissions;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach232 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            UserGroupId it$iv$iv;
            Map.Entry element$iv$iv$iv3;
            Map.Entry element$iv$iv = element$iv$iv$iv3 = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl4 = false;
            if (((GranteeId)it.getKey()).toUserGroupId() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set newUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (newPermissions.size() != newProfiles.size() + newUserGroups.size()) {
            throw new DuplicateGranteeIdException();
        }
        Wiki wikiToUpdate = this.wikiService.read(wikiId);
        List wikiPermissions = this.permissionService.getPermissionsByWikiId(wikiId);
        List currentPermissions = CollectionsKt.toList((Iterable)this.toPermissionDtos((Collection)wikiPermissions).values());
        Iterable $this$mapNotNull$iv3 = currentPermissions;
        boolean $i$f$mapNotNull3 = false;
        Iterable $i$f$forEach232 = $this$mapNotNull$iv3;
        Collection collection = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach3 = false;
        Iterator it = $this$forEach$iv$iv$iv3.iterator();
        while (it.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = it.next();
            boolean bl = false;
            PermissionDto it2 = (PermissionDto)element$iv$iv;
            boolean bl6 = false;
            if (it2.getGrantee().getId().toProfileId() == null) continue;
            boolean bl7 = false;
            collection.add(it$iv$iv);
        }
        Set currentProfileIds = CollectionsKt.toSet((Iterable)((List)collection));
        Iterable $this$mapNotNull$iv4 = currentPermissions;
        boolean $i$f$mapNotNull4 = false;
        Iterable iterable = $this$mapNotNull$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo4 = false;
        Iterable $this$forEach$iv$iv$iv4 = iterable;
        boolean $i$f$forEach4 = false;
        Iterator element$iv$iv$iv4 = $this$forEach$iv$iv$iv4.iterator();
        while (element$iv$iv$iv4.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv5;
            Object element$iv$iv = element$iv$iv$iv5 = element$iv$iv$iv4.next();
            boolean bl = false;
            PermissionDto it3 = (PermissionDto)element$iv$iv;
            boolean bl8 = false;
            if (it3.getGrantee().getId().toUserGroupId() == null) continue;
            boolean bl9 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        Set currentUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
        Set addedProfiles = SetsKt.minus((Set)newProfiles, (Iterable)currentProfileIds);
        Set addedUserGroups = SetsKt.minus((Set)newUserGroups, (Iterable)currentUserGroups);
        if (!((Collection)addedProfiles).isEmpty()) {
            this.authorizationService.checkReadProfiles(addedProfiles, authContext.getUser());
            Iterable iterable2 = addedProfiles;
            boolean $i$f$forEach5 = false;
            for (Iterable element$iv22 : iterable2) {
                ProfileId it4 = (ProfileId)element$iv22;
                boolean bl = false;
                this.authorizationService.checkIfProfileMayReadTenant(wikiToUpdate.getTenantId(), it4);
            }
        }
        if (!((Collection)addedUserGroups).isEmpty()) {
            this.authorizationService.checkReadUserGroups(addedUserGroups, authContext.getUser());
        }
        Iterable $this$groupBy$iv = newPermissions.entrySet();
        boolean $i$f$groupBy = false;
        element$iv22 = $this$groupBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it5;
            Object object;
            Map.Entry it6 = (Map.Entry)element$iv$iv;
            boolean $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$332 = false;
            PermissionType key$iv$iv = (PermissionType)it6.getValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Map.Entry $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$332 = (Map.Entry)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((GranteeId)it5.getKey());
        }
        Map map2 = destination$iv$iv5;
        List setPermissions = this.permissionService.setPermissions(wikiId, map2);
        return CollectionsKt.toList((Iterable)this.toPermissionDtos((Collection)setPermissions).values());
    }

    /*
     * WARNING - void declaration
     */
    private Map<PermissionId, PermissionDto> toPermissionDtos(Collection<Permission> permissions) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapValuesTo$iv$iv;
        Object element$iv$iv;
        Object element$iv$iv$iv2;
        Map $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Iterable iterable = permissions;
        Object object = this.profileService;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv2;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId it$iv$iv;
            element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            Permission it = (Permission)element$iv$iv;
            boolean bl2 = false;
            if (it.getGranteeId().toProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map $this$mapValues$iv = object.readByIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        boolean $i$f$mapValues22 = false;
        $this$mapNotNullTo$iv$iv2 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            element$iv$iv = (Map.Entry)element$iv$iv$iv2;
            Object bl = destination$iv$iv;
            boolean bl4 = false;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv2;
            Object k = it$iv$iv.getKey();
            object = bl;
            boolean bl5 = false;
            Profile profile = (Profile)bl2.getValue();
            ProfileDto profileDto = ProfileDto.Companion.toDto(profile);
            object.put(k, profileDto);
        }
        Object profiles = destination$iv$iv;
        Iterable $i$f$mapValues22 = permissions;
        object = this.userGroupService;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv2 = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            Permission it = (Permission)element$iv$iv2;
            boolean bl6 = false;
            if (it.getGranteeId().toUserGroupId() == null) continue;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map userGroups = object.readByIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        Iterable $this$associate$iv = permissions;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            Grantee grantee;
            Map map = destination$iv$iv3;
            Permission it = (Permission)element$iv$iv3;
            boolean bl = false;
            ProfileDto profile = (ProfileDto)profiles.get(it.getGranteeId().toProfileId());
            UserGroup userGroup = (UserGroup)userGroups.get(it.getGranteeId().toUserGroupId());
            if (profile == null && userGroup == null) {
                throw new NoGranteeException(it.getId());
            }
            PermissionId permissionId = it.getId();
            if (userGroup != null) {
                grantee = (Grantee)new GroupGranteeDto(it.getGranteeId(), userGroup.getName(), userGroup.isAllTenantUsersGroup());
            } else if (profile != null) {
                grantee = (Grantee)new ProfileGranteeDto(it.getGranteeId(), profile.getFullName(), StringsKt.replace$default((String)profile.getImageUrl(), (String)"/original/", (String)"/small/", (boolean)false, (int)4, null), profile.getStatus());
            } else {
                throw new NoGranteeException(it.getId());
            }
            Pair pair = TuplesKt.to((Object)permissionId, (Object)PermissionDto.Companion.toDto(it, grantee));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv3;
    }

    @NotNull
    public List<PermissionDto> getWikiPermissions(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        return CollectionsKt.toList((Iterable)this.toPermissionDtos((Collection)this.permissionService.getPermissionsByWikiId(wikiId)).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PermissionDto> setWikiPermissions(@NotNull WikiId wikiId, @NotNull List<UpdatePermissionItemDto> updatedPermissions, @NotNull AuthContext authContext) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(updatedPermissions, (String)"updatedPermissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        Iterable iterable = updatedPermissions;
        WikiId wikiId2 = wikiId;
        PermissionApplicationService permissionApplicationService = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            UpdatePermissionItemDto it = (UpdatePermissionItemDto)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getGranteeId(), (Object)it.getType());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        return permissionApplicationService.setPermissions(wikiId2, map, authContext);
    }
}

