/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.presentation.server.impl;

import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.UserGroupImportService;
import de.justsoftware.onx.migration.business.model.ImportSettings;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.presentation.shared.ImportController;
import de.justsoftware.onx.migration.presentation.shared.model.ImportFailedException;
import de.justsoftware.onx.migration.shared.i18n.ImportMessages;
import de.justsoftware.onx.migration.shared.model.ImportResult;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImportControllerImpl
implements ImportController {
    private static final Logger IMPORT_LOG = LoggerFactory.getLogger((String)"IMPORTLOG");
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired(required=false)
    @Qualifier(value="personImportService")
    private PersonImportService _personImportService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private ImportResultMailService _mailService;
    @Autowired(required=false)
    private UserGroupImportService _userGroupImportService;
    @Autowired
    @Qualifier(value="importTenantIdSupplier")
    private Supplier<TenantId> _tenantIdSupplier;

    public ImportResult importExternalPersons() throws ImportFailedException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        auth.check((Action)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS);
        ImportMessages translations = (ImportMessages)this._i18nService.createProxy(ImportMessages.class, auth.getLocale());
        ImportControllerImpl.checkServiceConfigured((Object)this._personImportService, (String)translations.personImportServiceNotConfigured());
        if (!this._personImportService.isEnabled()) {
            throw new ImportFailedException(translations.personImportServiceNotEnabled());
        }
        try {
            TenantId tenantId = (TenantId)this._tenantIdSupplier.get();
            ImportSettings importSettings = new ImportSettings(tenantId);
            ImportStatistics statistics = this._personImportService.importPersons(importSettings);
            ImportResult result = statistics.toImportResult();
            this._mailService.sendImportResult(auth.getUserId(), statistics);
            return result;
        }
        catch (ImportException e) {
            IMPORT_LOG.error("Import of persons failed", (Throwable)e);
            throw new ImportFailedException(e.getMessage());
        }
    }

    public ImportResult importExternalUserGroups() throws ImportFailedException {
        this._authorizationContextProvider.getAuthorizationContextForCurrentUser().check((Action)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS);
        ImportControllerImpl.checkServiceConfigured((Object)this._userGroupImportService, (String)"No user group import configured");
        try {
            return this._userGroupImportService.importUserGroups().toImportResult();
        }
        catch (ImportException e) {
            IMPORT_LOG.error("Import of user groups failed", (Throwable)e);
            throw new ImportFailedException(e.getMessage());
        }
    }

    private static void checkServiceConfigured(@Nullable Object service, @Nonnull String errorMessage) throws ImportFailedException {
        if (service == null) {
            throw new ImportFailedException(errorMessage);
        }
    }
}

