/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.csv;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.export.csv.server.CSVExportService;
import de.justsoftware.toolbox.http.ContentDispositionUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@ParametersAreNonnullByDefault
public class CSVExportController {
    public static final String UTF_8_BOM = "\ufeff";
    public static final String FILENAME_DATETIME_FORMAT = "dd.MM.yy_HH.mm";
    public static final String CSV_CONTENT_TYPE = "text/comma-separated-values; charset=utf-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVExportController.class);
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final CSVExportService _csvExportService;

    @Autowired
    public CSVExportController(SessionAuthorizationContextProvider authorizationContextProvider, CSVExportService csvExportService) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._csvExportService = csvExportService;
    }

    @Nonnull
    protected static String getDateTimeFilename() {
        return new SimpleDateFormat("dd.MM.yy_HH.mm").format(new Date());
    }

    @RequestMapping(value={"/export/platformMembers"}, method={RequestMethod.GET})
    public void exportPlatformMembersAsCSV(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser(request);
        String csvData = this._csvExportService.getPlatformMembersAsCSV((AuthorizationCheckContextWithUserId)authCtx);
        String outputName = "export_platform_members_" + CSVExportController.getDateTimeFilename() + ".csv";
        this.exportCSV(response, csvData, outputName);
    }

    private void exportCSV(HttpServletResponse response, String csvData, String filename) throws IOException {
        try {
            response.setContentType("text/comma-separated-values; charset=utf-8");
            ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)filename);
            response.getWriter().append("\ufeff").append(csvData).flush();
        }
        catch (NotLoggedInException e) {
            response.sendError(404);
        }
        catch (PermissionDeniedException e) {
            response.sendError(403);
        }
        catch (RuntimeException e) {
            LOGGER.error("Error exporting members", (Throwable)e);
            response.sendError(500);
        }
    }
}

