/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.upload.HasCancelButton;
import de.justsoftware.onx.common.presentation.client.ui.upload.OnUploadHandler;
import de.justsoftware.onx.document.presentation.client.ui.HtmlDocumentUploadWidget;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class HtmlDocumentUploadWidget
extends Composite
implements OnUploadHandler.HasOnUploadHandler,
HasCancelButton {
    private static final String FORM_NAME = "documentUploadFormElement";
    private static final String BR = "<br />";
    private final JCButton _uploadButton = new JCButton(I18nMediator.DOCUMENT.uploadFile());
    private final JCButton _cancelButton = new JCButton();
    private final LoadingDialog _loadingDialog = new LoadingDialog();
    private final SimplePanel _fileUploadPanel = new SimplePanel();
    private boolean _showMessagePopUpAfterUploadComplete = true;
    private OnUploadHandler _onUpload;
    private FileUpload _fileUpload;
    private int _currentSubmitCount = 0;

    public HtmlDocumentUploadWidget(String uploadService) {
        this(uploadService, (Iterable)ImmutableList.of());
    }

    public HtmlDocumentUploadWidget(String uploadService, Iterable<? extends IsWidget> additionalWidgets) {
        FormPanel formPanel = this.createForm(uploadService, additionalWidgets);
        FlowPanel buttonPanel = this.createButtonPanel(formPanel);
        FlowPanel panel = new FlowPanel();
        panel.add((Widget)formPanel);
        panel.add((Widget)buttonPanel);
        panel.addStyleName("documentUploadContainer");
        panel.addStyleName("uploadPanel");
        this.initWidget((Widget)panel);
    }

    @Nonnull
    private FlowPanel createButtonPanel(FormPanel formPanel) {
        FlowPanel buttonPanel = new FlowPanel();
        this._uploadButton.addClickHandler((ClickHandler)new UploadClickHandler(this, formPanel));
        this._uploadButton.addStyleName("btn-ok");
        buttonPanel.add((Widget)this._uploadButton);
        this._cancelButton.addStyleName("btn-cancel");
        buttonPanel.addStyleName("btn-group-confirm");
        buttonPanel.add((Widget)this._cancelButton);
        return buttonPanel;
    }

    @Nonnull
    private FormPanel createForm(String uploadService, Iterable<? extends IsWidget> additionalWidgets) {
        FormPanel formPanel = new FormPanel();
        formPanel.setAction(uploadService);
        formPanel.setEncoding("multipart/form-data");
        formPanel.setMethod("post");
        formPanel.setWidget(this.createFormContent(additionalWidgets));
        formPanel.addSubmitHandler((FormPanel.SubmitHandler)new FileDocumentUploadSubmitHandler(this));
        formPanel.addSubmitCompleteHandler((FormPanel.SubmitCompleteHandler)new FileDocumentUploadSubmitCompleteHandler(this));
        return formPanel;
    }

    @Nonnull
    private Widget createFormContent(Iterable<? extends IsWidget> additionalWidgets) {
        FlowPanel panel = new FlowPanel();
        for (IsWidget isWidget : additionalWidgets) {
            panel.add(isWidget);
        }
        this.createAndAddNewFileUpload();
        panel.add((Widget)this._fileUploadPanel);
        panel.add((Widget)new Hidden("_csrf", Cookies.getCookie((String)"XSRF-TOKEN")));
        return panel;
    }

    private void createAndAddNewFileUpload() {
        this._fileUpload = new FileUpload();
        this._fileUpload.setName("documentUploadFormElement");
        this._fileUploadPanel.setWidget((Widget)this._fileUpload);
    }

    public void setAcceptedFileTypes(Iterable<String> fileTypes) {
        if (!Iterables.isEmpty(fileTypes)) {
            this._fileUpload.getElement().setAttribute("accept", Joiner.on((String)",").join(fileTypes));
        }
    }

    public void setOnUploadHandler(OnUploadHandler onUploadHandler) {
        this._onUpload = onUploadHandler;
    }

    @Nonnull
    private static String getFilenameWithoutDir(String filename) {
        return HtmlDocumentUploadWidget.textAfterSeparator((String)HtmlDocumentUploadWidget.textAfterSeparator((String)filename.trim(), (String)"/"), (String)"\\");
    }

    @Nonnull
    private static String textAfterSeparator(String s, String separator) {
        int index = s.lastIndexOf(separator);
        if (index < 0) {
            return s;
        }
        return s.substring(index + 1);
    }

    public void setShowMessagePopUpAfterUploadComplete(boolean showMessagePopUpAfterUploadComplete) {
        this._showMessagePopUpAfterUploadComplete = showMessagePopUpAfterUploadComplete;
    }

    public void addCancelClickHandler(String text, ClickHandler clickHandler) {
        this._cancelButton.addClickHandler(clickHandler);
        this._cancelButton.setText(text);
        this._cancelButton.setVisible(true);
    }
}

