/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.components.presentation.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.HyperlinkImpl;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class HoverLink
extends Widget
implements HasClickHandlers,
HasText {
    private static final HyperlinkImpl IMPL = (HyperlinkImpl)GWT.create(HyperlinkImpl.class);
    protected final Collection<HandlerRegistration> _clickHandlerRegistrations = new ArrayList();
    private String _linktext = null;
    private final Element _anchorElem;

    public HoverLink(@Nullable String linktext, @Nullable String stylename) {
        this(linktext);
        if (stylename != null) {
            this.addStyleName(stylename);
        }
    }

    public HoverLink(@Nullable String linktext, @Nullable String stylename, ClickHandler handler) {
        this(linktext, stylename);
        this.addClickHandler(handler);
    }

    public HoverLink(@Nullable String linktext) {
        this();
        this.setText(linktext);
    }

    protected HoverLink(Element container) {
        this.setElement(container);
        this._anchorElem = DOM.createAnchor();
        DOM.appendChild((Element)this.getElement(), (Element)this._anchorElem);
        this._anchorElem.setPropertyString("href", "javascript:");
        this.sinkEvents(1);
    }

    public HoverLink() {
        this((Element)DOM.createDiv());
    }

    public void setText(String linktext) {
        this._linktext = linktext;
        this._anchorElem.setInnerText(linktext);
    }

    public void setInnerElement(Element element) {
        this.setText("");
        DOM.appendChild((Element)this._anchorElem, (Element)element);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        HandlerRegistration clickHandler = this.addHandler((EventHandler)handler, (GwtEvent.Type)ClickEvent.getType());
        this._clickHandlerRegistrations.add(clickHandler);
        return clickHandler;
    }

    public void setTabIndex(int index) {
        this._anchorElem.setAttribute("tabindex", String.valueOf(index));
    }

    public void removeAllClickHandlers() {
        for (HandlerRegistration handler : this._clickHandlerRegistrations) {
            handler.removeHandler();
        }
        this._clickHandlerRegistrations.clear();
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        boolean prevent = true;
        switch (DOM.eventGetType((Event)event)) {
            case 1: {
                if (IMPL.handleAsClick(event)) break;
                prevent = false;
                break;
            }
        }
        if (prevent) {
            event.preventDefault();
        }
    }

    public String getText() {
        return this._linktext;
    }
}

