/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.i18n.FooterpagesConstants;
import com.freiheit.toro.common.shared.i18n.LoginConstants;
import com.freiheit.toro.common.shared.model.LegalAgreement;
import com.freiheit.toro.common.shared.model.LoginFooterConfig;
import com.freiheit.toro.common.shared.model.LoginFooterPage;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.design.shared.model.StaticWebResource;
import de.justsoftware.onx.server.LoginPageVisibilityService;
import de.justsoftware.onx.server.model.LoginConfig;
import de.justsoftware.onx.server.model.LoginPageConfig;
import de.justsoftware.web.design.WebResourceHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ParametersAreNonnullByDefault
public class LoginController {
    private static final String SUCCESS_PATH = "/login/success";
    private static final String SSO_PATH = "/login/sso";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final Logger LOG = LoggerFactory.getLogger(LoginController.class);
    private final FrontendLoginService _loginService;
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final LocaleResolver _localeResolver;
    private final WebResourceHandler _webResourceHandler;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final LoginPageVisibilityService _loginPageVisibilityService;
    private final ServerUrlUtil _serverUrlUtil;
    @Value(value="${just.client.libs.path}")
    private String _justClientLibsPath;
    @Value(value="${microsoftTeamsEnabled}")
    private Boolean _microsoftTeamsEnabled;

    @Autowired
    public LoginController(FrontendLoginService loginService, SessionAuthorizationContextProvider authorizationContextProvider, LocaleResolver localeResolver, WebResourceHandler webResourceHandler, Settings settings, I18nService i18nService, ServerUrlUtil serverUrlUtil, LoginPageVisibilityService loginPageVisibilityService) {
        this._loginService = loginService;
        this._authorizationContextProvider = authorizationContextProvider;
        this._localeResolver = localeResolver;
        this._webResourceHandler = webResourceHandler;
        this._settings = settings;
        this._i18nService = i18nService;
        this._serverUrlUtil = serverUrlUtil;
        this._loginPageVisibilityService = loginPageVisibilityService;
    }

    @RequestMapping(value={"/logout"})
    public void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._loginService.logout(request, response);
        response.sendRedirect(this._serverUrlUtil.getSystemDomainPrefix());
    }

    @Nonnull
    @RequestMapping(value={"/login/sso"}, produces={"text/plain"})
    @ResponseBody
    public String showSsoPage() {
        LOG.debug("showSsoPage");
        return "ok";
    }

    @Nonnull
    @RequestMapping(value={"/login/success"}, produces={"text/html"})
    public ModelAndView showSucessPage(Model model) {
        LOG.debug("showSucessPage");
        return new ModelAndView("login_success", model.asMap());
    }

    @Nonnull
    @RequestMapping(value={"/external/login"}, produces={"text/plain"})
    @ResponseBody
    public String showExternalLoginPage() {
        return "external login triggered";
    }

    @Nonnull
    @RequestMapping(value={"/external/login/success"}, produces={"text/plain"})
    @ResponseBody
    public String showExternalLoginSuccess() {
        return "external login succeeded";
    }

    @Nonnull
    @RequestMapping(value={"/external/login/error"})
    public ModelAndView showExternalLoginErrorPage(@RequestParam(name="type", defaultValue="t") String type, @RequestParam(name="objectGUID", required=false) String objectGUID, HttpServletRequest request, HttpServletResponse response) {
        Object errorAttribute = request.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        String locale = this._localeResolver.resolveLocale(request).getLanguage();
        LoginConstants loginMessages = (LoginConstants)this._i18nService.createProxy(LoginConstants.class, locale);
        ImmutableMap resourceNames = this._webResourceHandler.getCurrentResourceNames((Iterable)ImmutableSet.of((Object)StaticWebResource.JUCO_MAIN_CSS), request, response);
        String mainStyleResource = (String)resourceNames.get((Object)StaticWebResource.JUCO_MAIN_CSS);
        ImmutableMap.Builder parameters = ImmutableMap.builder().put((Object)"favIconUrl", (Object)this._settings.getFavIconUrl()).put((Object)"favIconImageType", (Object)this._settings.getFavIconImageType()).put((Object)"mainStyleResource", (Object)mainStyleResource).put((Object)"componentsStyleResource", (Object)(this._justClientLibsPath + "just-client-libs.bundle.css")).put((Object)"internalLogin", (Object)loginMessages.toInternalLoginAfterFailedExternalLogin());
        if (!this.parametersForInternalException(errorAttribute, loginMessages, parameters)) {
            this.parametersForErrorType(type, objectGUID, loginMessages, parameters);
        }
        return new ModelAndView("external_login_error", (Map)parameters.build());
    }

    @Nonnull
    @GetMapping(value={"/login/config"})
    @ResponseBody
    public LoginConfig getLoginConfig(HttpServletRequest request) {
        AuthorizationCheckContext authCtx = this._authorizationContextProvider.getAuthorizationCheckContextForLoggedInOrNotLoggedInUser();
        LoginPageConfig loginPageConfig = this._loginPageVisibilityService.getLoginPageConfig(authCtx);
        List footerLinks = this.getFooterLinks(request);
        String platformTitle = this._settings.getDefaultSiteTitle();
        String favIcon = this._settings.getFavIconUrl();
        return new LoginConfig(loginPageConfig.isAccountActivationPossible(), loginPageConfig.isRequestNewPasswordPossible(), footerLinks, platformTitle, favIcon, this._microsoftTeamsEnabled.booleanValue());
    }

    @Nonnull
    @GetMapping(value={"/login/legalAgreement"})
    @ResponseBody
    public LegalAgreement getLegalAgreement(HttpServletRequest request) {
        String locale = this._localeResolver.resolveLocale(request).getLanguage();
        BasicConstants basicConstants = (BasicConstants)this._i18nService.createProxy(BasicConstants.class, locale);
        return new LegalAgreement(basicConstants.legalAgreementHeader(), basicConstants.legalAgreementText());
    }

    @Nonnull
    private List<LoginFooterConfig> getFooterLinks(HttpServletRequest request) {
        String locale = this._localeResolver.resolveLocale(request).getLanguage();
        FooterpagesConstants footer = (FooterpagesConstants)this._i18nService.createProxy(FooterpagesConstants.class, locale);
        return this.createFooterConfig(footer);
    }

    private boolean parametersForInternalException(Object exception, LoginConstants loginMessages, ImmutableMap.Builder<String, Object> parameters) {
        if (exception instanceof LockedException) {
            parameters.put((Object)TITLE, (Object)loginMessages.blockedUserTitle());
            parameters.put((Object)DESCRIPTION, (Object)loginMessages.blockedUserDescription());
            return true;
        }
        if (exception instanceof AccountExpiredException || exception instanceof DisabledException) {
            parameters.put((Object)TITLE, (Object)loginMessages.inactivateUserTitle());
            parameters.put((Object)DESCRIPTION, (Object)loginMessages.inactivateUserDescription());
            return true;
        }
        return false;
    }

    private void parametersForErrorType(String type, @Nullable String objectGUID, LoginConstants loginMessages, ImmutableMap.Builder<String, Object> parameters) {
        if ("unfe".equals(type)) {
            parameters.put((Object)TITLE, (Object)loginMessages.unknownUserTitle());
            parameters.put((Object)DESCRIPTION, (Object)loginMessages.unknownUserDescription((String)MoreObjects.firstNonNull((Object)objectGUID, (Object)"???")));
        } else {
            parameters.put((Object)TITLE, (Object)loginMessages.otherLoginErrorTitle());
            parameters.put((Object)DESCRIPTION, (Object)loginMessages.otherLoginErrorDescription());
        }
    }

    @Nonnull
    private List<LoginFooterConfig> createFooterConfig(FooterpagesConstants footer) {
        String[] texts;
        ArrayList<LoginFooterConfig> config = new ArrayList<LoginFooterConfig>();
        if (!footer.agb().isBlank()) {
            texts = new String[]{footer.agbTextPart1(), footer.agbTextPart2(), footer.agbTextPart3(), footer.agbTextPart4(), footer.agbTextPart5(), footer.agbTextPart6(), footer.agbTextPart7()};
            config.add(this.getFooterConfigItem(LoginFooterPage.TERMS, footer.agb(), texts));
        }
        if (!footer.datenschutz().isBlank()) {
            texts = new String[]{footer.datenschutzTextPart1(), footer.datenschutzTextPart2(), footer.datenschutzTextPart3(), footer.datenschutzTextPart4()};
            config.add(this.getFooterConfigItem(LoginFooterPage.PRIVACY, footer.datenschutz(), texts));
        }
        if (!footer.impressum().isBlank()) {
            texts = new String[]{footer.impressumText()};
            config.add(this.getFooterConfigItem(LoginFooterPage.IMPRINT, footer.impressum(), texts));
        }
        if (!footer.hilfe().isBlank()) {
            texts = new String[]{footer.hilfeText()};
            config.add(this.getFooterConfigItem(LoginFooterPage.HELP, footer.hilfe(), texts));
        }
        if (!footer.presse().isBlank()) {
            texts = new String[]{footer.presseText()};
            config.add(this.getFooterConfigItem(LoginFooterPage.PRESS, footer.presse(), texts));
        }
        if (!footer.uebertoro().isBlank()) {
            texts = new String[]{footer.uebertoroText(), footer.uebertoroTextPart2(), footer.uebertoroTextPart3()};
            config.add(this.getFooterConfigItem(LoginFooterPage.ABOUT, footer.uebertoro(), texts));
        }
        if (!footer.articlesOfAssociation().isBlank()) {
            texts = new String[]{footer.articlesOfAssociationText()};
            config.add(this.getFooterConfigItem(LoginFooterPage.ARTICLES_OF_ASSOCIATION, footer.articlesOfAssociation(), texts));
        }
        return config;
    }

    @Nonnull
    private LoginFooterConfig getFooterConfigItem(LoginFooterPage key, String title, String[] flowTexts) {
        StringBuilder builder = new StringBuilder();
        for (String item : flowTexts) {
            if (item.isBlank()) continue;
            builder.append(item);
        }
        return new LoginFooterConfig(key, title, builder.toString());
    }
}

