## Authentication and Authorisation

We only support **OAuth 2.0 flows** for authentication purposes.

Supported flows:

- Authorization Code Flow
- Client Credentials Flow
- Password Flow

Available API routes will describe what flow they support as some are bound to have a specific user attached to the
previously obtained *access_token*.

 **Warning**: the **access_token** for the **Authorization Code Flow** and **Password Flow** are **not limited** and allow
a 3rd party application **full access** on the Just Social platform in the context of the logged in user!

## Obtaining API access

If you need an API access please contact our support via [support@justsoftwareag.com](mailto:support@justsoftwareag.com) and tell us what APIs you need access to.  
If you want to use the **Authorization Code Flow** you will also need to provide a **redirect_uri**.

You will be given credentials in the form of **client_id** and **client_secret** over an encrypted channel.

**Warning**: These channels are only accessible once!

## OAuth Request URLs
All data has to be `application/x-www-form-urlencoded` in the body of the requests.

**Token URL:**          `https://$WEB_DOMAIN/auth/oauth2/token`  
**Authorization URL:**  `https://$WEB_DOMAIN/auth/oauth2/authorize` 