/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.config;

import com.google.common.io.Resources;
import de.justsoftware.publicAPI.authorization.AuthContext;
import de.justsoftware.publicAPI.authorization.ProfileAuthContext;
import de.justsoftware.publicAPI.config.OpenAPIConfiguration;
import de.justsoftware.publicAPI.model.ArticleId;
import de.justsoftware.publicAPI.model.ChannelId;
import de.justsoftware.publicAPI.model.PostId;
import de.justsoftware.publicAPI.model.ProfileId;
import de.justsoftware.publicAPI.model.TenantId;
import de.justsoftware.publicAPI.model.WikiId;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@SecurityScheme(type=SecuritySchemeType.OAUTH2, name="oauth2", flows=@OAuthFlows(password=@OAuthFlow(authorizationUrl="/auth/oauth2/authorize", tokenUrl="/auth/oauth2/token", scopes={@OAuthScope(name="user:people.read", description="Read People Profile Data"), @OAuthScope(name="user:wiki.read", description="Read Wiki Article Data"), @OAuthScope(name="user:news.read", description="Read News Post Data")}), clientCredentials=@OAuthFlow(authorizationUrl="/auth/oauth2/authorize", tokenUrl="/auth/oauth2/token", scopes={}), authorizationCode=@OAuthFlow(authorizationUrl="/auth/oauth2/authorize", tokenUrl="/auth/oauth2/token", scopes={@OAuthScope(name="user:people.read", description="Read People Profile Data"), @OAuthScope(name="user:wiki.read", description="Read Wiki Article Data"), @OAuthScope(name="user:news.read", description="Read News Post Data")})))
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\t"}, d2={"Lde/justsoftware/publicAPI/config/OpenAPIConfiguration;", "", "<init>", "()V", "publicAPIDocumentation", "Lio/swagger/v3/oas/models/OpenAPI;", "webDomain", "", "Companion", "public-api-service"})
public class OpenAPIConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Bean
    @NotNull
    public OpenAPI publicAPIDocumentation(@Value(value="${just.webDomain}") @NotNull String webDomain) {
        Intrinsics.checkNotNullParameter((Object)webDomain, (String)"webDomain");
        OpenAPI openAPI = new OpenAPI().security(CollectionsKt.listOf((Object)new SecurityRequirement().addList("oauth2")));
        Info info = new Info().title("Just Public API").version("1.0.0").contact(new Contact().email("support@justsoftwareag.com").name("Just Software AG").url("https://support.just.social/"));
        String string = Resources.toString((URL)Resources.getResource((String)"public-api-description.md"), (Charset)Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        OpenAPI openAPI2 = openAPI.info(info.description(StringsKt.replace$default((String)string, (String)"$WEB_DOMAIN", (String)webDomain, (boolean)false, (int)4, null)));
        Intrinsics.checkNotNullExpressionValue((Object)openAPI2, (String)"info(...)");
        return openAPI2;
    }

    static {
        ModelResolver.enumsAsRef = true;
        Class[] classArray = new Class[]{ProfileAuthContext.class};
        SpringDocUtils springDocUtils = SpringDocUtils.getConfig().addRequestWrapperToIgnore(classArray);
        classArray = new Class[]{AuthContext.class};
        springDocUtils.addRequestWrapperToIgnore(classArray).replaceWithClass(TenantId.class, String.class).replaceWithClass(ArticleId.class, String.class).replaceWithClass(WikiId.class, String.class).replaceWithClass(ProfileId.class, String.class).replaceWithClass(PostId.class, String.class).replaceWithClass(ChannelId.class, String.class);
    }
}

