/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.news.id.UserId;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/util/QuillUtils;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "extractMentions", "", "Lde/justsoftware/news/id/UserId;", "quillDeltaJson", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nQuillUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuillUtils.kt\nde/justsoftware/news/util/QuillUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1869#2,2:37\n*S KotlinDebug\n*F\n+ 1 QuillUtils.kt\nde/justsoftware/news/util/QuillUtils\n*L\n22#1:37,2\n*E\n"})
public final class QuillUtils {
    @NotNull
    public static final QuillUtils INSTANCE = new QuillUtils();
    @NotNull
    private static final Logger log;

    private QuillUtils() {
    }

    @NotNull
    public final Set<UserId> extractMentions(@Nullable String quillDeltaJson) {
        if (quillDeltaJson == null) {
            return SetsKt.emptySet();
        }
        Set userIds = new LinkedHashSet();
        try {
            JsonNode jsonContent = ExtensionsKt.jacksonObjectMapper().readTree(quillDeltaJson);
            JsonNode jsonNode = jsonContent.get("ops");
            if (jsonNode == null) {
                return SetsKt.emptySet();
            }
            JsonNode ops = jsonNode;
            Iterable $this$forEach$iv = (Iterable)ops;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonNode mention;
                JsonNode insert;
                JsonNode it = (JsonNode)element$iv;
                boolean bl = false;
                if (it.get("insert") == null || insert.get("mention") == null) continue;
                String id = mention.get("id").asText();
                Intrinsics.checkNotNull((Object)id);
                userIds.add(UserId.Companion.fromString(id));
            }
        }
        catch (IOException exception) {
            log.error("Error extracting mentions from '" + quillDeltaJson + "'.", (Throwable)exception);
        }
        return CollectionsKt.toSet((Iterable)userIds);
    }

    static {
        Logger logger = LoggerFactory.getLogger(QuillUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

