/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.user;

import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.domain.user.User;
import de.justsoftware.news.domain.user.UserGroup;
import de.justsoftware.news.domain.user.UserGroupMember;
import de.justsoftware.news.domain.user.UserGroupMemberRepo;
import de.justsoftware.news.domain.user.UserGroupRepo;
import de.justsoftware.news.domain.user.UserService$findProfilesByIds$;
import de.justsoftware.news.domain.user.UserService$findUsersByIds$;
import de.justsoftware.news.events.GroupDeletedEvent;
import de.justsoftware.news.events.GroupMembersDeletedEvent;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.UserGroupId;
import de.justsoftware.news.id.UserGroupMemberId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0017J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0017J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0017J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0019H\u0017J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0016\u0010&\u001a\u00020\u00132\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/news/domain/user/UserService;", "", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "userGroupRepo", "Lde/justsoftware/news/domain/user/UserGroupRepo;", "userGroupMemberRepo", "Lde/justsoftware/news/domain/user/UserGroupMemberRepo;", "<init>", "(Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/domain/user/UserGroupRepo;Lde/justsoftware/news/domain/user/UserGroupMemberRepo;)V", "upsertProfile", "Lde/justsoftware/news/domain/user/Profile;", "profile", "upsertUserGroup", "Lde/justsoftware/news/domain/user/UserGroup;", "userGroup", "upsertUserGroupMembers", "", "userGroupMembers", "", "Lde/justsoftware/news/domain/user/UserGroupMember;", "findProfileIdsOfGroup", "", "Lde/justsoftware/news/id/ProfileId;", "userGroupId", "Lde/justsoftware/news/id/UserGroupId;", "findProfilesByIds", "", "profileIds", "findUsersByIds", "Lde/justsoftware/news/domain/user/User;", "userIds", "Lde/justsoftware/news/id/UserId;", "markProfileAsDeleted", "profileId", "deleteUserGroup", "deleteUserGroupMembers", "userGroupMemberIds", "Lde/justsoftware/news/id/UserGroupMemberId;", "news-service"})
@SourceDebugExtension(value={"SMAP\nUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserService.kt\nde/justsoftware/news/domain/user/UserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1563#2:121\n1634#2,3:122\n1869#2,2:125\n1056#2:127\n808#2,11:128\n808#2,11:140\n1056#2:151\n1#3:139\n*S KotlinDebug\n*F\n+ 1 UserService.kt\nde/justsoftware/news/domain/user/UserService\n*L\n59#1:121\n59#1:122,3\n62#1:125,2\n75#1:127\n81#1:128,11\n85#1:140,11\n89#1:151\n*E\n"})
public class UserService {
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final UserGroupRepo userGroupRepo;
    @NotNull
    private final UserGroupMemberRepo userGroupMemberRepo;

    public UserService(@NotNull ApplicationEventPublisher eventPublisher, @NotNull ProfileRepo profileRepo, @NotNull UserGroupRepo userGroupRepo, @NotNull UserGroupMemberRepo userGroupMemberRepo) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)userGroupRepo, (String)"userGroupRepo");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepo, (String)"userGroupMemberRepo");
        this.eventPublisher = eventPublisher;
        this.profileRepo = profileRepo;
        this.userGroupRepo = userGroupRepo;
        this.userGroupMemberRepo = userGroupMemberRepo;
    }

    @Unauthorized
    @NotNull
    public Profile upsertProfile(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profileRepo.findById((Object)profile.getId()).ifPresentOrElse(arg_0 -> UserService.upsertProfile$lambda$1(arg_0 -> UserService.upsertProfile$lambda$0(this, profile, arg_0), arg_0), () -> UserService.upsertProfile$lambda$2(this, profile));
        return profile;
    }

    @Unauthorized
    @NotNull
    public UserGroup upsertUserGroup(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.userGroupRepo.findById((Object)userGroup.getId()).ifPresentOrElse(arg_0 -> UserService.upsertUserGroup$lambda$4(arg_0 -> UserService.upsertUserGroup$lambda$3(this, userGroup, arg_0), arg_0), () -> UserService.upsertUserGroup$lambda$5(this, userGroup));
        return userGroup;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @Transactional
    public void upsertUserGroupMembers(@NotNull Collection<UserGroupMember> userGroupMembers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(userGroupMembers, (String)"userGroupMembers");
        Iterable iterable = userGroupMembers;
        UserGroupMemberRepo userGroupMemberRepo = this.userGroupMemberRepo;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable iterable2 = userGroupMemberRepo.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"findAllById(...)");
        Set updates = CollectionsKt.toSet((Iterable)iterable2);
        this.userGroupMemberRepo.saveAll((Iterable)updates);
        Iterable $this$forEach$iv = CollectionsKt.subtract((Iterable)userGroupMembers, (Iterable)updates);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserGroupMember it = (UserGroupMember)element$iv;
            boolean bl = false;
            this.userGroupMemberRepo.insert(it.getId(), it.getUserGroupId(), it.getProfileId());
        }
    }

    @Unauthorized
    @NotNull
    public Set<ProfileId> findProfileIdsOfGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        return this.userGroupMemberRepo.getProfileIdsByUserGroupId(userGroupId);
    }

    @Unauthorized
    @NotNull
    public List<Profile> findProfilesByIds(@NotNull List<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = this.profileRepo.findAllById((Iterable)profileIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAllById(...)");
        Iterable $this$sortedBy$iv = iterable;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findProfilesByIds$$inlined$sortedBy$1(profileIds)));
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public List<User> findUsersByIds(@NotNull List<? extends UserId> userIds) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstance$iv2;
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Iterable iterable = userIds;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable userGroupIds = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.userGroupRepo.findAllById(userGroupIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"let(...)");
        Iterable userGroups = iterable2;
        userGroupIds = userIds;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List profileIds = (List)destination$iv$iv2;
        boolean bl2 = false;
        Iterable iterable3 = this.profileRepo.findAllById((Iterable)profileIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"let(...)");
        Iterable profiles = iterable3;
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Iterable)userGroups, (Iterable)profiles);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findUsersByIds$$inlined$sortedBy$1(userIds)));
    }

    @Unauthorized
    @Transactional
    public void markProfileAsDeleted(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.upsertProfile(Profile.Companion.deleted(profileId));
        this.eventPublisher.publishEvent((ApplicationEvent)new ProfileDeletedEvent(profileId));
    }

    @Unauthorized
    @Transactional
    public void deleteUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        this.userGroupRepo.deleteById((Object)userGroupId);
        this.eventPublisher.publishEvent((ApplicationEvent)new GroupDeletedEvent(userGroupId));
    }

    @Unauthorized
    @Transactional
    public void deleteUserGroupMembers(@NotNull Collection<UserGroupMemberId> userGroupMemberIds) {
        Intrinsics.checkNotNullParameter(userGroupMemberIds, (String)"userGroupMemberIds");
        this.userGroupMemberRepo.deleteAllById((Iterable)userGroupMemberIds);
        this.eventPublisher.publishEvent((ApplicationEvent)new GroupMembersDeletedEvent(userGroupMemberIds));
    }

    private static final Unit upsertProfile$lambda$0(UserService this$0, Profile $profile, Profile it) {
        this$0.profileRepo.save((Object)$profile);
        return Unit.INSTANCE;
    }

    private static final void upsertProfile$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void upsertProfile$lambda$2(UserService this$0, Profile $profile) {
        this$0.profileRepo.insert($profile.getId(), $profile.getFirstName(), $profile.getLastName(), $profile.getEmail(), $profile.getImageUrl(), $profile.getStatus(), $profile.getPrefix(), $profile.getSuffix(), $profile.getTenantId());
    }

    private static final Unit upsertUserGroup$lambda$3(UserService this$0, UserGroup $userGroup, UserGroup it) {
        this$0.userGroupRepo.save((Object)$userGroup);
        return Unit.INSTANCE;
    }

    private static final void upsertUserGroup$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void upsertUserGroup$lambda$5(UserService this$0, UserGroup $userGroup) {
        this$0.userGroupRepo.insert($userGroup.getId(), $userGroup.getName(), $userGroup.getTenantId());
    }
}

