/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import de.justsoftware.news.domain.post.PinUpdate;
import de.justsoftware.news.domain.post.Post;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\b\u0010\u000f\u001a\u00020\u0005H\u0002R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/news/domain/post/PinUpdate;", "", "pin", "", "pinExpiration", "Ljava/time/Instant;", "publishDate", "origin", "Lde/justsoftware/news/domain/post/Post;", "<init>", "(Ljava/lang/Boolean;Ljava/time/Instant;Ljava/time/Instant;Lde/justsoftware/news/domain/post/Post;)V", "Ljava/lang/Boolean;", "validate", "", "pinnedAt", "calculateWithDefaultPinDuration", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PinUpdate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,547:1\n1#2:548\n*E\n"})
final class PinUpdate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Boolean pin;
    @Nullable
    private final Instant pinExpiration;
    @Nullable
    private final Instant publishDate;
    @NotNull
    private final Post origin;
    private static final long DEFAULT_PIN_DURATION = 14L;

    public PinUpdate(@Nullable Boolean pin, @Nullable Instant pinExpiration, @Nullable Instant publishDate, @NotNull Post origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.pin = pin;
        this.pinExpiration = pinExpiration;
        this.publishDate = publishDate;
        this.origin = origin;
        this.validate();
    }

    private final void validate() {
        if (this.pinExpiration == null) {
            return;
        }
        if (!this.pinExpiration.isAfter(Instant.now())) {
            boolean $i$a$-require-PinUpdate$validate$42 = false;
            String $i$a$-require-PinUpdate$validate$42 = "Pin expiration must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PinUpdate$validate$42.toString());
        }
        if (this.publishDate != null) {
            if (!this.pinExpiration.isAfter(this.publishDate)) {
                boolean $i$a$-require-PinUpdate$validate$52 = false;
                String $i$a$-require-PinUpdate$validate$52 = "'pinExpiration' must be set after publication date.";
                throw new IllegalArgumentException($i$a$-require-PinUpdate$validate$52.toString());
            }
        } else if (!this.pinExpiration.isAfter(this.origin.getPublishDate())) {
            boolean bl = false;
            String string = "'pinExpiration' must be set after publication date.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final Instant pinnedAt() {
        Instant instant;
        Boolean bl = this.pin;
        if (bl == null) {
            instant = this.origin.getPinnedAt();
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            instant = Instant.now();
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            instant = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return instant;
    }

    @Nullable
    public final Instant pinExpiration() {
        if (this.pinExpiration != null) {
            return this.pinExpiration;
        }
        if (this.pin == null) {
            return this.origin.getPinExpiration();
        }
        if (Intrinsics.areEqual((Object)this.pin, (Object)false)) {
            return null;
        }
        return this.calculateWithDefaultPinDuration();
    }

    private final Instant calculateWithDefaultPinDuration() {
        if (this.origin.isPublished()) {
            Instant instant = Instant.now().plus(14L, ChronoUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
            return instant;
        }
        if (this.publishDate == null) {
            Instant instant = this.origin.getPublishDate().plus(14L, ChronoUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
            return instant;
        }
        Instant instant = this.publishDate.plus(14L, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        return instant;
    }
}

