/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migrateditem;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.migrateditem.MigratedItemService;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/domain/migrateditem/MigratedItemDataFetcher;", "", "migratedItemService", "Lde/justsoftware/news/domain/migrateditem/MigratedItemService;", "<init>", "(Lde/justsoftware/news/domain/migrateditem/MigratedItemService;)V", "itemIdForLegacyId", "", "legacyId", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "news-service"})
public class MigratedItemDataFetcher {
    @NotNull
    private final MigratedItemService migratedItemService;

    public MigratedItemDataFetcher(@NotNull MigratedItemService migratedItemService) {
        Intrinsics.checkNotNullParameter((Object)migratedItemService, (String)"migratedItemService");
        this.migratedItemService = migratedItemService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DgsQuery(field="itemIdForLegacyId")
    @Nullable
    public String itemIdForLegacyId(@InputArgument @NotNull String legacyId, @NotNull DgsDataFetchingEnvironment dfe) {
        String string;
        Intrinsics.checkNotNullParameter((Object)legacyId, (String)"legacyId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        ItemId itemId = this.migratedItemService.findItemIdByLegacyId(legacyId, authContext);
        if (itemId == null) return null;
        ItemId it = itemId;
        boolean bl = false;
        ItemId itemId2 = it;
        if (itemId2 instanceof ChannelId) {
            string = ((ChannelId)it).toTypedString();
            return string;
        } else {
            if (!(itemId2 instanceof PostId)) throw new UnsupportedOperationException();
            string = ((PostId)it).toTypedString();
        }
        return string;
    }
}

