/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.service;

import de.justsoftware.mobile.gateway.common.service.UrlService;
import de.justsoftware.mobile.gateway.exception.InvalidWikiIdType;
import de.justsoftware.mobile.gateway.toro.model.local.TranslationLanguage;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import de.justsoftware.mobile.gateway.util.ListsKt;
import de.justsoftware.mobile.gateway.util.NumbersKt;
import de.justsoftware.mobile.gateway.wiki.generated.apis.WikiControllerApi;
import de.justsoftware.mobile.gateway.wiki.generated.models.ChapterDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.Direction;
import de.justsoftware.mobile.gateway.wiki.generated.models.Sort;
import de.justsoftware.mobile.gateway.wiki.generated.models.UpdateSubscriptionDto;
import de.justsoftware.mobile.gateway.wiki.model.Subscription;
import de.justsoftware.mobile.gateway.wiki.model.Wiki;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticle;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticleContent;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticleTranslation;
import de.justsoftware.mobile.gateway.wiki.model.WikiChapter;
import de.justsoftware.mobile.gateway.wiki.model.WikiIdType;
import de.justsoftware.mobile.gateway.wiki.model.WikiIdTypeKt;
import de.justsoftware.mobile.gateway.wiki.model.WikiItem;
import de.justsoftware.mobile.gateway.wiki.service.WikiService;
import de.justsoftware.mobile.gateway.wiki.service.WikiService$getSubscribedWikiItems$;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0001,B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0016J \u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lde/justsoftware/mobile/gateway/wiki/service/WikiService;", "", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "urlService", "Lde/justsoftware/mobile/gateway/common/service/UrlService;", "wikiBaseUrl", "", "commonRequestInitializer", "Lorg/springframework/http/client/ClientHttpRequestInitializer;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;Lde/justsoftware/mobile/gateway/common/service/UrlService;Ljava/lang/String;Lorg/springframework/http/client/ClientHttpRequestInitializer;Lorg/springframework/web/client/RestClient$Builder;)V", "wikiControllerApi", "Lde/justsoftware/mobile/gateway/wiki/generated/apis/WikiControllerApi;", "getWikiTeasers", "", "Lde/justsoftware/mobile/gateway/wiki/model/WikiItem;", "offset", "", "limit", "getSubscribedWikiItems", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/model/Wiki;", "wikiId", "updateSubscription", "Lde/justsoftware/mobile/gateway/wiki/model/Subscription;", "isSubscribed", "", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/model/WikiChapter;", "chapterId", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticle;", "articleId", "translateWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticleTranslation;", "targetLanguage", "Lde/justsoftware/mobile/gateway/toro/model/local/TranslationLanguage;", "content", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticleContent;", "getTitle", "wikiItemId", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nWikiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiService.kt\nde/justsoftware/mobile/gateway/wiki/service/WikiService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1056#2:178\n*S KotlinDebug\n*F\n+ 1 WikiService.kt\nde/justsoftware/mobile/gateway/wiki/service/WikiService\n*L\n79#1:178\n*E\n"})
public class WikiService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;
    @NotNull
    private final UrlService urlService;
    @NotNull
    private final WikiControllerApi wikiControllerApi;

    public WikiService(@NotNull ToroApiGatewayService toroApiGatewayService, @NotNull UrlService urlService, @Value(value="${just.wiki.baseUrl}") @NotNull String wikiBaseUrl, @Qualifier(value="commonRequestInitializer") @NotNull ClientHttpRequestInitializer commonRequestInitializer, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)urlService, (String)"urlService");
        Intrinsics.checkNotNullParameter((Object)wikiBaseUrl, (String)"wikiBaseUrl");
        Intrinsics.checkNotNullParameter((Object)commonRequestInitializer, (String)"commonRequestInitializer");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        this.toroApiGatewayService = toroApiGatewayService;
        this.urlService = urlService;
        RestClient restClient = restClientBuilder.requestInitializer(commonRequestInitializer).baseUrl(wikiBaseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        RestClient restClient2 = restClient;
        this.wikiControllerApi = new WikiControllerApi(restClient2);
    }

    @NotNull
    public List<WikiItem> getWikiTeasers(int offset, int limit) {
        return WikiItem.Companion.WikiPreviewDtosToWikiItems(this.wikiControllerApi.getWikiPreviews(Integer.valueOf(limit > 0 ? NumbersKt.ceilDiv((int)offset, (int)limit) : 0), Integer.valueOf(limit), Sort.SUBSCRIBED, Direction.DESCENDING).getContent());
    }

    @NotNull
    public List<WikiItem> getSubscribedWikiItems(int offset, int limit) {
        Iterable $this$sortedBy$iv = WikiControllerApi.getSubscribedItems$default((WikiControllerApi)this.wikiControllerApi, null, (Integer)200, (int)1, null).getContent();
        boolean $i$f$sortedBy = false;
        return WikiItem.Companion.PageDtoPreviewDtoObjectContentInnersToWikiItems(ListsKt.page((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new getSubscribedWikiItems$$inlined$sortedBy$1())), (int)offset, (int)limit));
    }

    @NotNull
    public Wiki getWiki(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return (Wiki)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public Subscription updateSubscription(@NotNull String wikiId, boolean isSubscribed) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return Subscription.Companion.toSubscription(this.wikiControllerApi.createOrUpdateSubscription(new UpdateSubscriptionDto(isSubscribed, wikiId)));
    }

    @NotNull
    public WikiChapter getWikiChapter(@NotNull String chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        ChapterDto chapterDto = this.wikiControllerApi.getChapter(chapterId);
        String parentTitle = this.getTitle(chapterDto.getParentId());
        return WikiChapter.Companion.toWikiChapter(chapterDto, parentTitle, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public WikiArticle getWikiArticle(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        return (WikiArticle)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public WikiArticleTranslation translateWikiArticle(@NotNull String articleId, @NotNull TranslationLanguage targetLanguage, @NotNull WikiArticleContent content) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        WikiArticleTranslation input = new WikiArticleTranslation(articleId, targetLanguage, content);
        List translations = this.toroApiGatewayService.translate(targetLanguage, Companion.access$toApiTranslationInputs((Companion)Companion, (WikiArticleTranslation)input));
        return Companion.access$translate((Companion)Companion, (WikiArticleTranslation)input, (List)translations);
    }

    private String getTitle(String wikiItemId) {
        WikiIdType wikiIdType = WikiIdTypeKt.getWikiIdType((String)wikiItemId);
        return switch (wikiIdType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[wikiIdType.ordinal()]) {
            case 1 -> this.wikiControllerApi.getWiki(wikiItemId).getTitle();
            case 2 -> this.wikiControllerApi.getChapter(wikiItemId).getTitle();
            case 3 -> WikiControllerApi.getArticle$default((WikiControllerApi)this.wikiControllerApi, (String)wikiItemId, null, (int)2, null).getTitle();
            case -1 -> throw new InvalidWikiIdType(wikiItemId);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ WikiControllerApi access$getWikiControllerApi$p(WikiService $this) {
        return $this.wikiControllerApi;
    }

    public static final /* synthetic */ UrlService access$getUrlService$p(WikiService $this) {
        return $this.urlService;
    }

    public static final /* synthetic */ ToroApiGatewayService access$getToroApiGatewayService$p(WikiService $this) {
        return $this.toroApiGatewayService;
    }

    public static final /* synthetic */ String access$getTitle(WikiService $this, String wikiItemId) {
        return $this.getTitle(wikiItemId);
    }
}

