/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.notification.model.MobilePushToken;
import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.model.NotificationChangeList;
import de.justsoftware.mobile.gateway.notification.model.NotificationsCount;
import de.justsoftware.mobile.gateway.notification.service.NotificationService;
import de.justsoftware.mobile.gateway.util.MobilePlatformVersionsKt;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notifications"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0017J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0017J\u0018\u0010\u0016\u001a\u00020\u00142\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0017J\u001c\u0010\u0018\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u0019\u001a\u00020\nH\u0017J&\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J0\u0010 \u001a\u00020\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010!\u001a\u00020\"2\b\b\u0001\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001c\u0010#\u001a\u00020\u00142\b\b\u0001\u0010$\u001a\u00020\n2\b\b\u0001\u0010\u001d\u001a\u00020\nH\u0017J\u0014\u0010%\u001a\u00020&2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/justsoftware/mobile/gateway/notification/controller/NotificationController;", "", "notificationService", "Lde/justsoftware/mobile/gateway/notification/service/NotificationService;", "<init>", "(Lde/justsoftware/mobile/gateway/notification/service/NotificationService;)V", "getNotifications", "", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "state", "", "limit", "", "date", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "getNotificationsCount", "Lde/justsoftware/mobile/gateway/notification/model/NotificationsCount;", "archiveAllNotifications", "archiveNotification", "", "notificationId", "openNotifications", "notificationIds", "markNotification", "action", "registerAndroid", "Lde/justsoftware/mobile/gateway/notification/model/MobilePushToken;", "publicKey", "pushToken", "request", "Ljakarta/servlet/http/HttpServletRequest;", "registerIos", "silenceAlerts", "", "unregister", "mobilePlatform", "getChanges", "Lde/justsoftware/mobile/gateway/notification/model/NotificationChangeList;", "token", "mobile-gateway"})
public class NotificationController {
    @NotNull
    private final NotificationService notificationService;

    public NotificationController(@NotNull NotificationService notificationService) {
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        this.notificationService = notificationService;
    }

    @GetMapping
    @NotNull
    public List<Notification> getNotifications(@RequestParam(name="state") @NotNull String state, @RequestParam(name="limit") int limit, @RequestParam(name="date") @NotNull String date, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        String string = authContext.getLocale().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.notificationService.getNotifications(state, limit, date, string);
    }

    @GetMapping(value={"/count"})
    @NotNull
    public NotificationsCount getNotificationsCount() {
        return this.notificationService.getNotificationsCount();
    }

    @PutMapping(value={"/archive"})
    @NotNull
    public List<String> archiveAllNotifications() {
        return this.notificationService.archiveAllNotifications();
    }

    @PutMapping(value={"/archive/{id}"})
    public void archiveNotification(@PathVariable(value="id") @NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        this.notificationService.archiveNotification(notificationId);
    }

    @PutMapping(value={"/open"})
    public void openNotifications(@RequestBody @NotNull List<String> notificationIds) {
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        this.notificationService.openNotifications(notificationIds);
    }

    @PutMapping(value={"/{id}/{action}"})
    public void markNotification(@PathVariable(value="id") @NotNull String notificationId, @PathVariable(value="action") @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.notificationService.markNotification(notificationId, action);
    }

    @PostMapping(value={"/push/android"})
    @NotNull
    public MobilePushToken registerAndroid(@RequestParam(value="publicKey") @Nullable String publicKey, @RequestBody @NotNull String pushToken, @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.notificationService.registerAndroid(pushToken, publicKey, MobilePlatformVersionsKt.getAndroidPlatformVersion((HttpServletRequest)request2));
    }

    @PostMapping(value={"/push/ios"})
    @NotNull
    public MobilePushToken registerIos(@RequestParam(value="publicKey") @Nullable String publicKey, @RequestParam(value="silenceAlerts", defaultValue="false") boolean silenceAlerts, @RequestBody @NotNull String pushToken, @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.notificationService.registerIos(pushToken, publicKey, silenceAlerts, MobilePlatformVersionsKt.getIosPlatformVersion((HttpServletRequest)request2));
    }

    @DeleteMapping(value={"/push/{mobilePlatform:android|ios}/{pushToken}"})
    public void unregister(@PathVariable(value="mobilePlatform") @NotNull String mobilePlatform, @PathVariable(value="pushToken") @NotNull String pushToken) {
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        this.notificationService.unregisterPushToken(mobilePlatform, pushToken);
    }

    @GetMapping(value={"/changes"})
    @NotNull
    public NotificationChangeList getChanges(@RequestParam(value="token", required=false) @Nullable String token) {
        return this.notificationService.getChanges(token);
    }
}

