/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.drive.service;

import de.justsoftware.mobile.gateway.drive.model.local.DriveId;
import de.justsoftware.mobile.gateway.drive.model.local.DriveIdType;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiAddFolderData;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiDocumentDetails;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiFolderDetails;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShare;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShares;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$addFolder$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$deleteDocument$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getDocumentDetails$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getFolderDetails$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getShare$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getUnauthorizedAttachmentVideoUrl$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$subscribeToShare$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$uploadTemporaryFiles$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$uploadToFolder$;
import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0016J&\u0010)\u001a\u0002H*\"\u0006\b\u0000\u0010*\u0018\u00012\u0006\u0010+\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0092\b\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0018\u0010.\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u0010/\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0010\u00100\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0012J \u00101\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u00102\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J\u0010\u00103\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J\u0010\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020\u0003H\u0012J\u0010\u00106\u001a\u00020 2\u0006\u00105\u001a\u00020\u0003H\u0012J\u0010\u00107\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0012J\u0010\u00108\u001a\u00020 2\u0006\u00105\u001a\u00020\u0003H\u0012J\b\u00109\u001a\u00020 H\u0012J\u0010\u0010:\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\b\u0010;\u001a\u00020 H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService;", "", "driveApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "getShare", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiShare;", "shareId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$Share;", "getShares", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiShares;", "offset", "", "limit", "subscribeToShare", "", "unsubscribeFromShare", "getFolderDetails", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiFolderDetails;", "folderId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$DriveDocument;", "addFolder", "parentFolderId", "folderName", "getDocumentDetails", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiDocumentDetails;", "documentId", "deleteDocument", "getDownloadAttachmentUri", "Ljava/net/URI;", "getDownloadAttachmentPreviewUri", "getDownloadAttachmentVideoStreamUrl", "getUnauthorizedAttachmentVideoUrl", "uploadTemporaryFiles", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$TempFile;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "uploadToFolder", "uploadFile", "T", "uri", "(Ljava/net/URI;Lorg/springframework/web/multipart/MultipartFile;)Ljava/lang/Object;", "shareUri", "sharesUri", "subscribeToShareUri", "unsubscribeFromShareUri", "folderDetailsUri", "documentDetailsUri", "deleteDocumentUri", "downloadAttachmentUri", "id", "downloadAttachmentPreviewUri", "downloadAttachmentVideoStreamUrl", "driveAccessTokenUri", "tempFileUploadUri", "folderUploadUri", "addFolderUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nDriveApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveApiGatewayService.kt\nde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n111#1,4:186\n111#1,4:191\n48#2:176\n48#2:177\n57#2:178\n57#2:179\n48#2:180\n60#2:181\n48#2:182\n91#2:183\n54#2:184\n60#2:190\n60#2:195\n60#2:196\n1#3:185\n*S KotlinDebug\n*F\n+ 1 DriveApiGatewayService.kt\nde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService\n*L\n98#1:186,4\n108#1:191,4\n29#1:176\n35#1:177\n43#1:178\n46#1:179\n54#1:180\n67#1:181\n76#1:182\n79#1:183\n92#1:184\n98#1:190\n108#1:195\n114#1:196\n*E\n"})
public class DriveApiGatewayService {
    @NotNull
    private final String driveApiUrl;
    @NotNull
    private final WebClient webClient;

    public DriveApiGatewayService(@Value(value="${just.drive.api.url}") @NotNull String driveApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)driveApiUrl, (String)"driveApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.driveApiUrl = driveApiUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiShare getShare(@NotNull DriveId.Share shareId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.shareUri(shareId.getFullyQualifiedId());
        boolean $i$f$get = false;
        return (ApiShare)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getShare$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiShares getShares(int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.sharesUri(offset, limit);
        boolean $i$f$get = false;
        return (ApiShares)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeToShare(@NotNull DriveId.Share shareId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.subscribeToShareUri(shareId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new subscribeToShare$$inlined$post$1((WebClient)$this$post$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribeFromShare(@NotNull DriveId.Share shareId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.unsubscribeFromShareUri(shareId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiFolderDetails getFolderDetails(@NotNull DriveId.DriveDocument folderId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        WebClient webClient = this.webClient;
        URI uRI = this.folderDetailsUri(folderId.getId(), offset, limit);
        boolean $i$f$get = false;
        return (ApiFolderDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getFolderDetails$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String addFolder(@NotNull DriveId.DriveDocument parentFolderId, @NotNull String folderName) {
        void body$iv;
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)parentFolderId, (String)"parentFolderId");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        WebClient webClient = this.webClient;
        URI uRI = this.addFolderUri();
        ApiAddFolderData apiAddFolderData = ApiAddFolderData.Companion.apiAddFolderDataOf(parentFolderId, folderName);
        boolean $i$f$post = false;
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new addFolder$$inlined$post$1((WebClient)$this$post$iv, (URI)uri$iv, (Object)body$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiDocumentDetails getDocumentDetails(@NotNull DriveId.DriveDocument documentId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.documentDetailsUri(documentId.getId());
        boolean $i$f$get = false;
        return (ApiDocumentDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getDocumentDetails$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteDocument(@NotNull DriveId.DriveDocument documentId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteDocumentUri(documentId.getId());
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new deleteDocument$$inlined$delete$1((WebClient)$this$delete$iv, uri$iv, null)), (int)1, null);
    }

    @NotNull
    public URI getDownloadAttachmentUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentUri(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    @NotNull
    public URI getDownloadAttachmentPreviewUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentPreviewUri(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    @NotNull
    public String getDownloadAttachmentVideoStreamUrl(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentVideoStreamUrl(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@NotNull String documentId) {
        Object object;
        block3: {
            block2: {
                void $this$getOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
                Object object2 = this.webClient;
                URI uri$iv = this.driveAccessTokenUri(DriveIdType.Companion.removeDriveIdType(documentId));
                boolean $i$f$getOrNull = false;
                String string = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getUnauthorizedAttachmentVideoUrl$$inlined$getOrNull$1((WebClient)$this$getOrNull$iv, uri$iv, null)), (int)1, null);
                if (string == null) break block2;
                object = new char[]{'\"'};
                object2 = StringsKt.trim((String)string, (char[])object);
                if (object2 == null) break block2;
                Object accessToken = object2;
                boolean bl = false;
                object = "/drive/api/unauthenticated/previewVideoFile/" + (String)accessToken;
                if (object != null) break block3;
            }
            throw new NotFoundException("Could not get accessToken for document: " + documentId);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DriveId.TempFile uploadTemporaryFiles(@NotNull MultipartFile file) {
        void $this$post$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DriveApiGatewayService driveApiGatewayService = this;
        URI uri$iv = this.tempFileUploadUri();
        boolean $i$f$uploadFile = false;
        MultipartBodyBuilder builder$iv = new MultipartBodyBuilder();
        builder$iv.part("files", (Object)file.getResource());
        WebClient webClient = this_$iv.webClient;
        MultiValueMap multiValueMap = builder$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"build(...)");
        MultiValueMap body$iv$iv = multiValueMap;
        boolean $i$f$post = false;
        List ids = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new uploadTemporaryFiles$$inlined$uploadFile$1((WebClient)$this$post$iv$iv, uri$iv, (Object)body$iv$iv, null)), (int)1, null);
        if (ids.size() > 1) {
            throw new IllegalStateException("Received " + ids.size() + " ids for " + file.getOriginalFilename());
        }
        return (DriveId.TempFile)CollectionsKt.first((List)ids);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DriveId.DriveDocument uploadToFolder(@NotNull DriveId.DriveDocument folderId, @NotNull MultipartFile file) {
        void $this$post$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DriveApiGatewayService driveApiGatewayService = this;
        URI uri$iv = this.folderUploadUri(folderId);
        boolean $i$f$uploadFile = false;
        MultipartBodyBuilder builder$iv = new MultipartBodyBuilder();
        builder$iv.part("files", (Object)file.getResource());
        WebClient webClient = this_$iv.webClient;
        MultiValueMap multiValueMap = builder$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"build(...)");
        MultiValueMap body$iv$iv = multiValueMap;
        boolean $i$f$post = false;
        return (DriveId.DriveDocument)BuildersKt.runBlocking$default(null, (Function2)((Function2)new uploadToFolder$$inlined$uploadFile$1((WebClient)$this$post$iv$iv, uri$iv, (Object)body$iv$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ <T> T uploadFile(URI uri, MultipartFile file) {
        void $this$post$iv;
        boolean $i$f$uploadFile = false;
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        builder.part("files", (Object)file.getResource());
        WebClient webClient = this.webClient;
        MultiValueMap multiValueMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"build(...)");
        MultiValueMap body$iv = multiValueMap;
        boolean $i$f$post = false;
        Intrinsics.needClassReification();
        return (T)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI shareUri(String shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/" + shareId + "/withSubscription"), null, null, (int)6, null);
    }

    private URI sharesUri(int offset, int limit) {
        Map map;
        Map $this$sharesUri_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$sharesUri_u24lambda_u241.put("offset", offset);
        $this$sharesUri_u24lambda_u241.put("limit", limit);
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/page"), (Map)params, null, (int)4, null);
    }

    private URI subscribeToShareUri(DriveId.Share shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/subscriptions/" + shareId.getFullyQualifiedId() + "/subscribe"), null, null, (int)6, null);
    }

    private URI unsubscribeFromShareUri(DriveId.Share shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/subscriptions/" + shareId.getFullyQualifiedId() + "/unsubscribe"), null, null, (int)6, null);
    }

    private URI folderDetailsUri(String folderId, int offset, int limit) {
        Map map;
        Map $this$folderDetailsUri_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$folderDetailsUri_u24lambda_u242.put("offset", offset);
        $this$folderDetailsUri_u24lambda_u242.put("limit", limit);
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/folder/" + folderId), (Map)params, null, (int)4, null);
    }

    private URI documentDetailsUri(String documentId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/document/" + documentId), null, null, (int)6, null);
    }

    private URI deleteDocumentUri(String documentId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/file/" + documentId), null, null, (int)6, null);
    }

    private URI downloadAttachmentUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/" + id + "/download"), null, null, (int)6, null);
    }

    private URI downloadAttachmentPreviewUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/previews/previewImage/" + id + "/latest"), null, null, (int)6, null);
    }

    private String downloadAttachmentVideoStreamUrl(String id) {
        return this.driveApiUrl + "/previews/embed/" + id + "/latest";
    }

    private URI driveAccessTokenUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/previews/preview/" + id + "/accessToken"), null, null, (int)6, null);
    }

    private URI tempFileUploadUri() {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/tmp/upload"), null, null, (int)6, null);
    }

    private URI folderUploadUri(DriveId.DriveDocument folderId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/" + folderId.getId() + "/upload"), null, null, (int)6, null);
    }

    private URI addFolderUri() {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/document"), null, null, (int)6, null);
    }
}

