/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestClient;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Configuration(value="mobileGatewayConfiguration")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0012J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0012J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0012\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/ApiGatewayConfiguration;", "", "<init>", "()V", "apiWebClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "maxInMemorySize", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "restClientCustomizer", "Lorg/springframework/boot/web/client/RestClientCustomizer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "commonRequestInitializer", "Lorg/springframework/http/client/ClientHttpRequestInitializer;", "authFilter", "Lorg/springframework/web/reactive/function/client/ExchangeFilterFunction;", "acceptLanguage", "copyHeader", "", "Lorg/springframework/http/client/ClientHttpRequest;", "headerName", "", "fromRequest", "mobile-gateway"})
public class ApiGatewayConfiguration {
    @Bean
    @RequestScope
    @NotNull
    public WebClient apiWebClient(@Value(value="${spring.codec.max-in-memory-size}") int maxInMemorySize, @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        WebClient webClient = WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(arg_0 -> ApiGatewayConfiguration.apiWebClient$lambda$0(maxInMemorySize, arg_0)).build()).filter(this.authFilter(request2)).filter(this.acceptLanguage(request2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    @Bean
    @NotNull
    public RestClientCustomizer restClientCustomizer(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return arg_0 -> ApiGatewayConfiguration.restClientCustomizer$lambda$2(objectMapper, arg_0);
    }

    @Bean
    @RequestScope
    @NotNull
    public ClientHttpRequestInitializer commonRequestInitializer(@NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return arg_0 -> ApiGatewayConfiguration.commonRequestInitializer$lambda$4(this, request2, arg_0);
    }

    private ExchangeFilterFunction authFilter(HttpServletRequest request2) {
        return (arg_0, arg_1) -> ApiGatewayConfiguration.authFilter$lambda$5(request2, arg_0, arg_1);
    }

    private ExchangeFilterFunction acceptLanguage(HttpServletRequest request2) {
        return (arg_0, arg_1) -> ApiGatewayConfiguration.acceptLanguage$lambda$6(request2, arg_0, arg_1);
    }

    private void copyHeader(ClientHttpRequest $this$copyHeader, String headerName, HttpServletRequest fromRequest) {
        $this$copyHeader.getHeaders().add(headerName, fromRequest.getHeader(headerName));
    }

    private static final void apiWebClient$lambda$0(int $maxInMemorySize, ClientCodecConfigurer it) {
        it.defaultCodecs().maxInMemorySize($maxInMemorySize);
    }

    private static final void restClientCustomizer$lambda$2$lambda$1(ObjectMapper $objectMapper, List it) {
        it.add(new MappingJackson2HttpMessageConverter($objectMapper));
    }

    private static final void restClientCustomizer$lambda$2(ObjectMapper $objectMapper, RestClient.Builder builder) {
        builder.messageConverters(arg_0 -> ApiGatewayConfiguration.restClientCustomizer$lambda$2$lambda$1($objectMapper, arg_0));
    }

    private static final void commonRequestInitializer$lambda$4(ApiGatewayConfiguration this$0, HttpServletRequest $request, ClientHttpRequest it) {
        ClientHttpRequest clientHttpRequest;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClientHttpRequest $this$commonRequestInitializer_u24lambda_u244_u24lambda_u243 = clientHttpRequest = it;
        boolean bl = false;
        this$0.copyHeader($this$commonRequestInitializer_u24lambda_u244_u24lambda_u243, "Authorization", $request);
        this$0.copyHeader($this$commonRequestInitializer_u24lambda_u244_u24lambda_u243, "just-token", $request);
        this$0.copyHeader($this$commonRequestInitializer_u24lambda_u244_u24lambda_u243, "Accept-Language", $request);
    }

    private static final Mono authFilter$lambda$5(HttpServletRequest $request, ClientRequest apiGatewayRequest, ExchangeFunction next) {
        Intrinsics.checkNotNullParameter((Object)apiGatewayRequest, (String)"apiGatewayRequest");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        String[] stringArray = new String[]{$request.getHeader("Authorization")};
        ClientRequest.Builder builder = ClientRequest.from((ClientRequest)apiGatewayRequest).header("Authorization", stringArray);
        stringArray = new String[]{$request.getHeader("just-token")};
        return next.exchange(builder.header("just-token", stringArray).build());
    }

    private static final Mono acceptLanguage$lambda$6(HttpServletRequest $request, ClientRequest apiGatewayRequest, ExchangeFunction next) {
        Intrinsics.checkNotNullParameter((Object)apiGatewayRequest, (String)"apiGatewayRequest");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        String[] stringArray = new String[]{$request.getHeader("Accept-Language")};
        return next.exchange(ClientRequest.from((ClientRequest)apiGatewayRequest).header("Accept-Language", stringArray).build());
    }
}

