/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.document.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.AuthorizationKey;
import de.justsoftware.drive.business.authorization.AuthorizationResult;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.document.DocumentVersionCountService;
import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.publiclinks.PublicLinkService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.business.thumbor.ThumborService;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentListBO;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.document.impl.DocumentFrontendServiceImpl;
import de.justsoftware.drive.rest.exceptions.BadRequestException;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.exceptions.ZipException;
import de.justsoftware.drive.rest.file.FileLockFrontendService;
import de.justsoftware.drive.rest.models.DocumentList;
import de.justsoftware.drive.rest.models.DocumentPath;
import de.justsoftware.drive.rest.models.Item;
import de.justsoftware.drive.rest.person.PersonFrontendService;
import de.justsoftware.drive.rest.util.ContentDispositionUtil;
import de.justsoftware.drive.rest.util.ZipUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class DocumentFrontendServiceImpl
implements DocumentFrontendService {
    private static final ImmutableSet<StaticAction> NEEDED_ACTIONS = ImmutableSet.of((Object)StaticAction.DOCUMENT_WRITE, (Object)StaticAction.DOCUMENT_DELETE);
    private final FilePreviewService _filePreviewService;
    private final PersonFrontendService _personFrontendService;
    private final FolderService _folderService;
    private final FileService _fileService;
    private final ItemReadService _itemReadService;
    private final FileLockFrontendService _fileLockFrontendService;
    private final PublicLinkService _publicLinkService;
    private final SettingsService _settingsService;
    private final DocumentVersionCountService _documentVersionCountService;
    private final DocumentService _documentService;

    @Autowired
    public DocumentFrontendServiceImpl(FilePreviewService filePreviewService, PersonFrontendService personFrontendService, FolderService folderService, FileService fileService, ItemReadService itemReadService, FileLockFrontendService fileLockFrontendService, PublicLinkService publicLinkService, SettingsService settingsService, DocumentVersionCountService documentVersionCountService, DocumentService documentService) {
        this._filePreviewService = filePreviewService;
        this._personFrontendService = personFrontendService;
        this._folderService = folderService;
        this._fileService = fileService;
        this._itemReadService = itemReadService;
        this._fileLockFrontendService = fileLockFrontendService;
        this._publicLinkService = publicLinkService;
        this._settingsService = settingsService;
        this._documentVersionCountService = documentVersionCountService;
        this._documentService = documentService;
    }

    public DocumentList convertDocumentList(DocumentListBO documentListBO, AuthorizationContext authCtx) {
        FluentIterable versions = FluentIterable.from((Iterable)documentListBO.getDocuments()).filter(DocumentVersionBO.class).append((Iterable)documentListBO.getPath());
        HashMap<DocumentVersionId, DocumentId> map = new HashMap<DocumentVersionId, DocumentId>();
        DocumentId parent = null;
        for (FolderVersionBO pathElement : documentListBO.getPath()) {
            map.put(pathElement.getId(), parent);
            parent = pathElement.getDocumentId();
        }
        CreateDocumentVisitorImpl createDocument = new CreateDocumentVisitorImpl(this, documentListBO.getPersons(), (Iterable)versions, authCtx, id -> map.containsKey(id) ? (DocumentId)map.get(id) : documentListBO.getParent().getDocumentId());
        Item rootItem = this.getItem(documentListBO.getParent().getItemId(), authCtx);
        DocumentPath path = new DocumentPath((List)FluentIterable.from((Iterable)documentListBO.getPath()).transform(createDocument.toFolder()).toList(), rootItem);
        return new DocumentList(path, (List)FluentIterable.from((Iterable)documentListBO.getDocuments()).transform((Function)createDocument).toList(), (long)documentListBO.getTotalSize());
    }

    public Item getItem(ItemId itemId, AuthorizationContext authCtx) {
        ItemBO root = (ItemBO)this._itemReadService.getItems((Set)ImmutableSet.of((Object)itemId)).get((Object)itemId);
        if (root == null) {
            return new Item(itemId);
        }
        ImmutableSetMultimap allowedActions = authCtx.may((SetMultimap)ImmutableSetMultimap.of((Object)itemId, (Object)StaticAction.SHARE_MANAGE, (Object)itemId, (Object)StaticAction.DOCUMENT_READ, (Object)itemId, (Object)StaticAction.DOCUMENT_WRITE));
        return new Item(root.getId(), (ItemId)root.getParent().orNull(), root.getName(), allowedActions.get((Object)itemId));
    }

    @Nonnull
    private static String createRelativeUrlToApiEndpoint(DocumentVersionId id, String apiEndpoint) {
        ServletUriComponentsBuilder uriBuilder = RequestContextHolder.getRequestAttributes() != null ? ServletUriComponentsBuilder.fromCurrentContextPath() : UriComponentsBuilder.fromPath((String)"/drive");
        uriBuilder.host(null).port(null).scheme(null);
        return uriBuilder.path("/api" + apiEndpoint).buildAndExpand(new Object[]{id.getId()}).toUriString();
    }

    @Nonnull
    private String createVideoCoverUrl(FileVersionBO file) {
        return DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)file.getId(), (String)"/previews/previewImage/{fileVersionId}?width=450&height=450");
    }

    @Nonnull
    @VisibleForTesting
    public static String createDownloadUrl(DocumentVersionId fileVersionId) {
        return DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/documents/fileversion/{fileVersionId}/download");
    }

    @CheckForNull
    @VisibleForTesting
    String createEmbedUrl(FileVersionBO fileVersionBo) {
        DocumentVersionId fileVersionId = fileVersionBo.getId();
        MimeType mimeType = MimeTypeUtils.parseMimeType((String)fileVersionBo.getMimeType());
        return switch (mimeType.getType()) {
            case "audio", "video" -> DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/previews/embed/{id}");
            case "image" -> {
                if (!ThumborService.isMediaTypeSupported((String)fileVersionBo.getMimeType())) {
                    yield null;
                }
                yield DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/previews/previewImage/{fileVersionId}");
            }
            default -> null;
        };
    }

    @CheckForNull
    @VisibleForTesting
    String createEmbedImagePreviewUrl(FileVersionBO fileVersionBo) {
        DocumentVersionId fileVersionId = fileVersionBo.getId();
        MimeType mimeType = MimeTypeUtils.parseMimeType((String)fileVersionBo.getMimeType());
        return switch (mimeType.getType()) {
            case "video" -> this.createVideoCoverUrl(fileVersionBo);
            case "image" -> {
                if (!ThumborService.isMediaTypeSupported((String)fileVersionBo.getMimeType())) {
                    yield null;
                }
                yield DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/previews/previewImage/{fileVersionId}");
            }
            default -> null;
        };
    }

    @Nonnull
    private Map<DocumentVersionId, DocumentId> getParentFolderIdsForVersions(ImmutableSet<DocumentVersionId> versionIds, PublishedFilter publishedFilter) {
        if (versionIds.isEmpty()) {
            return ImmutableMap.of();
        }
        ListMultimap pathIdMultiMapMap = Multimaps.transformValues((ListMultimap)this._folderService.getPathBOs(versionIds, publishedFilter), (Function)DocumentVersionBO.GET_DOCUMENT_ID);
        return Maps.transformValues((Map)Multimaps.asMap((ListMultimap)pathIdMultiMapMap), Iterables::getLast);
    }

    public DocumentFrontendService.CreateDocumentVisitor documentCreator(Iterable<? extends DocumentVersionBO> versions, AuthorizationContext authCtx, PublishedFilter publishedFilter) {
        ImmutableMap persons = this._personFrontendService.getPersons((Set)FluentIterable.from(versions).transform(DocumentVersionBO.GET_OWNER).filter(Predicates.notNull()).toSet());
        ImmutableSet versionIds = FluentIterable.from(versions).transform(DocumentVersionBO::getId).toSet();
        Map parents = this.getParentFolderIdsForVersions(versionIds, publishedFilter);
        return new CreateDocumentVisitorImpl(this, persons, versions, authCtx, parents::get);
    }

    public DocumentFrontendService.CreateDocumentVisitor documentCreator(DocumentVersionBO version, AuthorizationContext authCtx, DocumentId parent) {
        ImmutableList versions = ImmutableList.of((Object)version);
        ImmutableMap persons = this._personFrontendService.getPersons((Set)ImmutableSet.of((Object)version.getOwner()));
        return new CreateDocumentVisitorImpl(this, persons, (Iterable)versions, authCtx, Functions.constant((Object)parent));
    }

    public PublishedFilter checkRead(AuthorizationContext authCtx, DocumentVersionId documentVersionId) {
        DocumentId document = (DocumentId)this._documentService.getDocumentIdsOfVersions(Set.of(documentVersionId)).get((Object)documentVersionId);
        if (document == null) {
            throw new UnknownResourceException("No document id for document version '" + String.valueOf(documentVersionId) + "' found.");
        }
        this.checkRead(authCtx, (AbstractId)document);
        return this.checkRead(authCtx, (AbstractId)documentVersionId);
    }

    public PublishedFilter checkRead(AuthorizationContext authCtx, AbstractId<?> nullableId) {
        AbstractId id = (AbstractId)BadRequestException.checkNotNull(nullableId);
        PublishedFilter result = (PublishedFilter)this.checkReadWrite(authCtx, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)id)).get((Object)id);
        return (PublishedFilter)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private static PublishedFilter readAllowed(ImmutableMap<AuthorizationKey<AbstractId<?>>, AuthorizationResult> allowed, AuthorizationContext authCtx, AbstractId<?> id) {
        AuthorizationResult readPrivateAllowed = (AuthorizationResult)allowed.getOrDefault((Object)authCtx.key(id, StaticAction.DOCUMENT_READ_PRIVATE), (Object)AuthorizationResult.RESOURCE_NOT_FOUND);
        if (readPrivateAllowed.isOk()) {
            return PublishedFilter.PUBLISHED_OR_PRIVATE;
        }
        AuthorizationResult readPublicAllowed = (AuthorizationResult)allowed.getOrDefault((Object)authCtx.key(id, StaticAction.DOCUMENT_READ), (Object)AuthorizationResult.RESOURCE_NOT_FOUND);
        readPublicAllowed.throwExcpetion();
        return PublishedFilter.ONLY_PUBLISHED;
    }

    public <T extends AbstractId<?>> ImmutableMap<T, PublishedFilter> checkReadWrite(AuthorizationContext authCtx, Set<? extends AbstractId<?>> targets, Set<? extends T> srcs) {
        ImmutableSet.Builder authKeys = ImmutableSet.builder();
        for (AbstractId<?> target : targets) {
            authKeys.add((Object)authCtx.key(target, StaticAction.DOCUMENT_WRITE));
        }
        for (Object src : srcs) {
            authKeys.add((Object)authCtx.key((AbstractId)src, StaticAction.DOCUMENT_READ));
            authKeys.add((Object)authCtx.key((AbstractId)src, StaticAction.DOCUMENT_READ_PRIVATE));
        }
        ImmutableMap allowed = authCtx.allowed((Set)authKeys.build());
        for (AbstractId abstractId : targets) {
            ((AuthorizationResult)allowed.getOrDefault((Object)authCtx.key(abstractId, StaticAction.DOCUMENT_WRITE), (Object)AuthorizationResult.RESOURCE_NOT_FOUND)).throwExcpetion();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (AbstractId src : srcs) {
            result.put((Object)src, (Object)DocumentFrontendServiceImpl.readAllowed((ImmutableMap)allowed, (AuthorizationContext)authCtx, (AbstractId)src));
        }
        return result.build();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public void downloadFolderAsZip(HttpServletResponse response, DocumentVersionId documentVersionId, FolderVersionBO folderVersionBO) throws IOException {
        ImmutableList folderContents = this._folderService.getFolderContents((Set)ImmutableSet.of((Object)documentVersionId)).get((Object)documentVersionId);
        response.setContentType("application/zip");
        String rootFolderName = !folderVersionBO.isRoot() ? folderVersionBO.getName() : ((ItemBO)this._itemReadService.getItems((Set)ImmutableSet.of((Object)folderVersionBO.getItemId())).get((Object)folderVersionBO.getItemId())).getName();
        ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)(rootFolderName.replaceAll("[<>\\\\/:?*\"|]", "_") + ".zip"));
        try (ZipArchiveOutputStream zaos = ZipUtil.getZipArchiveOutputStream((HttpServletResponse)response);){
            ImmutableSet documentsInZip = this.putFolderIntoZip(ZipUtil.sanitizeFilename((String)rootFolderName), folderContents, zaos);
            this._documentVersionCountService.increment((Set)documentsInZip);
        }
    }

    @Nonnull
    private ImmutableSet<DocumentVersionId> putFolderIntoZip(String name, ImmutableList<DocumentVersionBO> folderContents, ZipArchiveOutputStream zos) throws ZipException {
        ImmutableSet.Builder includedDocuments = ImmutableSet.builder();
        for (DocumentVersionBO entryBO : folderContents) {
            entryBO.accept((DocumentVersionBO.Visitor)new /* Unavailable Anonymous Inner Class!! */);
        }
        return includedDocuments.build();
    }
}

