/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.settings.model.SettingsBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"}, produces={"application/json"})
@Schema(description="DriveInternal")
@ParametersAreNonnullByDefault
public class InternalController {
    static final String API_MAPPING = "/internal";
    private final SettingsService _settingsService;

    @Autowired
    public InternalController(SettingsService settingsService) {
        this._settingsService = settingsService;
    }

    @RequestMapping(path={"/settings/{tenantId}/publicLinks/{enabled}"}, method={RequestMethod.PATCH})
    public SettingsBO setPublicLinksEnabled(@PathVariable TenantId tenantId, @PathVariable boolean enabled) {
        SettingsBO newSettings = new SettingsBO(tenantId, enabled);
        return this._settingsService.insertSettings(newSettings);
    }

    @RequestMapping(path={"/settings/{tenantId}"}, method={RequestMethod.GET})
    public SettingsBO getSettings(@PathVariable TenantId tenantId) {
        return this._settingsService.getSettings(tenantId);
    }
}

