/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.persistence.document.DocumentVersionCreateModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class FileVersionCreateModel
extends DocumentVersionCreateModel<FileVersionCreateModel> {
    String _mimeType;
    long _fileSize;
    boolean _deleted;
    StorageId _storageId;
    VideoTeaserId _videoTeaserId;

    FileVersionCreateModel() {
        this(DocumentVersionId.random());
    }

    @VisibleForTesting
    public FileVersionCreateModel(DocumentVersionId id) {
        super(id);
    }

    @Nonnull
    public FileVersionCreateModel setMimeType(String mimeType) {
        this._mimeType = mimeType;
        return this;
    }

    @Nonnull
    public FileVersionCreateModel setFileSize(long fileSize) {
        this._fileSize = fileSize;
        return this;
    }

    @Nonnull
    public FileVersionCreateModel setDeleted(boolean deleted) {
        this._deleted = deleted;
        return this;
    }

    @Nonnull
    public FileVersionCreateModel setStorageId(StorageId storageId) {
        this._storageId = storageId;
        return this;
    }

    @Nonnull
    public FileVersionCreateModel setVideoTeaserId(@Nullable VideoTeaserId videoTeaserId) {
        this._videoTeaserId = videoTeaserId;
        return this;
    }

    @Nonnull
    public FileVersionCreateModel newVersionOf(FileVersionBO businessObject) {
        return ((FileVersionCreateModel)super.newVersionOf((DocumentVersionBO)businessObject)).setDeleted(businessObject.isDeleted()).setFileSize(businessObject.getFileSize()).setMimeType(businessObject.getMimeType()).setStorageId(businessObject.getStorageId()).setVideoTeaserId(businessObject.getVideoTeaserId());
    }

    protected FileVersionCreateModel self() {
        return this;
    }
}

