/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.change.ChangeService;
import de.justsoftware.drive.business.common.CachingMapLoader;
import de.justsoftware.drive.business.document.DocumentListService;
import de.justsoftware.drive.business.document.impl.DocumentListServiceImpl;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.person.PersonService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.AdjacentDocuments;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentListBO;
import de.justsoftware.drive.common.document.model.DocumentListEntryBO;
import de.justsoftware.drive.common.document.model.DocumentSortField;
import de.justsoftware.drive.common.document.model.DocumentSortParams;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.MicroblogEntryBO;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.person.model.PersonId;
import java.text.Collator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class DocumentListServiceImpl
implements DocumentListService {
    private static final DocumentListEntryBO.Visitor<Optional<PersonId>> GET_OWNER_ID = new /* Unavailable Anonymous Inner Class!! */;
    private static final DocumentListEntryBO.Visitor<Optional<Instant>> GET_CHANGE_DATE = new /* Unavailable Anonymous Inner Class!! */;
    private static final DocumentListEntryBO.Visitor<String> GET_NAME = new /* Unavailable Anonymous Inner Class!! */;
    private static final DocumentListEntryBO.Visitor<Long> GET_SIZE = new /* Unavailable Anonymous Inner Class!! */;
    final FolderService _folderService;
    final PersonService _personService;
    final ChangeModificationService _changeModificationService;
    final ChangeService _changeService;

    @Autowired
    public DocumentListServiceImpl(FolderService folderService, PersonService personService, ChangeModificationService changeModificationService, ChangeService changeService) {
        this._folderService = folderService;
        this._personService = personService;
        this._changeModificationService = changeModificationService;
        this._changeService = changeService;
    }

    public DocumentListBO getCurrentDocumentList(DocumentId folderId, DocumentSortParams sortParams, PublishedFilter publishedFilter) {
        DocumentVersionId latestVersionId = this.getLatestVersionOfDocument(folderId, publishedFilter);
        return this.getDocumentList(latestVersionId, sortParams, publishedFilter);
    }

    @Nonnull
    public AdjacentDocuments getPreviousAndNextDocuments(DocumentId documentId, DocumentSortParams sortParams, PublishedFilter publishedFilter) {
        DocumentVersionId latestVersionId = this.getLatestVersionOfDocument(documentId, publishedFilter);
        return this.getAdjacentDocuments(documentId, latestVersionId, sortParams, publishedFilter);
    }

    private DocumentVersionId getLatestVersionOfDocument(DocumentId folderId, PublishedFilter publishedFilter) {
        DocumentVersionId latestVersion = this._folderService.getLastVersionOfDocument(folderId, publishedFilter);
        if (latestVersion == null) {
            throw new UnknownResourceBusinessException("Could not load document list for folder id " + String.valueOf(folderId));
        }
        return latestVersion;
    }

    @Nonnull
    @VisibleForTesting
    DocumentListBO getDocumentList(DocumentVersionId folderVersionId, DocumentSortParams sortParams, PublishedFilter publishedFilter) {
        ChangeBO changeBO = this._changeService.findChangeById(folderVersionId);
        ImmutableList pathIds = this._folderService.getPath(folderVersionId, publishedFilter);
        ImmutableSet pathIdSet = ImmutableSet.copyOf((Collection)pathIds);
        if (pathIdSet.isEmpty()) {
            throw new UnknownResourceBusinessException("No path found for folder version " + String.valueOf(folderVersionId));
        }
        ImmutableMap folderVersionById = this._folderService.getFolderVersionsByIds((Set)pathIdSet);
        if (!pathIdSet.equals((Object)folderVersionById.keySet())) {
            throw new UnknownResourceBusinessException("Not a folder version or path contains gaps " + String.valueOf(folderVersionId));
        }
        ImmutableList path = FluentIterable.from((Iterable)pathIds).transform(Functions.forMap((Map)folderVersionById)).toList();
        ImmutableList.Builder folderContentsBuilder = ImmutableList.builder();
        if (changeBO != null && changeBO.getItemId().getType().equals((Object)ItemType.ENTITY)) {
            folderContentsBuilder.add((Object)new MicroblogEntryBO(changeBO.getItemId()));
        }
        folderContentsBuilder.addAll((Iterable)this._folderService.getFolderContents(folderVersionId));
        ImmutableList folderContents = folderContentsBuilder.build();
        CachingMapLoader personCache = new CachingMapLoader(arg_0 -> ((PersonService)this._personService).getPersonsByIds(arg_0));
        ImmutableSet pathOwners = FluentIterable.from((Iterable)path).transform(DocumentVersionBO.GET_OWNER).toSet();
        personCache.addMissing((Iterable)pathOwners);
        ImmutableList orderDocuments = this.orderDocuments((Collection)folderContents, sortParams, Suppliers.memoize(() -> {
            personCache.addMissing((Iterable)FluentIterable.from((Iterable)folderContents).filter(DocumentVersionBO.class).transform(DocumentVersionBO.GET_OWNER));
            return personCache;
        }));
        ImmutableSet contentOwners = FluentIterable.from((Iterable)orderDocuments).filter(DocumentVersionBO.class).transform(DocumentVersionBO.GET_OWNER).toSet();
        personCache.addMissing((Iterable)contentOwners);
        return new DocumentListBO(path, folderContents.size(), orderDocuments, ImmutableMap.copyOf((Map)personCache.get((Set)Sets.union((Set)pathOwners, (Set)contentOwners))));
    }

    @Nonnull
    @VisibleForTesting
    private AdjacentDocuments getAdjacentDocuments(DocumentId documentId, DocumentVersionId documentVersionId, DocumentSortParams sortParams, PublishedFilter publishedFilter) {
        ImmutableList documentPathIds = this._folderService.getPath(documentVersionId, publishedFilter);
        if (documentPathIds.size() <= 1) {
            throw new UnknownResourceBusinessException("No path found for document version" + String.valueOf(documentVersionId));
        }
        DocumentVersionId folderVersionId = (DocumentVersionId)documentPathIds.get(documentPathIds.size() - 2);
        ImmutableList pathIds = this._folderService.getPath(folderVersionId, publishedFilter);
        ChangeBO changeBO = this._changeService.findChangeById(folderVersionId);
        ImmutableSet pathIdSet = ImmutableSet.copyOf((Collection)pathIds);
        ImmutableMap folderVersionById = this._folderService.getFolderVersionsByIds((Set)pathIdSet);
        ImmutableList path = FluentIterable.from((Iterable)pathIds).transform(Functions.forMap((Map)folderVersionById)).toList();
        ImmutableList.Builder folderContentsBuilder = ImmutableList.builder();
        if (changeBO != null && changeBO.getItemId().getType().equals((Object)ItemType.ENTITY)) {
            folderContentsBuilder.add((Object)new MicroblogEntryBO(changeBO.getItemId()));
        }
        folderContentsBuilder.addAll((Iterable)this._folderService.getFolderContents(folderVersionId));
        ImmutableList folderContents = folderContentsBuilder.build();
        CachingMapLoader personCache = new CachingMapLoader(arg_0 -> ((PersonService)this._personService).getPersonsByIds(arg_0));
        ImmutableSet pathOwners = FluentIterable.from((Iterable)path).transform(DocumentVersionBO.GET_OWNER).toSet();
        personCache.addMissing((Iterable)pathOwners);
        return this.findAdjacentIds(documentId, (Collection)folderContents, sortParams, Suppliers.memoize(() -> {
            personCache.addMissing((Iterable)FluentIterable.from((Iterable)folderContents).filter(DocumentVersionBO.class).transform(DocumentVersionBO.GET_OWNER));
            return personCache;
        }));
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<DocumentListEntryBO> orderDocuments(Collection<? extends DocumentListEntryBO> folderContents, DocumentSortParams sortParams, Supplier<? extends Function<PersonId, PersonBO>> personCache) {
        if (folderContents.size() < sortParams.getOffset()) {
            return ImmutableList.of();
        }
        Ordering order = this.ordering(sortParams, personCache);
        return ImmutableList.copyOf((Iterable)Iterables.skip((Iterable)order.leastOf(folderContents, sortParams.getLimit() + sortParams.getOffset()), (int)sortParams.getOffset()));
    }

    @Nonnull
    @VisibleForTesting
    private AdjacentDocuments findAdjacentIds(DocumentId documentId, Collection<? extends DocumentListEntryBO> folderContents, DocumentSortParams sortParams, Supplier<? extends Function<PersonId, PersonBO>> personCache) {
        Ordering order = this.ordering(sortParams, personCache);
        ArrayList sorted = new ArrayList(order.sortedCopy(folderContents));
        Iterable filesOnly = Iterables.transform((Iterable)Iterables.filter(sorted, entry -> entry instanceof FileVersionBO), entry -> (FileVersionBO)entry);
        int index = Iterables.indexOf((Iterable)filesOnly, entry -> entry.getDocumentId().equals((Object)documentId));
        if (index < 0) {
            throw new UnknownResourceBusinessException("No corresponding file found for documentId: " + String.valueOf(documentId));
        }
        DocumentId prev = null;
        if (index > 0) {
            prev = ((FileVersionBO)Iterables.get((Iterable)filesOnly, (int)(index - 1))).getDocumentId();
        }
        DocumentId curr = ((FileVersionBO)Iterables.get((Iterable)filesOnly, (int)index)).getDocumentId();
        DocumentId next = null;
        if (index < Iterables.size((Iterable)filesOnly) - 1) {
            next = ((FileVersionBO)Iterables.get((Iterable)filesOnly, (int)(index + 1))).getDocumentId();
        }
        return new AdjacentDocuments(prev, curr, next);
    }

    @Nonnull
    private Ordering<DocumentListEntryBO> ordering(DocumentSortParams sortParams, Supplier<? extends Function<PersonId, PersonBO>> personCache) {
        Ordering fieldOrdering = this.fieldOrdering(sortParams, personCache);
        return switch (5.$SwitchMap$de$justsoftware$drive$common$model$SortDirection[sortParams.getSortDirection().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> fieldOrdering;
            case 2 -> fieldOrdering.reverse();
        };
    }

    @Nonnull
    private Ordering<DocumentListEntryBO> fieldOrdering(DocumentSortParams sortParams, Supplier<? extends Function<PersonId, PersonBO>> personCache) {
        Collator collator = Collator.getInstance(sortParams.getLocale());
        collator.setStrength(0);
        Ordering nameOrdering = Ordering.from((Comparator)collator).onResultOf((Function)GET_NAME);
        DocumentSortField field = sortParams.getSortField();
        return switch (5.$SwitchMap$de$justsoftware$drive$common$document$model$DocumentSortField[field.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                Function f = Functions.compose((Function)PersonBO.SORT_NAME, (Function)((Function)personCache.get()));
                yield Ordering.from((Comparator)collator).onResultOf(Functions.compose((Function)f, (Function)Functions.compose(Optional::orNull, (Function)GET_OWNER_ID))).nullsFirst().compound((Comparator)nameOrdering);
            }
            case 2 -> Ordering.natural().onResultOf((Function)GET_SIZE).compound((Comparator)nameOrdering);
            case 3 -> Ordering.natural().nullsFirst().onResultOf(Functions.compose(Optional::orNull, (Function)GET_CHANGE_DATE)).compound((Comparator)nameOrdering);
            case 4 -> nameOrdering;
        };
    }
}

