/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.change.ChangeTrigger;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ChangeWithTriggers {
    private final ImmutableSet<? extends ChangeTrigger> _triggers;
    private final DocumentVersionId _changeId;
    private final ItemId _itemId;
    private final int _version;
    private final String _purpose;
    private final boolean _isPublic;
    private final PersonId _executedBy;
    private final Instant _changeDate;

    public ChangeWithTriggers(ChangeBO change, ImmutableSet<? extends ChangeTrigger> triggers, @Nullable String purpose, @Nullable PersonId executedBy, Instant changeDate) {
        this(change.getId(), change.getItemId(), change.getVersion(), triggers, purpose, change.isPublic(), executedBy, changeDate);
    }

    public ChangeWithTriggers(DocumentVersionId changeId, ItemId itemId, int version, ImmutableSet<? extends ChangeTrigger> triggers, @Nullable String purpose, boolean isPublic, @Nullable PersonId executedBy, Instant changeDate) {
        this._changeId = changeId;
        this._itemId = itemId;
        this._version = version;
        this._triggers = triggers;
        this._purpose = purpose;
        this._isPublic = isPublic;
        this._executedBy = executedBy;
        this._changeDate = changeDate;
    }

    @Nonnull
    public DocumentVersionId getId() {
        return this._changeId;
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    public int getVersion() {
        return this._version;
    }

    @Nonnull
    public ImmutableSet<? extends ChangeTrigger> getChangeTriggers() {
        return this._triggers;
    }

    @CheckForNull
    public String getPurpose() {
        return this._purpose;
    }

    public boolean isPublic() {
        return this._isPublic;
    }

    @Nonnull
    public Optional<PersonId> getExecutedBy() {
        return Optional.ofNullable(this._executedBy);
    }

    @Nonnull
    public Instant getChangeDate() {
        return this._changeDate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changeId", (Object)this._changeId).add("itemId", (Object)this._itemId).add("version", this._version).add("triggers", (Object)this._triggers).add("purpose", (Object)this._purpose).add("isPublic", this._isPublic).add("executedBy", (Object)this._executedBy).toString();
    }
}

