/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import de.justsoftware.drive.business.authorization.ItemReadRoleService;
import de.justsoftware.drive.business.authorization.impl.ItemActionKafkaConsumer;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.common.authorization.model.Action;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.authorization.model.SubtypeAction;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.persistence.authorization.ItemActionDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ItemActionKafkaConsumer
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.item.actions";
    private static final ImmutableMap<String, StaticAction> ACTION_MAPPING = FluentIterable.from((Object[])StaticAction.values()).uniqueIndex(action -> {
        switch (1.$SwitchMap$de$justsoftware$drive$common$authorization$model$StaticAction[action.ordinal()]) {
            case 1: {
                return "DRIVE_DOCUMENT_READ";
            }
            case 2: {
                return "DRIVE_DOCUMENT_WRITE";
            }
            case 3: {
                return "DRIVE_SHARE_MANAGE";
            }
            case 4: {
                return "DRIVE_DOCUMENT_READ_PRIVATE";
            }
            case 5: {
                return "DRIVE_DOCUMENT_DELETE";
            }
            case 6: {
                return "DRIVE_DOCUMENT_DELETE_BY_OWNER";
            }
        }
        throw new UnsupportedOperationException("Unexpected Enum value" + String.valueOf(action));
    });
    private final ItemActionDAO _itemActionDAO;
    private final ItemReadRoleService _itemReadRoleService;

    @Autowired
    public ItemActionKafkaConsumer(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionSupport transactionSupport, ItemActionDAO itemActionDAO, ItemReadRoleService itemReadRoleService) {
        this(kafkaConfigurationProvider.stringConsumer("just.drive.ItemActionsConsumer"), transactionSupport, itemActionDAO, itemReadRoleService);
    }

    @VisibleForTesting
    ItemActionKafkaConsumer(@Nullable Consumer<String, String> consumer, TransactionSupport transactionSupport, ItemActionDAO itemActionDAO, ItemReadRoleService itemReadRoleService) {
        super(consumer, transactionSupport, "just.item.actions");
        this._itemActionDAO = itemActionDAO;
        this._itemReadRoleService = itemReadRoleService;
    }

    protected void process(ConsumerRecords<String, String> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        ImmutableSet.Builder changedItemsBuilder = ImmutableSet.builder();
        HashBasedTable toAdd = HashBasedTable.create();
        for (ConsumerRecord r : records) {
            this.processRecord(r, (Table)toAdd, changedItemsBuilder);
        }
        ImmutableSet changedItems = changedItemsBuilder.build();
        if (!changedItems.isEmpty()) {
            this._itemActionDAO.deleteItemActions((Set)changedItems);
            this._itemActionDAO.insertItemActions((Table)toAdd);
            this._itemReadRoleService.updateItemReadRoles((Set)changedItems);
        }
    }

    private void processRecord(ConsumerRecord<String, String> record, Table<ItemId, Action, String> toAdd, ImmutableSet.Builder<ItemId> changedItemsBuilder) {
        ItemId itemId = ItemId.valueOf((String)((String)record.key()));
        if (itemId == null) {
            return;
        }
        String recordValue = (String)record.value();
        changedItemsBuilder.add((Object)itemId);
        toAdd.rowMap().remove(itemId);
        if (recordValue == null) {
            return;
        }
        JsonNode value = this.parseJson(recordValue);
        if (value == null) {
            return;
        }
        Iterator fit = value.fields();
        while (fit.hasNext()) {
            Map.Entry e = (Map.Entry)fit.next();
            Action action = ItemActionKafkaConsumer.parse((String)((String)e.getKey()));
            String condition = ((JsonNode)e.getValue()).asText(null);
            if (condition == null || action == null) continue;
            toAdd.put((Object)itemId, (Object)action, (Object)condition);
        }
    }

    @CheckForNull
    private static Action parse(String key) {
        int index = key.indexOf(47);
        if (index < 0) {
            return (Action)ACTION_MAPPING.get((Object)key);
        }
        StaticAction action = (StaticAction)ACTION_MAPPING.get((Object)key.substring(index + 1));
        if (action == null) {
            return null;
        }
        ItemType itemType = ItemType.valueOf((String)key.substring(0, index));
        return new SubtypeAction(itemType, action);
    }
}

