/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.authorization;

import de.justsoftware.chat.application.model.AllowedActions;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.PermissionAction;
import de.justsoftware.chat.model.PermissionRole;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ;2\u00020\u0001:\u0001;B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"J \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u0019J \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u0019J \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u0019J \u0010*\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020+0\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0\u0019J<\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020+0\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0\u0019J\u001e\u00100\u001a\u00020\u00132\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00192\u0006\u00103\u001a\u000204H\u0002J\u0016\u00100\u001a\u00020\u00132\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0019H\u0002J\u0018\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u0002062\u0006\u00109\u001a\u00020:H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lde/justsoftware/chat/authorization/AuthorizationContext;", "", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "locale", "Ljava/util/Locale;", "authService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/chat/model/ProfileId;Lde/justsoftware/chat/model/TenantId;Ljava/util/Locale;Lde/justsoftware/chat/authorization/AuthorizationService;)V", "getProfileId", "()Lde/justsoftware/chat/model/ProfileId;", "getTenantId", "()Lde/justsoftware/chat/model/TenantId;", "getLocale", "()Ljava/util/Locale;", "checkCreateOneOnOneChat", "", "checkCreateGroupChat", "checkRestoreChats", "checkReadProfile", "checkReadProfiles", "profileIds", "", "mayReadProfiles", "", "", "mayInteractWithUserGroups", "Lde/justsoftware/chat/model/UserGroupId;", "userGroupIds", "checkReadChat", "chatId", "Lde/justsoftware/chat/model/ChatId;", "checkWriteChat", "checkManageChat", "checkManageOrTempManageChat", "mayManageChats", "chatIds", "mayWriteChats", "mayReadChats", "toMultiUserChatsAllowedActionsWithoutTemporaryPermissions", "Lde/justsoftware/chat/application/model/AllowedActions;", "multiUserChatIds", "toMultiUserChatsAllowedActions", "chatsWithoutWriter", "chatsWithoutManager", "check", "itemsToCheck", "Lde/justsoftware/chat/model/PermissionRole;", "permissionAction", "Lde/justsoftware/chat/model/PermissionAction;", "rolesToCheck", "Lde/justsoftware/permission/client/model/Role;", "checkAuthorizationResult", "checkedRole", "authResult", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContext.kt\nde/justsoftware/chat/authorization/AuthorizationContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,130:1\n1279#2,2:131\n1293#2,4:133\n1557#2:137\n1628#2,3:138\n216#3,2:141\n9#4:143\n8#4,3:144\n*S KotlinDebug\n*F\n+ 1 AuthorizationContext.kt\nde/justsoftware/chat/authorization/AuthorizationContext\n*L\n69#1:131,2\n69#1:133,4\n99#1:137\n99#1:138,3\n105#1:141,2\n122#1:143\n122#1:144,3\n*E\n"})
public final class AuthorizationContext {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ProfileId profileId;
    @NotNull
    private final TenantId tenantId;
    @NotNull
    private final Locale locale;
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private static final Logger LOG;

    public AuthorizationContext(@NotNull ProfileId profileId, @NotNull TenantId tenantId, @NotNull Locale locale, @NotNull AuthorizationService authService) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        this.profileId = profileId;
        this.tenantId = tenantId;
        this.locale = locale;
        this.authService = authService;
    }

    @NotNull
    public final ProfileId getProfileId() {
        return this.profileId;
    }

    @NotNull
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    public final void checkCreateOneOnOneChat() {
        this.check(SetsKt.setOf((Object)Role.itemRole((String)"CHAT_CREATE_ONE_TO_ONE", (String)Companion.chatAppItemId(this.tenantId))));
    }

    public final void checkCreateGroupChat() {
        this.check(SetsKt.setOf((Object)Role.itemRole((String)"CHAT_CREATE_MANY_TO_MANY", (String)Companion.chatAppItemId(this.tenantId))));
    }

    public final void checkRestoreChats() {
        this.check(SetsKt.setOf((Object)this.tenantId), PermissionAction.MANAGE);
    }

    public final void checkReadProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.checkReadProfiles(SetsKt.setOf((Object)profileId));
    }

    public final void checkReadProfiles(@NotNull Set<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        this.check(profileIds, PermissionAction.READ);
    }

    @NotNull
    public final Map<ProfileId, Boolean> mayReadProfiles(@NotNull Set<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.authService.mayAll(profileIds, SetsKt.setOf((Object)PermissionAction.READ), this.profileId);
    }

    @NotNull
    public final Map<UserGroupId, Boolean> mayInteractWithUserGroups(@NotNull Set<UserGroupId> userGroupIds) {
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Object[] objectArray = new PermissionAction[]{PermissionAction.USE, PermissionAction.READ};
        return this.authService.mayAll(userGroupIds, SetsKt.setOf((Object[])objectArray), this.profileId);
    }

    public final void checkReadChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        this.authService.checkChatPermission(chatId, this.profileId, PermissionType.READER);
    }

    public final void checkWriteChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        this.authService.checkChatPermission(chatId, this.profileId, PermissionType.WRITER);
    }

    public final void checkManageChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        this.authService.checkChatPermission(chatId, this.profileId, PermissionType.MANAGER);
    }

    public final void checkManageOrTempManageChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        this.authService.checkManageOrTempManageChat(chatId, this.profileId);
    }

    @NotNull
    public final Map<ChatId, Boolean> mayManageChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        return this.authService.hasPermissionForChats(chatIds, this.profileId, PermissionType.MANAGER);
    }

    @NotNull
    public final Map<ChatId, Boolean> mayWriteChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        return this.authService.hasPermissionForChats(chatIds, this.profileId, PermissionType.WRITER);
    }

    @NotNull
    public final Map<ChatId, Boolean> mayReadChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        return this.authService.hasPermissionForChats(chatIds, this.profileId, PermissionType.READER);
    }

    @NotNull
    public final Map<ChatId, AllowedActions> toMultiUserChatsAllowedActionsWithoutTemporaryPermissions(@NotNull Set<ChatId> multiUserChatIds) {
        Intrinsics.checkNotNullParameter(multiUserChatIds, (String)"multiUserChatIds");
        return this.toMultiUserChatsAllowedActions(multiUserChatIds, SetsKt.emptySet(), SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ChatId, AllowedActions> toMultiUserChatsAllowedActions(@NotNull Set<ChatId> multiUserChatIds, @NotNull Set<ChatId> chatsWithoutWriter, @NotNull Set<ChatId> chatsWithoutManager) {
        Intrinsics.checkNotNullParameter(multiUserChatIds, (String)"multiUserChatIds");
        Intrinsics.checkNotNullParameter(chatsWithoutWriter, (String)"chatsWithoutWriter");
        Intrinsics.checkNotNullParameter(chatsWithoutManager, (String)"chatsWithoutManager");
        Map mayManage = this.mayManageChats(multiUserChatIds);
        Map mayWrite = this.mayWriteChats(multiUserChatIds);
        Iterable $this$associateWith$iv = multiUserChatIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            boolean write;
            void it;
            ChatId chatId = (ChatId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Boolean bl2 = (Boolean)mayManage.get(it);
            boolean manage = bl2 != null ? bl2 : false;
            Boolean bl3 = (Boolean)mayWrite.get(it);
            boolean bl4 = write = bl3 != null ? bl3 : false;
            boolean chatHasNoManager = chatsWithoutManager.contains(it) ? (chatsWithoutWriter.contains(it) ? true : write) : false;
            AllowedActions allowedActions = new AllowedActions(manage, chatHasNoManager, manage, manage, manage, write);
            map.put(t, allowedActions);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void check(Set<? extends PermissionRole> itemsToCheck, PermissionAction permissionAction) {
        void $this$mapTo$iv$iv;
        if (itemsToCheck.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = itemsToCheck;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionRole permissionRole = (PermissionRole)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toActionRole(permissionAction));
        }
        Set rolesToCheck = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.check(rolesToCheck);
    }

    private final void check(Set<Role> rolesToCheck) {
        Map $this$forEach$iv = this.authService.hasRoles(rolesToCheck, this.profileId);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Role role = (Role)entry.getKey();
            AuthorizationResult authResult = (AuthorizationResult)entry.getValue();
            this.checkAuthorizationResult(role, authResult);
        }
    }

    private final void checkAuthorizationResult(Role checkedRole, AuthorizationResult authResult) {
        switch (WhenMappings.$EnumSwitchMapping$0[authResult.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(checkedRole + " does not exist");
                }
                throw new NotFoundException("Failed permission check on " + checkedRole);
            }
            case 3: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.profileId + " is not allowed to " + checkedRole);
                }
                throw new NotAllowedException("Failed permission check on " + checkedRole);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

