/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationException;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import de.justsoftware.authorization.totp.TOTPAuthenticationSuccessHandler;
import de.justsoftware.authorization.totp.TOTPAwareRememberMeService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatchers;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0014J\"\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010!H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lde/justsoftware/authorization/totp/TOTPAwareUsernamePasswordAuthenticationFilter;", "Lorg/springframework/security/web/authentication/UsernamePasswordAuthenticationFilter;", "totpAuthenticationService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "totpAuthenticationSuccessHandler", "Lde/justsoftware/authorization/totp/TOTPAuthenticationSuccessHandler;", "rememberMeServices", "Lde/justsoftware/authorization/totp/TOTPAwareRememberMeService;", "<init>", "(Lde/justsoftware/authorization/totp/TOTPAuthenticationService;Lorg/springframework/security/authentication/AuthenticationManager;Lde/justsoftware/authorization/totp/TOTPAuthenticationSuccessHandler;Lde/justsoftware/authorization/totp/TOTPAwareRememberMeService;)V", "getTotpAuthenticationService", "()Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "getRememberMeServices", "()Lde/justsoftware/authorization/totp/TOTPAwareRememberMeService;", "totpAuthenticationFailureHandler", "Lorg/springframework/security/web/authentication/SimpleUrlAuthenticationFailureHandler;", "getTotpAuthenticationFailureHandler", "()Lorg/springframework/security/web/authentication/SimpleUrlAuthenticationFailureHandler;", "attemptAuthentication", "Lorg/springframework/security/core/Authentication;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "successfulAuthentication", "", "chain", "Ljakarta/servlet/FilterChain;", "authentication", "unsuccessfulAuthentication", "failed", "Lorg/springframework/security/core/AuthenticationException;", "just-authorization-server"})
public final class TOTPAwareUsernamePasswordAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    @NotNull
    private final TOTPAuthenticationService totpAuthenticationService;
    @NotNull
    private final TOTPAwareRememberMeService rememberMeServices;
    @NotNull
    private final SimpleUrlAuthenticationFailureHandler totpAuthenticationFailureHandler;

    public TOTPAwareUsernamePasswordAuthenticationFilter(@NotNull TOTPAuthenticationService totpAuthenticationService, @NotNull AuthenticationManager authenticationManager, @NotNull TOTPAuthenticationSuccessHandler totpAuthenticationSuccessHandler, @NotNull TOTPAwareRememberMeService rememberMeServices) {
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationService, (String)"totpAuthenticationService");
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationSuccessHandler, (String)"totpAuthenticationSuccessHandler");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        super(authenticationManager);
        this.totpAuthenticationService = totpAuthenticationService;
        this.rememberMeServices = rememberMeServices;
        this.totpAuthenticationFailureHandler = new SimpleUrlAuthenticationFailureHandler("/totp/login?error=wrong_code");
        RequestMatcher[] requestMatcherArray = new RequestMatcher[]{new AntPathRequestMatcher("/login", "POST"), new AntPathRequestMatcher("/totp/login", "POST")};
        this.setRequiresAuthenticationRequestMatcher(RequestMatchers.anyOf((RequestMatcher[])requestMatcherArray));
        this.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)totpAuthenticationSuccessHandler);
        this.setRememberMeServices((RememberMeServices)this.rememberMeServices);
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler("/login?error"));
        this.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
        this.setSecurityContextRepository((SecurityContextRepository)new HttpSessionSecurityContextRepository());
    }

    @NotNull
    public final TOTPAuthenticationService getTotpAuthenticationService() {
        return this.totpAuthenticationService;
    }

    @NotNull
    public final TOTPAwareRememberMeService getRememberMeServices() {
        return this.rememberMeServices;
    }

    @NotNull
    public final SimpleUrlAuthenticationFailureHandler getTotpAuthenticationFailureHandler() {
        return this.totpAuthenticationFailureHandler;
    }

    @Nullable
    public Authentication attemptAuthentication(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Authentication currentAuthentication;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Object object = currentAuthentication = securityContext != null ? securityContext.getAuthentication() : null;
        if (currentAuthentication instanceof TOTPAuthentication && !((TOTPAuthentication)currentAuthentication).getAuthenticated()) {
            String code = request.getParameter("code");
            ((TOTPAuthentication)currentAuthentication).setCode(code);
            return this.getAuthenticationManager().authenticate(currentAuthentication);
        }
        return super.attemptAuthentication(request, response);
    }

    protected void successfulAuthentication(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain, @NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        if (authentication instanceof TOTPAuthentication) {
            super.successfulAuthentication(request, response, chain, authentication);
        } else {
            Object object = authentication.getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.justsoftware.authorization.oauth2.JustUser");
            if (this.totpAuthenticationService.isMFARequired((JustUser)object)) {
                boolean remember = this.rememberMeServices.rememberMeRequested(request);
                TOTPAuthentication totpAuthentication = new TOTPAuthentication(authentication, false, remember, null, 10, null);
                super.successfulAuthentication(request, response, chain, (Authentication)totpAuthentication);
            } else {
                super.successfulAuthentication(request, response, chain, authentication);
            }
        }
    }

    protected void unsuccessfulAuthentication(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @Nullable AuthenticationException failed) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (failed instanceof TOTPAuthenticationException) {
            this.totpAuthenticationFailureHandler.onAuthenticationFailure(request, response, failed);
        } else {
            super.unsuccessfulAuthentication(request, response, failed);
        }
    }
}

