/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client.oauth2Authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.client.oauth2Authorization.Oauth2Authorizations;
import de.justsoftware.authorization.token.ApiToken;
import de.justsoftware.authorization.token.Scope;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.UpsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0012J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0016J \u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\"H\u0016J\u0018\u0010$\u001a\u0004\u0018\u00010\u001b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0016\u00a8\u0006+"}, d2={"Lde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository;", "", "<init>", "()V", "upsert", "", "authorization", "Lorg/springframework/security/oauth2/server/authorization/OAuth2Authorization;", "client", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "setProfileAndTenantId", "it", "Lorg/jetbrains/exposed/sql/statements/UpsertStatement;", "", "getJustUser", "Lde/justsoftware/authorization/oauth2/JustUser;", "principal", "findAllOauth2Authorizations", "Lde/justsoftware/authorization/token/ApiToken;", "clientId", "Ljava/util/UUID;", "tenantId", "deleteByClientId", "deleteById", "findById", "Lorg/jetbrains/exposed/sql/ResultRow;", "id", "deleteByProfileIdAndRegisteredClientIds", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "clientIds", "", "countTokensForProfileAndClients", "selectAllByPredicate", "predicate", "Lorg/jetbrains/exposed/sql/Op;", "", "deleteExpiredTokens", "maxExpiryTime", "Ljava/time/Instant;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nOauth2AuthorizationRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Oauth2AuthorizationRepository.kt\nde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n*L\n1#1,167:1\n1#2:168\n1557#3:169\n1628#3,2:170\n1557#3:172\n1628#3,3:173\n1630#3:176\n122#4,8:177\n122#4,8:185\n122#4,8:193\n122#4,8:201\n*S KotlinDebug\n*F\n+ 1 Oauth2AuthorizationRepository.kt\nde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository\n*L\n121#1:169\n121#1:170,2\n125#1:172\n125#1:173,3\n121#1:176\n131#1:177,8\n135#1:185,8\n143#1:193,8\n159#1:201,8\n*E\n"})
public class Oauth2AuthorizationRepository {
    public void upsert(@NotNull OAuth2Authorization authorization, @NotNull RegisteredClient client, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        QueriesKt.upsert$default((Table)((Table)Oauth2Authorizations.INSTANCE), (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> Oauth2AuthorizationRepository.upsert$lambda$1(authorization, this, client, objectMapper, arg_0, arg_1), (int)14, null);
    }

    private void setProfileAndTenantId(UpsertStatement<Long> it, OAuth2Authorization authorization, RegisteredClient client) {
        block2: {
            block1: {
                Object principal = authorization.getAttributes().get(Principal.class.getName());
                JustUser user = this.getJustUser(principal);
                if (user == null) break block1;
                if (user.getTenantId() != null) {
                    it.set(Oauth2Authorizations.INSTANCE.getPrincipalTenantId(), (Object)user.getTenantId().getValue());
                }
                it.set(Oauth2Authorizations.INSTANCE.getPrincipalProfileId(), (Object)user.getProfileId().toTypedString());
                break block2;
            }
            TenantId tenantId = ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)client);
            if (tenantId == null) break block2;
            TenantId tenantId2 = tenantId;
            boolean bl = false;
            it.set(Oauth2Authorizations.INSTANCE.getPrincipalTenantId(), (Object)tenantId2.getValue());
        }
    }

    private JustUser getJustUser(Object principal) {
        if (principal instanceof AbstractAuthenticationToken) {
            Object user = ((AbstractAuthenticationToken)principal).getPrincipal();
            if (user instanceof JustUser) {
                return (JustUser)user;
            }
        } else if (principal instanceof TOTPAuthentication) {
            return this.getJustUser((Object)((TOTPAuthentication)principal).getInitial());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ApiToken findAllOauth2Authorizations(@NotNull UUID clientId, @NotNull UUID tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$map$iv = (Iterable)QueryKt.andWhere((Query)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(arg_0 -> Oauth2AuthorizationRepository.findAllOauth2Authorizations$lambda$3(clientId, arg_0)), arg_0 -> Oauth2AuthorizationRepository.findAllOauth2Authorizations$lambda$4(tenantId, arg_0));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<Scope> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void resultRow;
            ResultRow resultRow2 = (ResultRow)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Object object = resultRow.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenValue());
            Intrinsics.checkNotNull((Object)object);
            String string = (String)object;
            Object object2 = resultRow.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Intrinsics.checkNotNull((Object)object2);
            Instant instant = (Instant)object2;
            Set set = StringUtils.commaDelimitedListToSet((String)((String)resultRow.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizedScopes())));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
            Iterable iterable2 = set;
            Instant instant2 = instant;
            String string2 = string;
            boolean $i$f$map2 = false;
            void var16_16 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string3 = (String)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(Scope.valueOf((String)it));
            }
            collection = (List)destination$iv$iv2;
            Set set2 = CollectionsKt.toSet((Iterable)collection);
            Instant instant3 = instant2;
            String string4 = string2;
            collection2.add(new ApiToken(string4, instant3, set2));
        }
        return (ApiToken)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteByClientId(@NotNull RegisteredClient client) {
        void $this$deleteByClientId_u24lambda_u247;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this$deleteByClientId_u24lambda_u247.getRegisteredClientId(), (Object)UUID.fromString(client.getId()));
        companion.where(transaction, table, op, false, limit$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteById(@NotNull OAuth2Authorization authorization) {
        void $this$deleteById_u24lambda_u248;
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = SqlExpressionBuilder.INSTANCE.eqEntityIDValue((ExpressionWithColumnType)$this$deleteById_u24lambda_u248.getId(), (Object)UUID.fromString(authorization.getId()));
        companion.where(transaction, table, op, false, limit$iv);
    }

    @Nullable
    public ResultRow findById(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eqEntityIDValue((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getId(), (Object)id))));
    }

    /*
     * WARNING - void declaration
     */
    public int deleteByProfileIdAndRegisteredClientIds(@NotNull ProfileId profileId, @NotNull Set<UUID> clientIds) {
        void $this$deleteByProfileIdAndRegisteredClientIds_u24lambda_u249;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(clientIds, (String)"clientIds");
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this$deleteByProfileIdAndRegisteredClientIds_u24lambda_u249.getPrincipalProfileId(), (Object)profileId.toTypedString())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.inList((ExpressionWithColumnType)$this$deleteByProfileIdAndRegisteredClientIds_u24lambda_u249.getRegisteredClientId(), (Iterable)clientIds)));
        return companion.where(transaction, table, op, false, limit$iv);
    }

    public int countTokensForProfileAndClients(@NotNull ProfileId profileId, @Nullable Set<UUID> clientIds) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Query query = QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(arg_0 -> Oauth2AuthorizationRepository.countTokensForProfileAndClients$lambda$10(profileId, arg_0));
        Collection collection = clientIds;
        if (!(collection == null || collection.isEmpty())) {
            QueryKt.andWhere((Query)query, arg_0 -> Oauth2AuthorizationRepository.countTokensForProfileAndClients$lambda$11(clientIds, arg_0));
        }
        return (int)query.count();
    }

    @Nullable
    public ResultRow selectAllByPredicate(@NotNull Op<Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(predicate)));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteExpiredTokens(@NotNull Instant maxExpiryTime) {
        void $this$deleteExpiredTokens_u24lambda_u2412;
        Intrinsics.checkNotNullParameter((Object)maxExpiryTime, (String)"maxExpiryTime");
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = OpKt.and((Expression)((Expression)OpKt.and((Expression)((Expression)OpKt.or((Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNull((Expression)$this$deleteExpiredTokens_u24lambda_u2412.getAccessTokenExpiresAt())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.less((ExpressionWithColumnType)$this$deleteExpiredTokens_u24lambda_u2412.getAccessTokenExpiresAt(), (Comparable)maxExpiryTime)))), (Expression)((Expression)OpKt.or((Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNull((Expression)$this$deleteExpiredTokens_u24lambda_u2412.getRefreshTokenExpiresAt())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.less((ExpressionWithColumnType)$this$deleteExpiredTokens_u24lambda_u2412.getRefreshTokenExpiresAt(), (Comparable)maxExpiryTime)))))), (Expression)((Expression)OpKt.or((Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNull((Expression)$this$deleteExpiredTokens_u24lambda_u2412.getAuthorizationCodeExpiresAt())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.less((ExpressionWithColumnType)$this$deleteExpiredTokens_u24lambda_u2412.getAuthorizationCodeExpiresAt(), (Comparable)maxExpiryTime)))));
        companion.where(transaction, table, op, false, limit$iv);
    }

    private static final Unit upsert$lambda$1(OAuth2Authorization $authorization, Oauth2AuthorizationRepository this$0, RegisteredClient $client, ObjectMapper $objectMapper, Oauth2Authorizations $this$upsert, UpsertStatement it) {
        OAuth2Authorization.Token token;
        OAuth2Authorization.Token token2;
        OAuth2Authorization.Token token3;
        OAuth2Authorization.Token token4;
        OAuth2Authorization.Token token5;
        OAuth2Authorization.Token token6;
        OAuth2Authorization.Token token7;
        OAuth2Authorization.Token token8;
        OAuth2Authorization.Token token9;
        OAuth2Authorization.Token token10;
        OAuth2Authorization.Token token11;
        OAuth2Authorization.Token token12;
        OAuth2Authorization.Token token13;
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Column column = $this$upsert.getId();
        UUID uUID = UUID.fromString($authorization.getId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        it.setWithEntityIdValue(column, (Object)uUID);
        it.set($this$upsert.getRegisteredClientId(), (Object)UUID.fromString($authorization.getRegisteredClientId()));
        it.set($this$upsert.getPrincipalName(), (Object)$authorization.getPrincipalName());
        this$0.setProfileAndTenantId(it, $authorization, $client);
        it.set($this$upsert.getAuthorizationGrantType(), (Object)$authorization.getAuthorizationGrantType().getValue());
        it.set($this$upsert.getAuthorizedScopes(), (Object)StringUtils.collectionToCommaDelimitedString((Collection)$authorization.getAuthorizedScopes()));
        it.set($this$upsert.getState(), $authorization.getAttribute("state"));
        it.set($this$upsert.getAttributes(), (Object)$objectMapper.writeValueAsString((Object)$authorization.getAttributes()));
        OAuth2Authorization.Token authorizationCodeToken = $authorization.getToken(OAuth2AuthorizationCode.class);
        it.set($this$upsert.getAuthorizationCodeValue(), (token13 = authorizationCodeToken) != null && (token13 = (OAuth2AuthorizationCode)token13.getToken()) != null ? token13.getTokenValue() : null);
        it.set($this$upsert.getAuthorizationCodeIssuedAt(), (token12 = authorizationCodeToken) != null && (token12 = (OAuth2AuthorizationCode)token12.getToken()) != null ? token12.getIssuedAt() : null);
        it.set($this$upsert.getAuthorizationCodeExpiresAt(), (token11 = authorizationCodeToken) != null && (token11 = (OAuth2AuthorizationCode)token11.getToken()) != null ? token11.getExpiresAt() : null);
        OAuth2Authorization.Token token14 = authorizationCodeToken;
        it.set($this$upsert.getAuthorizationCodeMetadata(), (Object)$objectMapper.writeValueAsString((Object)(token14 != null ? token14.getMetadata() : null)));
        OAuth2Authorization.Token accessToken = $authorization.getAccessToken();
        it.set($this$upsert.getAccessTokenValue(), (token10 = accessToken) != null && (token10 = (OAuth2AccessToken)token10.getToken()) != null ? token10.getTokenValue() : null);
        it.set($this$upsert.getAccessTokenIssuedAt(), (token9 = accessToken) != null && (token9 = (OAuth2AccessToken)token9.getToken()) != null ? token9.getIssuedAt() : null);
        it.set($this$upsert.getAccessTokenExpiresAt(), (token8 = accessToken) != null && (token8 = (OAuth2AccessToken)token8.getToken()) != null ? token8.getExpiresAt() : null);
        OAuth2Authorization.Token token15 = accessToken;
        it.set($this$upsert.getAccessTokenMetadata(), (Object)$objectMapper.writeValueAsString((Object)(token15 != null ? token15.getMetadata() : null)));
        it.set($this$upsert.getAccessTokenType(), (token7 = accessToken) != null && (token7 = (OAuth2AccessToken)token7.getToken()) != null && (token7 = token7.getTokenType()) != null ? token7.getValue() : null);
        OAuth2Authorization.Token token16 = accessToken;
        if (token16 != null && (token16 = (OAuth2AccessToken)token16.getToken()) != null) {
            boolean bl = false;
            it.set($this$upsert.getAccessTokenScopes(), (Object)StringUtils.collectionToCommaDelimitedString((Collection)((OAuth2AccessToken)accessToken.getToken()).getScopes()));
        }
        OAuth2Authorization.Token oidcIdToken = $authorization.getToken(OidcIdToken.class);
        it.set($this$upsert.getOidcTokenValue(), (token6 = oidcIdToken) != null && (token6 = (OidcIdToken)token6.getToken()) != null ? token6.getTokenValue() : null);
        it.set($this$upsert.getOidcTokenIssuedAt(), (token5 = oidcIdToken) != null && (token5 = (OidcIdToken)token5.getToken()) != null ? token5.getIssuedAt() : null);
        it.set($this$upsert.getOidcTokenExpiresAt(), (token4 = oidcIdToken) != null && (token4 = (OidcIdToken)token4.getToken()) != null ? token4.getExpiresAt() : null);
        OAuth2Authorization.Token token17 = oidcIdToken;
        it.set($this$upsert.getOidcTokenMetadata(), (Object)$objectMapper.writeValueAsString((Object)(token17 != null ? token17.getMetadata() : null)));
        OAuth2Authorization.Token refreshToken = $authorization.getToken(OAuth2RefreshToken.class);
        it.set($this$upsert.getRefreshTokenValue(), (token3 = refreshToken) != null && (token3 = (OAuth2RefreshToken)token3.getToken()) != null ? token3.getTokenValue() : null);
        it.set($this$upsert.getRefreshTokenIssuedAt(), (token2 = refreshToken) != null && (token2 = (OAuth2RefreshToken)token2.getToken()) != null ? token2.getIssuedAt() : null);
        it.set($this$upsert.getRefreshTokenExpiresAt(), (token = refreshToken) != null && (token = (OAuth2RefreshToken)token.getToken()) != null ? token.getExpiresAt() : null);
        OAuth2Authorization.Token token18 = refreshToken;
        it.set($this$upsert.getRefreshTokenMetadata(), (Object)$objectMapper.writeValueAsString((Object)(token18 != null ? token18.getMetadata() : null)));
        return Unit.INSTANCE;
    }

    private static final Op findAllOauth2Authorizations$lambda$3(UUID $clientId, SqlExpressionBuilder $this$where) {
        Intrinsics.checkNotNullParameter((Object)$this$where, (String)"$this$where");
        return $this$where.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getRegisteredClientId(), (Object)$clientId);
    }

    private static final Op findAllOauth2Authorizations$lambda$4(UUID $tenantId, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getPrincipalTenantId(), (Object)$tenantId);
    }

    private static final Op countTokensForProfileAndClients$lambda$10(ProfileId $profileId, SqlExpressionBuilder $this$where) {
        Intrinsics.checkNotNullParameter((Object)$this$where, (String)"$this$where");
        return $this$where.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getPrincipalProfileId(), (Object)$profileId.toTypedString());
    }

    private static final Op countTokensForProfileAndClients$lambda$11(Set $clientIds, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return (Op)$this$andWhere.inList((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getRegisteredClientId(), (Iterable)$clientIds);
    }
}

