/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.authorization.config.JustOauthClients;
import de.justsoftware.authorization.id.ItemIdDeserializer;
import de.justsoftware.authorization.id.ItemIdSerializer;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.client.OauthTokenService;
import de.justsoftware.authorization.oauth2.client.RegisteredClients;
import de.justsoftware.authorization.oauth2.client.oauth2Authorization.Oauth2AuthorizationRepository;
import de.justsoftware.authorization.oauth2.client.oauth2Authorization.Oauth2Authorizations;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J \u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0012J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0012J\u001e\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006/"}, d2={"Lde/justsoftware/authorization/oauth2/client/Oauth2AuthorizationService;", "Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "Lde/justsoftware/authorization/oauth2/client/OauthTokenService;", "registeredClientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "oauth2AuthorizationRepository", "Lde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository;", "<init>", "(Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;Lde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository;)V", "getOauth2AuthorizationRepository", "()Lde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository;", "objectMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "save", "", "authorization", "Lorg/springframework/security/oauth2/server/authorization/OAuth2Authorization;", "remove", "findById", "id", "", "toOauth2Authorization", "it", "Lorg/jetbrains/exposed/sql/ResultRow;", "parseMap", "", "", "data", "findByToken", "token", "tokenType", "Lorg/springframework/security/oauth2/server/authorization/OAuth2TokenType;", "deleteMobileTokensForProfile", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "countMobileTokensForProfile", "getMobileClientIds", "", "Ljava/util/UUID;", "countTokensForProfileAndClients", "registeredClientIds", "deleteExpiredTokens", "expiredFor", "Ljava/time/Duration;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nOauth2AuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Oauth2AuthorizationService.kt\nde/justsoftware/authorization/oauth2/client/Oauth2AuthorizationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1#2:250\n1557#3:251\n1628#3,3:252\n*S KotlinDebug\n*F\n+ 1 Oauth2AuthorizationService.kt\nde/justsoftware/authorization/oauth2/client/Oauth2AuthorizationService\n*L\n235#1:251\n235#1:252,3\n*E\n"})
public class Oauth2AuthorizationService
implements OAuth2AuthorizationService,
OauthTokenService {
    @NotNull
    private final RegisteredClientRepository registeredClientRepository;
    @NotNull
    private final Oauth2AuthorizationRepository oauth2AuthorizationRepository;
    @NotNull
    private final JsonMapper objectMapper;

    public Oauth2AuthorizationService(@NotNull RegisteredClientRepository registeredClientRepository, @NotNull Oauth2AuthorizationRepository oauth2AuthorizationRepository) {
        Intrinsics.checkNotNullParameter((Object)registeredClientRepository, (String)"registeredClientRepository");
        Intrinsics.checkNotNullParameter((Object)oauth2AuthorizationRepository, (String)"oauth2AuthorizationRepository");
        this.registeredClientRepository = registeredClientRepository;
        this.oauth2AuthorizationRepository = oauth2AuthorizationRepository;
        Module[] moduleArray = new Module[]{ItemIdSerializer.INSTANCE, ItemIdDeserializer.INSTANCE};
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ExtensionsKt.jacksonMapperBuilder().addModule((Module)new OAuth2AuthorizationServerJackson2Module())).addModules((Iterable)SecurityJackson2Modules.getModules((ClassLoader)this.getClass().getClassLoader()))).addModules(moduleArray)).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        this.objectMapper = (JsonMapper)objectMapper;
    }

    @NotNull
    public Oauth2AuthorizationRepository getOauth2AuthorizationRepository() {
        return this.oauth2AuthorizationRepository;
    }

    @NotNull
    public JsonMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void save(@NotNull OAuth2Authorization authorization) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        RegisteredClient registeredClient = this.registeredClientRepository.findById(authorization.getRegisteredClientId());
        Intrinsics.checkNotNull((Object)registeredClient);
        RegisteredClient client = registeredClient;
        this.getOauth2AuthorizationRepository().upsert(authorization, client, (ObjectMapper)this.getObjectMapper());
    }

    public void remove(@NotNull OAuth2Authorization authorization) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        this.getOauth2AuthorizationRepository().deleteById(authorization);
    }

    @Nullable
    public OAuth2Authorization findById(@NotNull String id) {
        OAuth2Authorization oAuth2Authorization;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Oauth2AuthorizationRepository oauth2AuthorizationRepository = this.getOauth2AuthorizationRepository();
        UUID uUID = UUID.fromString(id);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        ResultRow resultRow = oauth2AuthorizationRepository.findById(uUID);
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            oAuth2Authorization = this.toOauth2Authorization(it);
        } else {
            oAuth2Authorization = null;
        }
        return oAuth2Authorization;
    }

    private OAuth2Authorization toOauth2Authorization(ResultRow it) {
        String refreshTokenValue;
        String oidcIdTokenValue;
        CharSequence authorizationCode;
        String authorizationCodeValue;
        UUID registeredClientId = (UUID)it.get((Expression)Oauth2Authorizations.INSTANCE.getRegisteredClientId());
        RegisteredClient registeredClient = this.registeredClientRepository.findById(registeredClientId.toString());
        if (registeredClient == null) {
            throw new DataRetrievalFailureException("The RegisteredClient with id '" + registeredClientId + "' was not found in the RegisteredClientRepository.");
        }
        RegisteredClient registeredClient2 = registeredClient;
        String profileId = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalProfileId());
        OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient2).id(((UUID)((EntityID)it.get((Expression)Oauth2Authorizations.INSTANCE.getId())).getValue()).toString()).principalName((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalName())).authorizationGrantType(new AuthorizationGrantType((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationGrantType()))).authorizedScopes(StringUtils.commaDelimitedListToSet((String)((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizedScopes())))).attributes(arg_0 -> Oauth2AuthorizationService.toOauth2Authorization$lambda$2(this, it, profileId, arg_0));
        Instant tokenIssuedAt = null;
        Instant tokenExpiresAt = null;
        String accessTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenValue());
        CharSequence charSequence = accessTokenValue;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Map accessTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenMetadata()));
            OAuth2AccessToken.TokenType tokenType = OAuth2AccessToken.TokenType.BEARER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenType, (String)"BEARER");
            OAuth2AccessToken.TokenType tokenType2 = tokenType;
            Set set = StringUtils.commaDelimitedListToSet((String)((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenScopes())));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
            Set accessTokenScopes = set;
            OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType2, accessTokenValue, tokenIssuedAt, tokenExpiresAt, accessTokenScopes);
            builder.token((OAuth2Token)accessToken, arg_0 -> Oauth2AuthorizationService.toOauth2Authorization$lambda$4(accessTokenMetadata, profileId, it, arg_0));
        }
        if (StringUtils.hasText((String)(authorizationCodeValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationCodeValue())))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Map authorizationCodeMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationCodeMetadata()));
            authorizationCode = new OAuth2AuthorizationCode(authorizationCodeValue, tokenIssuedAt, tokenExpiresAt);
            builder.token((OAuth2Token)authorizationCode, arg_0 -> Oauth2AuthorizationService.toOauth2Authorization$lambda$5(authorizationCodeMetadata, arg_0));
        }
        if (!((authorizationCode = (CharSequence)(oidcIdTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenValue()))) == null || StringsKt.isBlank((CharSequence)authorizationCode))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenExpiresAt());
            Map oidcTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenMetadata()));
            OidcIdToken oidcToken = new OidcIdToken(oidcIdTokenValue, tokenIssuedAt, tokenExpiresAt, (Map)oidcTokenMetadata.get(OAuth2Authorization.Token.CLAIMS_METADATA_NAME));
            builder.token((OAuth2Token)oidcToken, arg_0 -> Oauth2AuthorizationService.toOauth2Authorization$lambda$6(oidcTokenMetadata, arg_0));
        }
        if (StringUtils.hasText((String)(refreshTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenValue())))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenExpiresAt());
            Map refreshTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenMetadata()));
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(refreshTokenValue, tokenIssuedAt, tokenExpiresAt);
            builder.token((OAuth2Token)refreshToken, arg_0 -> Oauth2AuthorizationService.toOauth2Authorization$lambda$7(refreshTokenMetadata, arg_0));
        }
        OAuth2Authorization oAuth2Authorization = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)oAuth2Authorization, (String)"build(...)");
        return oAuth2Authorization;
    }

    private Map<String, Object> parseMap(String data) {
        try {
            Map map;
            if (data == null) {
                map = MapsKt.emptyMap();
            } else {
                Object object = this.getObjectMapper().readValue(data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                map = (Map)object;
            }
            return map;
        }
        catch (JacksonException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    @Nullable
    public OAuth2Authorization findByToken(@NotNull String token, @Nullable OAuth2TokenType tokenType) {
        OAuth2Authorization oAuth2Authorization;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        OAuth2TokenType oAuth2TokenType = tokenType;
        Op predicate = Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("code")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAuthorizationCodeValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)OAuth2TokenType.REFRESH_TOKEN) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getRefreshTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)OAuth2TokenType.ACCESS_TOKEN) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAccessTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("id_token")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getOidcTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("state")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getState(), (Object)token) : SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAccessTokenValue(), (Object)token)))));
        ResultRow resultRow = this.getOauth2AuthorizationRepository().selectAllByPredicate(predicate);
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            oAuth2Authorization = this.toOauth2Authorization(it);
        } else {
            oAuth2Authorization = null;
        }
        return oAuth2Authorization;
    }

    public int deleteMobileTokensForProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Set mobileClients = this.getMobileClientIds();
        return this.getOauth2AuthorizationRepository().deleteByProfileIdAndRegisteredClientIds(profileId, mobileClients);
    }

    public int countMobileTokensForProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Set mobileClients = this.getMobileClientIds();
        return this.countTokensForProfileAndClients(profileId, mobileClients);
    }

    /*
     * WARNING - void declaration
     */
    private Set<UUID> getMobileClientIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)RegisteredClients.INSTANCE)).where(Oauth2AuthorizationService::getMobileClientIds$lambda$9);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultRow resultRow = (ResultRow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((UUID)((EntityID)it.get((Expression)RegisteredClients.INSTANCE.getId())).getValue());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public int countTokensForProfileAndClients(@NotNull ProfileId profileId, @NotNull Set<UUID> registeredClientIds) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(registeredClientIds, (String)"registeredClientIds");
        return this.getOauth2AuthorizationRepository().countTokensForProfileAndClients(profileId, registeredClientIds);
    }

    public void deleteExpiredTokens(@NotNull Duration expiredFor) {
        Intrinsics.checkNotNullParameter((Object)expiredFor, (String)"expiredFor");
        Instant maxExpiryTime = Instant.now().minus(expiredFor);
        Oauth2AuthorizationRepository oauth2AuthorizationRepository = this.getOauth2AuthorizationRepository();
        Intrinsics.checkNotNull((Object)maxExpiryTime);
        oauth2AuthorizationRepository.deleteExpiredTokens(maxExpiryTime);
    }

    /*
     * WARNING - void declaration
     */
    private static final void toOauth2Authorization$lambda$2(Oauth2AuthorizationService this$0, ResultRow $it, String $profileId, Map attributes) {
        attributes.putAll(this$0.parseMap((String)$it.get((Expression)Oauth2Authorizations.INSTANCE.getAttributes())));
        if ($it.get((Expression)Oauth2Authorizations.INSTANCE.getAttributes()) == null && $profileId != null) {
            TenantId tenantId;
            ProfileId profileId = ProfileId.Companion.fromString($profileId);
            UUID uUID = (UUID)$it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalTenantId());
            if (uUID != null) {
                void uuid;
                UUID uUID2 = uUID;
                ProfileId profileId2 = profileId;
                boolean bl = false;
                tenantId = TenantId.Companion.fromValue((UUID)uuid);
                profileId = profileId2;
            } else {
                tenantId = null;
            }
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            List list = new ArrayList();
            String string = null;
            String string2 = (String)$it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalName());
            TenantId tenantId2 = tenantId;
            ProfileId profileId3 = profileId;
            JustUser justUser = new JustUser(profileId3, tenantId2, string2, string, list, bl4, bl3, bl2, bl);
            UsernamePasswordAuthenticationToken principal = new UsernamePasswordAuthenticationToken((Object)justUser, null, (Collection)justUser.getAuthorities());
            Intrinsics.checkNotNull((Object)attributes);
            attributes.put(Principal.class.getName(), principal);
        }
    }

    private static final void toOauth2Authorization$lambda$4(Map $accessTokenMetadata, String $profileId, ResultRow $it, Map metadata) {
        metadata.putAll($accessTokenMetadata);
        if ($accessTokenMetadata.isEmpty()) {
            String string;
            Map claims = new LinkedHashMap();
            if ($profileId != null) {
                claims.put(ProfileId.Companion.getJsonKey(), $profileId);
            }
            Map map = claims;
            String string2 = TenantId.Companion.getJsonKey();
            UUID uUID = (UUID)$it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalTenantId());
            if (uUID != null) {
                UUID uuid = uUID;
                boolean bl = false;
                string = TenantId.Companion.fromValue(uuid).toTypedString();
            } else {
                string = null;
            }
            String string3 = string;
            map.put(string2, string3);
            claims.put("username", $it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalName()));
            claims.put("scope", $it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizedScopes()));
            Intrinsics.checkNotNull((Object)metadata);
            metadata.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, MapsKt.toMap((Map)claims));
        }
    }

    private static final void toOauth2Authorization$lambda$5(Map $authorizationCodeMetadata, Map metadata) {
        metadata.putAll($authorizationCodeMetadata);
    }

    private static final void toOauth2Authorization$lambda$6(Map $oidcTokenMetadata, Map metadata) {
        metadata.putAll($oidcTokenMetadata);
    }

    private static final void toOauth2Authorization$lambda$7(Map $refreshTokenMetadata, Map metadata) {
        metadata.putAll($refreshTokenMetadata);
    }

    private static final Op getMobileClientIds$lambda$9(SqlExpressionBuilder $this$where) {
        Intrinsics.checkNotNullParameter((Object)$this$where, (String)"$this$where");
        return (Op)$this$where.inList((ExpressionWithColumnType)RegisteredClients.INSTANCE.getClientId(), (Iterable)JustOauthClients.Companion.getMOBILE_CLIENT_IDS());
    }
}

