/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import de.justsoftware.authorization.config.InvalidateSessionAndAddTrustedDeviceAndRedirectHandler;
import de.justsoftware.authorization.config.JustOauthClients;
import de.justsoftware.authorization.config.LogoutSuccessHandler;
import de.justsoftware.authorization.config.SecurityConfig;
import de.justsoftware.authorization.filter.JwtFilter;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustAuthenticationProvider;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationConverter;
import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationProvider;
import de.justsoftware.authorization.oauth2.MobileOauth2RefreshTokenGenerator;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepository;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.client.Oauth2AuthorizationService;
import de.justsoftware.authorization.oauth2.passwordGrant.OAuth2PasswordGrantAuthenticationConverter;
import de.justsoftware.authorization.oauth2.passwordGrant.OAuth2PasswordGrantAuthenticationProvider;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationException;
import de.justsoftware.authorization.totp.TOTPAuthenticationManager;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import de.justsoftware.authorization.totp.TOTPAuthenticationSuccessHandler;
import de.justsoftware.authorization.totp.TOTPAwareRememberMeService;
import de.justsoftware.authorization.totp.TOTPAwareUsernamePasswordAuthenticationFilter;
import de.justsoftware.authorization.totp.TotpAwareAccessDeniedHandler;
import de.justsoftware.authorization.trusteddevice.TrustedDeviceAuthenticationHandler;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration.OAuth2AuthorizationServerConfiguration;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ClientAuthenticationConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2TokenEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcLogoutEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.DelegatingOAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.JwtGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2AccessTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2RefreshTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@DependsOn(value={"liquibase"})
@RefreshScope
@Configuration
@EnableWebSecurity
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017Jb\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\b\u0001\u0010!\u001a\u00020\"H\u0017J:\u0010#\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0017J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0017J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0017J \u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0017J\u0016\u00105\u001a\u0002062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0017J\b\u00107\u001a\u000208H\u0017J\b\u00109\u001a\u00020:H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006<"}, d2={"Lde/justsoftware/authorization/config/SecurityConfig;", "", "justAuthProvider", "Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "totpAuthenticationManager", "Lde/justsoftware/authorization/totp/TOTPAuthenticationManager;", "<init>", "(Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;Lde/justsoftware/authorization/totp/TOTPAuthenticationManager;)V", "getTotpAuthenticationManager", "()Lde/justsoftware/authorization/totp/TOTPAuthenticationManager;", "authManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "authenticationEventPublisher", "Lorg/springframework/security/authentication/AuthenticationEventPublisher;", "authorizationServerSecurityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "registeredClientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "justTokenGenerator", "Lorg/springframework/security/oauth2/server/authorization/token/OAuth2TokenGenerator;", "Lorg/springframework/security/oauth2/core/OAuth2Token;", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "rememberMeServices", "Lde/justsoftware/authorization/totp/TOTPAwareRememberMeService;", "authorizationService", "Lde/justsoftware/authorization/oauth2/client/Oauth2AuthorizationService;", "trustedDeviceAuthenticationHandler", "Lde/justsoftware/authorization/trusteddevice/TrustedDeviceAuthenticationHandler;", "justAuthenticationProvider", "systemDomainPrefix", "", "defaultSecurityFilterChain", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "totpAuthenticationService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "totpAuthenticationSuccessHandler", "Lde/justsoftware/authorization/totp/TOTPAuthenticationSuccessHandler;", "mfaAuthenticated", "Lorg/springframework/security/authorization/AuthorizationManager;", "Lorg/springframework/security/web/access/intercept/RequestAuthorizationContext;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "userDetailService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "dataSource", "Ljavax/sql/DataSource;", "justAuthClients", "Lde/justsoftware/authorization/config/JustOauthClients;", "jwtDecoder", "Lorg/springframework/security/oauth2/jwt/JwtDecoder;", "authorizationServerSettings", "Lorg/springframework/security/oauth2/server/authorization/settings/AuthorizationServerSettings;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "Companion", "just-authorization-server"})
public class SecurityConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JustAuthenticationProvider justAuthProvider;
    @NotNull
    private final TOTPAuthenticationManager totpAuthenticationManager;
    private static final int TORO_BCRYPT_STRENGTH = 12;
    private static final int KEY_SIZE = 2048;
    private static final int THIRTY_DAYS_IN_SECONDS = 2592000;
    @NotNull
    private static final String[] UNAUTHORIZED_PATHS;

    public SecurityConfig(@NotNull JustAuthenticationProvider justAuthProvider, @NotNull TOTPAuthenticationManager totpAuthenticationManager) {
        Intrinsics.checkNotNullParameter((Object)justAuthProvider, (String)"justAuthProvider");
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationManager, (String)"totpAuthenticationManager");
        this.justAuthProvider = justAuthProvider;
        this.totpAuthenticationManager = totpAuthenticationManager;
    }

    @NotNull
    public TOTPAuthenticationManager getTotpAuthenticationManager() {
        return this.totpAuthenticationManager;
    }

    @Bean
    @NotNull
    public AuthenticationManager authManager(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        authenticationManagerBuilder.parentAuthenticationManager(null).authenticationProvider((AuthenticationProvider)this.justAuthProvider).authenticationProvider((AuthenticationProvider)this.getTotpAuthenticationManager());
        Object object = authenticationManagerBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AuthenticationManager)object;
    }

    @Bean
    @NotNull
    public AuthenticationEventPublisher authenticationEventPublisher() {
        DefaultAuthenticationEventPublisher eventPublisher = new DefaultAuthenticationEventPublisher();
        eventPublisher.setAdditionalExceptionMappings(MapsKt.mapOf((Pair)TuplesKt.to(TOTPAuthenticationException.class, AuthenticationFailureBadCredentialsEvent.class)));
        return (AuthenticationEventPublisher)eventPublisher;
    }

    @Bean
    @Order(value=1)
    @NotNull
    public SecurityFilterChain authorizationServerSecurityFilterChain(@NotNull HttpSecurity http, @NotNull RegisteredClientRepository registeredClientRepository, @NotNull OAuth2TokenGenerator<? extends OAuth2Token> justTokenGenerator, @NotNull JWKSource<SecurityContext> jwkSource, @NotNull TOTPAwareRememberMeService rememberMeServices, @NotNull Oauth2AuthorizationService authorizationService, @NotNull TrustedDeviceAuthenticationHandler trustedDeviceAuthenticationHandler, @NotNull JustAuthenticationProvider justAuthenticationProvider, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)registeredClientRepository, (String)"registeredClientRepository");
        Intrinsics.checkNotNullParameter(justTokenGenerator, (String)"justTokenGenerator");
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)trustedDeviceAuthenticationHandler, (String)"trustedDeviceAuthenticationHandler");
        Intrinsics.checkNotNullParameter((Object)justAuthenticationProvider, (String)"justAuthenticationProvider");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        http.setSharedObject(JWKSource.class, jwkSource);
        OAuth2AuthorizationServerConfiguration.applyDefaultSecurity((HttpSecurity)http);
        ((OAuth2AuthorizationServerConfigurer)http.getConfigurer(OAuth2AuthorizationServerConfigurer.class)).oidc(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$1(rememberMeServices, systemDomainPrefix, arg_0)).clientAuthentication(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$2(registeredClientRepository, arg_0)).authorizationEndpoint(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$3(trustedDeviceAuthenticationHandler, arg_0)).tokenEndpoint(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$4(justAuthenticationProvider, authorizationService, justTokenGenerator, arg_0)).tokenGenerator(justTokenGenerator);
        http.exceptionHandling(SecurityConfig::authorizationServerSecurityFilterChain$lambda$5).oauth2ResourceServer(SecurityConfig::authorizationServerSecurityFilterChain$lambda$6).sessionManagement(SecurityConfig::authorizationServerSecurityFilterChain$lambda$7).exceptionHandling(SecurityConfig::authorizationServerSecurityFilterChain$lambda$8);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @Order(value=2)
    @NotNull
    public SecurityFilterChain defaultSecurityFilterChain(@NotNull HttpSecurity http, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix, @NotNull TOTPAwareRememberMeService rememberMeServices, @NotNull JwtVerifier jwtVerifier, @NotNull TOTPAuthenticationService totpAuthenticationService, @NotNull TOTPAuthenticationSuccessHandler totpAuthenticationSuccessHandler) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationService, (String)"totpAuthenticationService");
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationSuccessHandler, (String)"totpAuthenticationSuccessHandler");
        AuthenticationManager authenticationManager = this.authManager(http);
        http.authorizeHttpRequests(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$9(this, arg_0)).formLogin(SecurityConfig::defaultSecurityFilterChain$lambda$10).authenticationManager(authenticationManager).csrf(SecurityConfig::defaultSecurityFilterChain$lambda$11).sessionManagement(SecurityConfig::defaultSecurityFilterChain$lambda$12).rememberMe(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$13(rememberMeServices, arg_0)).addFilterAfter((Filter)new JwtFilter(jwtVerifier, systemDomainPrefix).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)new AntPathRequestMatcher("/login")), AbstractPreAuthenticatedProcessingFilter.class).addFilterAt((Filter)new TOTPAwareUsernamePasswordAuthenticationFilter(totpAuthenticationService, authenticationManager, totpAuthenticationSuccessHandler, rememberMeServices), UsernamePasswordAuthenticationFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public AuthorizationManager<RequestAuthorizationContext> mfaAuthenticated() {
        return SecurityConfig::mfaAuthenticated$lambda$14;
    }

    @Bean
    @NotNull
    public TOTPAwareRememberMeService rememberMeServices(@NotNull RememberMeTokenRepository rememberMeTokenRepository, @NotNull JustUserDetailService userDetailService) {
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        Intrinsics.checkNotNullParameter((Object)userDetailService, (String)"userDetailService");
        TOTPAwareRememberMeService service = new TOTPAwareRememberMeService("just", userDetailService, rememberMeTokenRepository);
        service.setCookieName("remember");
        service.setParameter("remember");
        service.setUseSecureCookie(true);
        service.setTokenValiditySeconds(2592000);
        return service;
    }

    @RefreshScope
    @Bean
    @NotNull
    public OAuth2TokenGenerator<? extends OAuth2Token> justTokenGenerator(@NotNull JWKSource<SecurityContext> jwkSource) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        JwtGenerator jwtGenerator = new JwtGenerator((JwtEncoder)new NimbusJwtEncoder(jwkSource));
        OAuth2TokenCustomizer customizer = SecurityConfig::justTokenGenerator$lambda$15;
        jwtGenerator.setJwtCustomizer(customizer);
        OAuth2AccessTokenGenerator accessTokenGenerator = new OAuth2AccessTokenGenerator();
        accessTokenGenerator.setAccessTokenCustomizer(SecurityConfig::justTokenGenerator$lambda$16);
        OAuth2RefreshTokenGenerator refreshTokenGenerator = new OAuth2RefreshTokenGenerator();
        MobileOauth2RefreshTokenGenerator mobileRefreshTokenGenerator = new MobileOauth2RefreshTokenGenerator();
        OAuth2TokenGenerator[] oAuth2TokenGeneratorArray = new OAuth2TokenGenerator[]{jwtGenerator, accessTokenGenerator, refreshTokenGenerator, mobileRefreshTokenGenerator};
        return (OAuth2TokenGenerator)new DelegatingOAuth2TokenGenerator(oAuth2TokenGeneratorArray);
    }

    @Bean(value={"registeredClientRepository"})
    @NotNull
    public RegisteredClientRepository registeredClientRepository(@NotNull DataSource dataSource, @NotNull JustOauthClients justAuthClients) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)justAuthClients, (String)"justAuthClients");
        ExposedRegisteredClientRepository repository = new ExposedRegisteredClientRepository();
        Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, null, null, null, (int)30, null);
        ThreadLocalTransactionManagerKt.transaction$default(null, arg_0 -> SecurityConfig.registeredClientRepository$lambda$17(repository, justAuthClients, arg_0), (int)1, null);
        return (RegisteredClientRepository)repository;
    }

    @RefreshScope
    @Bean
    @NotNull
    public JwtDecoder jwtDecoder(@NotNull JWKSource<SecurityContext> jwkSource) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        JwtDecoder jwtDecoder = OAuth2AuthorizationServerConfiguration.jwtDecoder(jwkSource);
        Intrinsics.checkNotNullExpressionValue((Object)jwtDecoder, (String)"jwtDecoder(...)");
        return jwtDecoder;
    }

    @Bean
    @NotNull
    public AuthorizationServerSettings authorizationServerSettings() {
        AuthorizationServerSettings authorizationServerSettings = AuthorizationServerSettings.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationServerSettings, (String)"build(...)");
        return authorizationServerSettings;
    }

    @Bean
    @NotNull
    public PasswordEncoder passwordEncoder() {
        String defaultEncoding = "bcrypt";
        Map encoders = new HashMap();
        encoders.put(defaultEncoding, new BCryptPasswordEncoder(BCryptPasswordEncoder.BCryptVersion.$2B, 12));
        return (PasswordEncoder)new DelegatingPasswordEncoder(defaultEncoding, encoders);
    }

    private static final void authorizationServerSecurityFilterChain$lambda$1$lambda$0(TOTPAwareRememberMeService $rememberMeServices, String $systemDomainPrefix, OidcLogoutEndpointConfigurer l) {
        l.logoutResponseHandler((AuthenticationSuccessHandler)new LogoutSuccessHandler((PersistentTokenBasedRememberMeServices)$rememberMeServices, $systemDomainPrefix));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$1(TOTPAwareRememberMeService $rememberMeServices, String $systemDomainPrefix, OidcConfigurer oidc) {
        oidc.logoutEndpoint(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$1$lambda$0($rememberMeServices, $systemDomainPrefix, arg_0));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$2(RegisteredClientRepository $registeredClientRepository, OAuth2ClientAuthenticationConfigurer clientAuthentication) {
        clientAuthentication.authenticationConverter((AuthenticationConverter)new MobileClientRefreshTokenAuthenticationConverter()).authenticationProvider((AuthenticationProvider)new MobileClientRefreshTokenAuthenticationProvider($registeredClientRepository));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$3(TrustedDeviceAuthenticationHandler $trustedDeviceAuthenticationHandler, OAuth2AuthorizationEndpointConfigurer it) {
        it.authorizationResponseHandler((AuthenticationSuccessHandler)new InvalidateSessionAndAddTrustedDeviceAndRedirectHandler($trustedDeviceAuthenticationHandler));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$4(JustAuthenticationProvider $justAuthenticationProvider, Oauth2AuthorizationService $authorizationService, OAuth2TokenGenerator $justTokenGenerator, OAuth2TokenEndpointConfigurer it) {
        it.accessTokenRequestConverter((AuthenticationConverter)new OAuth2PasswordGrantAuthenticationConverter()).authenticationProvider((AuthenticationProvider)new OAuth2PasswordGrantAuthenticationProvider($justAuthenticationProvider, (OAuth2AuthorizationService)$authorizationService, $justTokenGenerator));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$5(ExceptionHandlingConfigurer exceptions) {
        Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_HTML};
        exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/login"), (RequestMatcher)new MediaTypeRequestMatcher(mediaTypeArray));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$6(OAuth2ResourceServerConfigurer resourceServer) {
        Intrinsics.checkNotNullParameter((Object)resourceServer, (String)"resourceServer");
        resourceServer.jwt(Customizer.withDefaults());
    }

    private static final void authorizationServerSecurityFilterChain$lambda$7(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.NEVER);
    }

    private static final void authorizationServerSecurityFilterChain$lambda$8(ExceptionHandlingConfigurer it) {
        it.accessDeniedHandler((AccessDeniedHandler)new TotpAwareAccessDeniedHandler());
    }

    private static final void defaultSecurityFilterChain$lambda$9(SecurityConfig this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        String[] stringArray = UNAUTHORIZED_PATHS;
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(Arrays.copyOf(stringArray, stringArray.length))).permitAll();
        stringArray = new String[]{"/totp/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).access(this$0.mfaAuthenticated());
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    private static final void defaultSecurityFilterChain$lambda$10(FormLoginConfigurer formLogin) {
        formLogin.loginPage("/login").permitAll();
    }

    private static final void defaultSecurityFilterChain$lambda$11(CsrfConfigurer csrf) {
        String[] stringArray = UNAUTHORIZED_PATHS;
        csrf.ignoringRequestMatchers(Arrays.copyOf(stringArray, stringArray.length));
    }

    private static final void defaultSecurityFilterChain$lambda$12(SessionManagementConfigurer session) {
        session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
    }

    private static final void defaultSecurityFilterChain$lambda$13(TOTPAwareRememberMeService $rememberMeServices, RememberMeConfigurer remember) {
        remember.rememberMeServices((RememberMeServices)$rememberMeServices).authenticationSuccessHandler((AuthenticationSuccessHandler)new SavedRequestAwareAuthenticationSuccessHandler());
    }

    private static final AuthorizationDecision mfaAuthenticated$lambda$14(Supplier authentication, RequestAuthorizationContext context) {
        return new AuthorizationDecision(authentication.get() instanceof TOTPAuthentication);
    }

    private static final void justTokenGenerator$lambda$15(JwtEncodingContext it) {
        Object principal = ((AbstractAuthenticationToken)it.getPrincipal()).getPrincipal();
        if (principal instanceof JustUser) {
            if (((JustUser)principal).getTenantId() != null) {
                it.getClaims().claim(TenantId.Companion.getJsonKey(), (Object)((JustUser)principal).getTenantId().toTypedString());
            }
            it.getClaims().claim(ProfileId.Companion.getJsonKey(), (Object)((JustUser)principal).getProfileId().toTypedString());
        }
    }

    private static final void justTokenGenerator$lambda$16(OAuth2TokenClaimsContext it) {
        Object principal = it.getPrincipal().getPrincipal();
        if (principal instanceof JustUser) {
            if (((JustUser)principal).getTenantId() != null) {
                it.getClaims().claim(TenantId.Companion.getJsonKey(), (Object)((JustUser)principal).getTenantId().toTypedString());
            }
            it.getClaims().claim(ProfileId.Companion.getJsonKey(), (Object)((JustUser)principal).getProfileId().toTypedString());
        } else if (principal instanceof String) {
            RegisteredClient client;
            RegisteredClient registeredClient = client = (RegisteredClient)it.get(RegisteredClient.class);
            if ((registeredClient != null ? ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)registeredClient) : null) != null) {
                TenantId tenantId = ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)client);
                it.getClaims().claim(TenantId.Companion.getJsonKey(), (Object)(tenantId != null ? tenantId.toTypedString() : null));
            }
        }
    }

    private static final Unit registeredClientRepository$lambda$17(ExposedRegisteredClientRepository $repository, JustOauthClients $justAuthClients, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        RegisteredClient registeredClient = $repository.findByClientId("just-login-mobile");
        $repository.save($justAuthClients.toroMobileLoginClient(registeredClient != null ? registeredClient.getId() : null));
        RegisteredClient registeredClient2 = $repository.findByClientId("just-login");
        $repository.save($justAuthClients.toroJustLoginClient(registeredClient2 != null ? registeredClient2.getId() : null));
        RegisteredClient registeredClient3 = $repository.findByClientId($justAuthClients.getIntrospectionClientId());
        $repository.save($justAuthClients.gatewayIntrospectionClient(registeredClient3 != null ? registeredClient3.getId() : null));
        RegisteredClient registeredClient4 = $repository.findByClientId("swagger");
        $repository.save($justAuthClients.swaggerClient(registeredClient4 != null ? registeredClient4.getId() : null));
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"/oauth2/token/**", "/internal/**", "/error", "/images/**", "/account/**", "/registration/**", "/about/**"};
        UNAUTHORIZED_PATHS = stringArray;
    }
}

