/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.toro;

import de.justsoftware.admin.connector.toro.ScimFieldMapping;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J4\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/admin/connector/toro/ToroConnector;", "", "toroInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "internalApiAuthInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/http/client/ClientHttpRequestInterceptor;)V", "authorizedRestClient", "Lorg/springframework/web/client/RestClient;", "deleteAppHomeScreenPositionsOfUsers", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "getFieldMapping", "Lde/justsoftware/admin/connector/toro/ScimFieldMapping;", "createFieldMapping", "mapping", "", "", "profileId", "Lde/justsoftware/admin/id/ProfileId;", "admin-service"})
public class ToroConnector {
    @NotNull
    private final RestClient authorizedRestClient;

    public ToroConnector(@Value(value="${just.toro.internal.host.url}") @NotNull String toroInternalUrl, @NotNull RestClient.Builder restClientBuilder, @NotNull ClientHttpRequestInterceptor internalApiAuthInterceptor) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)internalApiAuthInterceptor, (String)"internalApiAuthInterceptor");
        RestClient restClient = restClientBuilder.baseUrl(toroInternalUrl).requestInterceptor(internalApiAuthInterceptor).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.authorizedRestClient = restClient;
    }

    public boolean deleteAppHomeScreenPositionsOfUsers(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.authorizedRestClient.delete().uri("/home-screen-app-positions/" + tenantId, new Object[0]).retrieve().toBodilessEntity().getStatusCode() == HttpStatus.OK;
    }

    @Nullable
    public ScimFieldMapping getFieldMapping(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (ScimFieldMapping)this.authorizedRestClient.get().uri(arg_0 -> ToroConnector.getFieldMapping$lambda$0(tenantId, arg_0)).retrieve().toEntity(ScimFieldMapping.class).getBody();
    }

    @Nullable
    public ScimFieldMapping createFieldMapping(@NotNull Map<String, ? extends Set<String>> mapping, @NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return (ScimFieldMapping)((RestClient.RequestBodySpec)this.authorizedRestClient.post().uri(arg_0 -> ToroConnector.createFieldMapping$lambda$1(tenantId, profileId, arg_0))).contentType(MediaType.APPLICATION_JSON).body(mapping).retrieve().toEntity(ScimFieldMapping.class).getBody();
    }

    private static final URI getFieldMapping$lambda$0(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/profile/scim/fieldmapping").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI createFieldMapping$lambda$1(TenantId $tenantId, ProfileId $profileId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        UriBuilder uriBuilder = it.path("/profile/scim/fieldmapping").queryParam("tenantId", objectArray);
        objectArray = new Object[]{$profileId.toTypedString()};
        return uriBuilder.queryParam("createdBy", objectArray).build(new Object[0]);
    }
}

