/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.search;

import de.justsoftware.search.shared.model.SearchType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/admin/connector/search/SearchApiConnector;", "", "searchInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "internalApiAuthInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/http/client/ClientHttpRequestInterceptor;)V", "authorizedRestClient", "Lorg/springframework/web/client/RestClient;", "reindexAll", "", "reindex", "searchType", "Lde/justsoftware/search/shared/model/SearchType;", "admin-service"})
public class SearchApiConnector {
    @NotNull
    private final RestClient authorizedRestClient;

    public SearchApiConnector(@Value(value="${just.search-service.internal}") @NotNull String searchInternalUrl, @NotNull RestClient.Builder restClientBuilder, @NotNull ClientHttpRequestInterceptor internalApiAuthInterceptor) {
        Intrinsics.checkNotNullParameter((Object)searchInternalUrl, (String)"searchInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)internalApiAuthInterceptor, (String)"internalApiAuthInterceptor");
        RestClient restClient = restClientBuilder.baseUrl(searchInternalUrl).requestInterceptor(internalApiAuthInterceptor).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.authorizedRestClient = restClient;
    }

    public boolean reindexAll() {
        return ((RestClient.RequestBodySpec)this.authorizedRestClient.post().uri("/reindexAll", new Object[0])).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }

    public boolean reindex(@NotNull SearchType searchType) {
        Intrinsics.checkNotNullParameter((Object)searchType, (String)"searchType");
        return ((RestClient.RequestBodySpec)this.authorizedRestClient.post().uri("/reindex/" + searchType, new Object[0])).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }
}

