/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.content.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteSource;
import com.google.common.io.CountingInputStream;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.content.ContentExtractionException;
import de.justsoftware.drive.content.ContentExtractionService;
import de.justsoftware.drive.content.impl.Check;
import de.justsoftware.drive.content.impl.CheckedContenHandler;
import de.justsoftware.drive.content.impl.CheckedInputStream;
import de.justsoftware.drive.content.impl.CheckedParseContext;
import de.justsoftware.drive.content.impl.CheckedParser;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Service
@ParametersAreNonnullByDefault
public class ContentExtractionServiceImpl
implements ContentExtractionService {
    private static final int CACHE_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(ContentExtractionServiceImpl.class);
    private static final Resource TIKA_CONFIG_RESOURCE = new ClassPathResource("tika-config.xml");
    private final FileStorageDAO _fileStorageDAO;
    private final int _maxStringLength;
    private final long _timeoutMs;
    private final long _maxInputLength;
    private final Cache<StorageId, String> _cache = CacheBuilder.newBuilder().maximumSize(100L).build();

    @Autowired
    public ContentExtractionServiceImpl(FileStorageDAO fileStorageDAO, @Value(value="${just.drive.contextExtractor.maxIndexedContentLength:500000}") int maxStringLength, @Value(value="${just.drive.contextExtractor.timeoutMs:25000}") long timeoutMs, @Value(value="${just.drive.contextExtractor.maxInputLength:50000000}") long maxInputLength) {
        this._fileStorageDAO = fileStorageDAO;
        this._timeoutMs = timeoutMs;
        this._maxInputLength = maxInputLength;
        this._maxStringLength = Math.max(maxStringLength, -1);
    }

    public String parse(StorageId storageId) throws ContentExtractionException {
        String cachedResult = (String)this._cache.getIfPresent((Object)storageId);
        if (cachedResult != null) {
            LOG.warn("cache hit for {} returning {} bytes", (Object)storageId, (Object)cachedResult.length());
            return cachedResult;
        }
        long end = System.currentTimeMillis() + this._timeoutMs;
        Check & Serializable timeoutCheck = (Check & Serializable)() -> System.currentTimeMillis() < end;
        return this.parse(this._fileStorageDAO.load(storageId), this._maxInputLength, storageId, (Check)timeoutCheck);
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    private String parse(ByteSource source, long maxInputLength, StorageId storageId, Check timeoutCheck) throws ContentExtractionException {
        String string;
        block16: {
            ByteSource contentSource = source.slice(0L, maxInputLength);
            WriteOutContentHandler writeOutHandler = new WriteOutContentHandler(this._maxStringLength);
            CountingInputStream countingStream = null;
            InputStream contentStream = contentSource.openBufferedStream();
            try {
                String result;
                countingStream = new CountingInputStream((InputStream)new CheckedInputStream(contentStream, timeoutCheck));
                CheckedParser parser = new CheckedParser((Parser)new AutoDetectParser(new TikaConfig(TIKA_CONFIG_RESOURCE.getInputStream())), timeoutCheck);
                CheckedParseContext context = new CheckedParseContext(timeoutCheck);
                context.set(Parser.class, (Object)parser);
                parser.parse((InputStream)countingStream, (ContentHandler)new CheckedContenHandler((ContentHandler)new BodyContentHandler((ContentHandler)writeOutHandler), timeoutCheck), new Metadata(), (ParseContext)context);
                string = result = writeOutHandler.toString();
                if (contentStream == null) break block16;
            }
            catch (Throwable parser) {
                try {
                    if (contentStream != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable context) {
                            parser.addSuppressed(context);
                        }
                    }
                    throw parser;
                }
                catch (IOException | RuntimeException | TikaException | SAXException e) {
                    String result = writeOutHandler.toString();
                    Integer len = result.length();
                    if (e instanceof WriteLimitReachedException) {
                        LOG.debug("output limit reached during content extraction of {}", (Object)storageId);
                    } else if (!timeoutCheck.isOk()) {
                        this._cache.put((Object)storageId, (Object)result);
                        LOG.warn("timeout during content extraction of {}, {} bytes extracted", (Object)storageId, (Object)len);
                    } else if (countingStream != null && countingStream.getCount() >= maxInputLength) {
                        LOG.debug("too large file during content extraction of {}, {} bytes extracted", (Object)storageId, (Object)len);
                    } else {
                        throw new ContentExtractionException(storageId, e);
                    }
                    return result;
                }
                catch (OutOfMemoryError oom) {
                    LOG.warn("out of memory caught, trying to recover file " + String.valueOf(storageId), (Throwable)oom);
                    long newLimit = maxInputLength / 10L;
                    if (newLimit >= (long)this._maxStringLength) {
                        return this.parse(source, newLimit, storageId, timeoutCheck);
                    }
                    throw oom;
                }
            }
            contentStream.close();
        }
        return string;
    }

    public boolean isStorageAvailable() {
        return this._fileStorageDAO.isAvailable();
    }
}

