/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.kafka;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.kafka.KafkaTopicConfiguration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.admin.NewTopic;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"!test"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0006\u001a\u00020\u0005H\u0017J\b\u0010\u0007\u001a\u00020\u0005H\u0017J\b\u0010\b\u001a\u00020\u0005H\u0017J\b\u0010\t\u001a\u00020\u0005H\u0017J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/people/kafka/KafkaTopicConfiguration;", "", "<init>", "()V", "userGroupImportTopic", "Lorg/apache/kafka/clients/admin/NewTopic;", "userGroupMembersImportTopic", "searchIndexTopic", "userGroupTopic", "userGroupMembersTopic", "defaultTopicFactory", "name", "", "partitions", "", "Companion", "people-api"})
public class KafkaTopicConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SEVEN_DAYS_IN_MS = "604800000";

    @Bean
    @NotNull
    public NewTopic userGroupImportTopic() {
        return this.defaultTopicFactory("just.people.import.userGroup", 1);
    }

    @Bean
    @NotNull
    public NewTopic userGroupMembersImportTopic() {
        return this.defaultTopicFactory("just.people.import.userGroupMembers", 1);
    }

    @Bean
    @NotNull
    public NewTopic searchIndexTopic() {
        NewTopic topic = new NewTopic("just.people.search.index", 1, 1);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS), TuplesKt.to((Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS), TuplesKt.to((Object)"cleanup.policy", (Object)"delete")};
        Map config = MapsKt.mapOf((Pair[])pairArray);
        NewTopic newTopic = topic.configs(config);
        Intrinsics.checkNotNullExpressionValue((Object)newTopic, (String)"configs(...)");
        return newTopic;
    }

    @Bean
    @NotNull
    public NewTopic userGroupTopic() {
        return this.defaultTopicFactory("just.people.userGroup", 5);
    }

    @Bean
    @NotNull
    public NewTopic userGroupMembersTopic() {
        return this.defaultTopicFactory("just.people.userGroupMembers", 5);
    }

    private NewTopic defaultTopicFactory(String name, int partitions) {
        ImmutableMap immutableMap = ImmutableMap.of((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"cleanup.policy", (Object)"compact");
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
        ImmutableMap defaultTopicConfig = immutableMap;
        NewTopic topic = new NewTopic(name, partitions, 1);
        NewTopic newTopic = topic.configs((Map)defaultTopicConfig);
        Intrinsics.checkNotNullExpressionValue((Object)newTopic, (String)"configs(...)");
        return newTopic;
    }
}

