/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.google.common.collect.ImmutableList;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.people.config.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/people/config/WebSecurityConfiguration;", "", "<init>", "()V", "securityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "authenticationProcessingFilter", "Lde/justsoftware/jwtfilter/JwtAuthenticationProcessingFilter;", "Companion", "people-api"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INTERNAL_API = "/internal/**";
    @NotNull
    private static final OrRequestMatcher ALLOW_COOKIE_ONLY_AUTH = new OrRequestMatcher((List)ImmutableList.of((Object)new AntPathRequestMatcher("/api/profiles/export")));
    @NotNull
    private static final String[] SWAGGER_RESOURCES;

    @Bean
    @NotNull
    public SecurityFilterChain securityFilterChain(@NotNull HttpSecurity http, @NotNull JwtAuthenticationProcessingFilter authenticationProcessingFilter) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)authenticationProcessingFilter, (String)"authenticationProcessingFilter");
        authenticationProcessingFilter.applyIgnoreFilterMatcher(arg_0 -> ((AntPathRequestMatcher)new AntPathRequestMatcher(INTERNAL_API)).matches(arg_0)).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)ALLOW_COOKIE_ONLY_AUTH);
        Object object = http.sessionManagement(WebSecurityConfiguration::securityFilterChain$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::securityFilterChain$lambda$1).anonymous(Customizer.withDefaults()).headers(WebSecurityConfiguration::securityFilterChain$lambda$2).authorizeHttpRequests(WebSecurityConfiguration::securityFilterChain$lambda$3).addFilterAfter((Filter)authenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void securityFilterChain$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void securityFilterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void securityFilterChain$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void securityFilterChain$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)SWAGGER_RESOURCES);
        spreadBuilder.add((Object)INTERNAL_API);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]))).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    static {
        String[] stringArray = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        SWAGGER_RESOURCES = stringArray;
    }
}

