/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.kafka;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.notificationclient.model.ArchiveAllNotificationsInstruction;
import de.justsoftware.notificationclient.model.CreateNotificationInstruction;
import de.justsoftware.notificationclient.model.DeleteAllNotificationsInstruction;
import de.justsoftware.notificationclient.model.Instruction;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationservice.business.MobilePushNotificationService;
import de.justsoftware.notificationservice.business.NotificationService;
import de.justsoftware.notificationservice.kafka.InstructionKafkaConsumer;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.UserGroupMemberRepository;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.DbNotification;
import de.justsoftware.notificationservice.persistence.model.DbUserGroupMember;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.persistence.model.UserGroupId;
import de.justsoftware.notificationservice.util.KafkaUtilsKt;
import jakarta.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J\u001c\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0017J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0013J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0012J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0012J\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0012J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/notificationservice/kafka/InstructionKafkaConsumer;", "", "mobilePushNotificationService", "Lde/justsoftware/notificationservice/business/MobilePushNotificationService;", "notificationRepository", "Lde/justsoftware/notificationservice/persistence/NotificationRepository;", "userGroupMemberRepository", "Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;", "deliveryStatusRepository", "Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "notificationService", "Lde/justsoftware/notificationservice/business/NotificationService;", "(Lde/justsoftware/notificationservice/business/MobilePushNotificationService;Lde/justsoftware/notificationservice/persistence/NotificationRepository;Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;Lde/justsoftware/notificationservice/business/NotificationService;)V", "createNotification", "", "notification", "Lde/justsoftware/notificationclient/model/Notification;", "listen", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/notificationclient/model/Instruction;", "resolveReceivers", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "saveDeliveryStatus", "dbNotification", "Lde/justsoftware/notificationservice/persistence/model/DbNotification;", "resolvedReceivers", "saveNotification", "", "sendMobilePush", "resolveToProfileIds", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nNotificationKafkaConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationKafkaConsumer.kt\nde/justsoftware/notificationservice/kafka/InstructionKafkaConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,185:1\n766#2:186\n857#2,2:187\n1549#2:189\n1620#2,3:190\n766#2:193\n857#2,2:194\n1549#2:196\n1620#2,3:197\n1360#2:200\n1446#2,5:201\n1549#2:206\n1620#2,3:207\n1549#2:210\n1620#2,3:211\n1855#2,2:214\n8#3:216\n7#3,3:217\n*S KotlinDebug\n*F\n+ 1 NotificationKafkaConsumer.kt\nde/justsoftware/notificationservice/kafka/InstructionKafkaConsumer\n*L\n153#1:186\n153#1:187,2\n154#1:189\n154#1:190,3\n156#1:193\n156#1:194,2\n157#1:196\n157#1:197,3\n158#1:200\n158#1:201,5\n159#1:206\n159#1:207,3\n167#1:210\n167#1:211,3\n171#1:214,2\n182#1:216\n182#1:217,3\n*E\n"})
public class InstructionKafkaConsumer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MobilePushNotificationService mobilePushNotificationService;
    @NotNull
    private final NotificationRepository notificationRepository;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final DeliveryStatusRepository deliveryStatusRepository;
    @NotNull
    private final NotificationService notificationService;
    @NotNull
    private static final Logger LOG;

    public InstructionKafkaConsumer(@NotNull MobilePushNotificationService mobilePushNotificationService, @NotNull NotificationRepository notificationRepository, @NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull DeliveryStatusRepository deliveryStatusRepository, @NotNull NotificationService notificationService) {
        Intrinsics.checkNotNullParameter((Object)mobilePushNotificationService, (String)"mobilePushNotificationService");
        Intrinsics.checkNotNullParameter((Object)notificationRepository, (String)"notificationRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)deliveryStatusRepository, (String)"deliveryStatusRepository");
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        this.mobilePushNotificationService = mobilePushNotificationService;
        this.notificationRepository = notificationRepository;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.deliveryStatusRepository = deliveryStatusRepository;
        this.notificationService = notificationService;
    }

    @KafkaListener(id="instructionConsumer", containerFactory="instructionListenerContainerFactory", topics={"just.notification.dispatch"})
    public void listen(@NotNull ConsumerRecords<String, Instruction> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        for (ConsumerRecord record : KafkaUtilsKt.filterAndLogDeserializationErrors(records)) {
            try {
                Instruction instruction = (Instruction)record.value();
                if (instruction instanceof CreateNotificationInstruction) {
                    Notification notification = ((CreateNotificationInstruction)instruction).getNotification();
                    Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"getNotification(...)");
                    this.createNotification(notification);
                    continue;
                }
                if (instruction instanceof ArchiveAllNotificationsInstruction) {
                    String string = ((ArchiveAllNotificationsInstruction)instruction).getTargetId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTargetId(...)");
                    Set set = ((ArchiveAllNotificationsInstruction)instruction).getNotificationTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getNotificationTypes(...)");
                    this.notificationService.archiveAllNotificationsForTargetAndReceiver(string, set, new ProfileId(((ArchiveAllNotificationsInstruction)instruction).getReceiver()));
                    continue;
                }
                if (!(instruction instanceof DeleteAllNotificationsInstruction)) continue;
                String string = ((DeleteAllNotificationsInstruction)instruction).getTargetId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTargetId(...)");
                this.notificationService.deleteForTarget(string);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to process Notification record with {} = {}", record.key(), record.value());
            }
        }
    }

    private void createNotification(Notification notification) {
        long start = System.currentTimeMillis();
        LOG.debug("Process notification: {}", (Object)notification);
        if (this.notificationRepository.existsById((Object)notification.getId())) {
            LOG.warn("Notification with id: {} already exists. Notification will be skipped.", (Object)notification.getId());
            return;
        }
        Set resolvedReceivers = this.resolveReceivers(notification);
        if (resolvedReceivers.isEmpty()) {
            LOG.debug("Skip notification {} as there are no receivers, e.g. an empty user group is the sole receiver", (Object)notification.getId());
            return;
        }
        boolean notificationSaved = this.saveNotification(notification, resolvedReceivers);
        if (!notificationSaved) {
            return;
        }
        if (Intrinsics.areEqual((Object)notification.isWithoutPush(), (Object)true)) {
            LOG.debug("Skip sending push for notification {}", (Object)notification.getId());
            LOG.info("Processing notification with key {} took {} ms", (Object)notification.getId(), (Object)(System.currentTimeMillis() - start));
            return;
        }
        this.sendMobilePush(notification, resolvedReceivers);
        LOG.info("Processing notification with key {} took {} ms", (Object)notification.getId(), (Object)(System.currentTimeMillis() - start));
    }

    private boolean saveNotification(Notification notification, Set<? extends ProfileId> resolvedReceivers) {
        DbNotification dbNotification;
        DbNotification dbNotification2 = new DbNotification(notification.getId(), notification.getTenantId(), notification.getAppId(), notification.getDefaultTitle(), notification.getDefaultText(), notification.getType(), notification.getTimestamp());
        dbNotification2.setLocalizedTitle((Map)notification.getLocalizedTitle());
        dbNotification2.setLocalizedText((Map)notification.getLocalizedText());
        dbNotification2.setDefaultSecondaryText(notification.getDefaultSecondaryText());
        dbNotification2.setLocalizedSecondaryText((Map)notification.getLocalizedSecondaryText());
        dbNotification2.setMailAuthorName(notification.getMailAuthorName());
        dbNotification2.setDefaultMailContainerName(notification.getDefaultMailContainerName());
        dbNotification2.setLocalizedMailContainerName((Map)notification.getLocalizedMailContainerName());
        dbNotification2.setDefaultMailReplacementText(notification.getDefaultMailReplacementText());
        dbNotification2.setLocalizedMailReplacementText((Map)notification.getLocalizedMailReplacementText());
        dbNotification2.setTargetId(notification.getTargetId());
        dbNotification2.setPayload(notification.getPayload());
        try {
            dbNotification = (DbNotification)this.notificationRepository.saveAndFlush((Object)dbNotification2);
        }
        catch (ValidationException e) {
            LOG.warn("Failed to save Notification with id: " + notification.getId() + ". Notification will be skipped. Root cause is: {}", (Object)e.getMessage());
            return false;
        }
        catch (DataIntegrityViolationException e) {
            LOG.warn("Failed to save Notification with id: " + notification.getId() + ". Notification will be skipped. Root cause is: {}", (Object)e.getMessage());
            return false;
        }
        DbNotification dbNotification3 = dbNotification;
        Intrinsics.checkNotNull((Object)dbNotification3);
        DbNotification savedNotification = dbNotification3;
        try {
            this.saveDeliveryStatus(savedNotification, resolvedReceivers);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to save DeliveryStatus for notification " + notification.getId(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Nonnull
    private Set<ProfileId> resolveReceivers(Notification notification) {
        ImmutableSet immutableSet = notification.getReceivers();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"getReceivers(...)");
        Set receivers = this.resolveToProfileIds((Set)immutableSet);
        ImmutableSet immutableSet2 = notification.getExcludedReceivers();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet2, (String)"getExcludedReceivers(...)");
        Set excludedReceivers = this.resolveToProfileIds((Set)immutableSet2);
        return SetsKt.minus((Set)receivers, (Iterable)excludedReceivers);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> resolveToProfileIds(Set<String> $this$resolveToProfileIds) {
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        String receiver;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2 = $this$resolveToProfileIds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            receiver = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)receiver, (String)"PROFILE,", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void idString;
            receiver = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId((String)idString));
        }
        List directReceivers = (List)destination$iv$iv;
        Iterable $i$f$map22 = $this$resolveToProfileIds;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String receiver2 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)receiver2, (String)"USER_GROUP,", (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void groupIdString;
            String receiver2 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new UserGroupId((String)groupIdString).getId());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            UUID groupId = (UUID)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.userGroupMemberRepository.findAllByGroupId(groupId);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void groupMember;
            DbUserGroupMember list$iv$iv = (DbUserGroupMember)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Long l = groupMember.getProfileId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getProfileId(...)");
            collection.add(new ProfileId(((Number)l).longValue()));
        }
        List groupReceivers = (List)destination$iv$iv2;
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)directReceivers, (Iterable)groupReceivers));
    }

    /*
     * WARNING - void declaration
     */
    private void saveDeliveryStatus(DbNotification dbNotification, Set<? extends ProfileId> resolvedReceivers) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = resolvedReceivers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void receiverId;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DbDeliveryStatus(dbNotification.getId(), receiverId.toString(), NotificationStatus.OPEN));
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        DeliveryStatusRepository deliveryStatusRepository = this.deliveryStatusRepository;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            deliveryStatusRepository.saveAllAndFlush(p0);
        }
    }

    private void sendMobilePush(Notification notification, Set<? extends ProfileId> resolvedReceivers) {
        try {
            this.mobilePushNotificationService.sendPushNotifications(notification, resolvedReceivers);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to send mobile push notifications.", (Throwable)e);
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

