/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import de.justsoftware.notificationservice.business.NotificationCleanupService;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/justsoftware/notificationservice/business/NotificationCleanupService;", "", "notificationRepository", "Lde/justsoftware/notificationservice/persistence/NotificationRepository;", "(Lde/justsoftware/notificationservice/persistence/NotificationRepository;)V", "cleanUpNotificationsWithoutDeliveryStatus", "", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nNotificationCleanupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationCleanupService.kt\nde/justsoftware/notificationservice/business/NotificationCleanupService\n+ 2 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,33:1\n8#2:34\n7#2,3:35\n*S KotlinDebug\n*F\n+ 1 NotificationCleanupService.kt\nde/justsoftware/notificationservice/business/NotificationCleanupService\n*L\n30#1:34\n30#1:35,3\n*E\n"})
public class NotificationCleanupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final NotificationRepository notificationRepository;
    @NotNull
    private static final Logger LOG;

    public NotificationCleanupService(@NotNull NotificationRepository notificationRepository) {
        Intrinsics.checkNotNullParameter((Object)notificationRepository, (String)"notificationRepository");
        this.notificationRepository = notificationRepository;
    }

    @Scheduled(fixedRate=24L, initialDelay=1L, timeUnit=TimeUnit.HOURS)
    @Transactional
    public void cleanUpNotificationsWithoutDeliveryStatus() {
        LOG.info("Deleting all notifications without delivery status...");
        int deleted = this.notificationRepository.deleteAllWithoutAnyDeliveryStatus();
        LOG.info("Deleted " + deleted + " notification(s) without delivery status.");
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

