/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import de.justsoftware.notificationservice.business.MobilePushTokenService;
import de.justsoftware.notificationservice.model.MobilePlatform;
import de.justsoftware.notificationservice.model.MobilePushToken;
import de.justsoftware.notificationservice.model.Profile;
import de.justsoftware.notificationservice.model.event.ProfileUpdateEvent;
import de.justsoftware.notificationservice.persistence.MobilePushTokenRepository;
import de.justsoftware.notificationservice.persistence.model.DbMobilePushToken;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.util.CollectionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0012JD\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0012J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0017JF\u0010(\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$H\u0016J \u0010)\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0015H\u0016J\f\u0010*\u001a\u00020+*\u00020\u000bH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/justsoftware/notificationservice/business/MobilePushTokenService;", "", "mobilePushTokenRepository", "Lde/justsoftware/notificationservice/persistence/MobilePushTokenRepository;", "auditingHandler", "Lorg/springframework/data/auditing/AuditingHandler;", "(Lde/justsoftware/notificationservice/persistence/MobilePushTokenRepository;Lorg/springframework/data/auditing/AuditingHandler;)V", "deletePushTokens", "", "ids", "", "Lde/justsoftware/notificationservice/model/MobilePushToken$Id;", "findAll", "Lorg/springframework/data/domain/Slice;", "Lde/justsoftware/notificationservice/model/MobilePushToken;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByProfileIds", "", "profileIds", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "findByTokenAndPlatform", "Ljava/util/Optional;", "Lde/justsoftware/notificationservice/persistence/model/DbMobilePushToken;", "token", "", "mobilePlatform", "Lde/justsoftware/notificationservice/model/MobilePlatform;", "findOrCreate", "mobilePlatformVersion", "publicKey", "profileId", "locale", "Ljava/util/Locale;", "iosSilenceAlerts", "", "onProfileUpdates", "event", "Lde/justsoftware/notificationservice/model/event/ProfileUpdateEvent;", "registerPushToken", "unregisterPushToken", "toDbId", "Lde/justsoftware/notificationservice/persistence/model/DbMobilePushToken$Id;", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/notificationservice/business/MobilePushTokenService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtil.kt\nde/justsoftware/notificationservice/util/CollectionUtilKt\n*L\n1#1,128:1\n1#2:129\n1549#3:130\n1620#3,3:131\n1360#3:134\n1446#3,5:135\n1549#3:140\n1620#3,3:141\n1620#3,3:145\n17#4:144\n*S KotlinDebug\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/notificationservice/business/MobilePushTokenService\n*L\n66#1:130\n66#1:131,3\n68#1:134\n68#1:135,5\n69#1:140\n69#1:141,3\n74#1:145,3\n74#1:144\n*E\n"})
public class MobilePushTokenService {
    @NotNull
    private final MobilePushTokenRepository mobilePushTokenRepository;
    @NotNull
    private final AuditingHandler auditingHandler;

    public MobilePushTokenService(@NotNull MobilePushTokenRepository mobilePushTokenRepository, @NotNull AuditingHandler auditingHandler) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenRepository, (String)"mobilePushTokenRepository");
        Intrinsics.checkNotNullParameter((Object)auditingHandler, (String)"auditingHandler");
        this.mobilePushTokenRepository = mobilePushTokenRepository;
        this.auditingHandler = auditingHandler;
    }

    @NotNull
    public MobilePushToken registerPushToken(@NotNull String token, @NotNull MobilePlatform mobilePlatform, @Nullable String mobilePlatformVersion, @Nullable String publicKey, @NotNull ProfileId profileId, @NotNull Locale locale, boolean iosSilenceAlerts) {
        DbMobilePushToken p0;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (StringsKt.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token is blank");
        }
        DbMobilePushToken dbMobilePushToken = this.findOrCreate(token, mobilePlatform, mobilePlatformVersion, publicKey, profileId, locale, iosSilenceAlerts);
        AuditingHandler auditingHandler = this.auditingHandler;
        DbMobilePushToken dbMobilePushToken2 = dbMobilePushToken;
        DbMobilePushToken.Companion companion = DbMobilePushToken.Companion;
        boolean bl = false;
        dbMobilePushToken = (DbMobilePushToken)auditingHandler.markModified((Object)p0);
        auditingHandler = this.mobilePushTokenRepository;
        p0 = dbMobilePushToken;
        boolean bl2 = false;
        return companion.toMobilePushToken((DbMobilePushToken)auditingHandler.save((Object)p0));
    }

    public static /* synthetic */ MobilePushToken registerPushToken$default(MobilePushTokenService mobilePushTokenService, String string, MobilePlatform mobilePlatform, String string2, String string3, ProfileId profileId, Locale locale, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerPushToken");
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return mobilePushTokenService.registerPushToken(string, mobilePlatform, string2, string3, profileId, locale, bl);
    }

    public void unregisterPushToken(@NotNull String token, @NotNull MobilePlatform mobilePlatform, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (StringsKt.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token is blank");
        }
        this.findByTokenAndPlatform(token, mobilePlatform).filter(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$1((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).ifPresent(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$2((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<MobilePushToken> findByProfileIds(@NotNull Iterable<? extends ProfileId> profileIds) {
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$map$iv = profileIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        MobilePushTokenRepository $i$f$map22 = this.mobilePushTokenRepository;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable p0 = (Iterable)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findByProfileIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        Iterable $i$f$flatMap22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (DbMobilePushToken)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbMobilePushToken.Companion.toMobilePushToken((DbMobilePushToken)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public void deletePushTokens(@NotNull Collection<MobilePushToken.Id> ids) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return;
        }
        Iterable $this$mapToSet$iv = ids;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushToken.Id id = (MobilePushToken.Id)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toDbId((MobilePushToken.Id)it));
        }
        Set set = (Set)destination$iv$iv;
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        Iterable p0 = set;
        boolean bl = false;
        mobilePushTokenRepository.deleteAllById(p0);
    }

    @NotNull
    public Slice<MobilePushToken> findAll(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Slice slice = this.mobilePushTokenRepository.findAllBy(pageable).map(arg_0 -> MobilePushTokenService.findAll$lambda$8((Function1)findAll.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)slice, (String)"map(...)");
        return slice;
    }

    @EventListener
    @Transactional
    public void onProfileUpdates(@NotNull ProfileUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Profile profile = event.getProfile();
        if (profile.getStatus() != Profile.Status.ACTIVE) {
            this.mobilePushTokenRepository.deleteByProfileId(profile.getId().getId());
        }
    }

    private DbMobilePushToken findOrCreate(String token, MobilePlatform mobilePlatform, String mobilePlatformVersion, String publicKey, ProfileId profileId, Locale locale, boolean iosSilenceAlerts) {
        DbMobilePushToken dbMobilePushToken = this.findByTokenAndPlatform(token, mobilePlatform).map(arg_0 -> MobilePushTokenService.findOrCreate$lambda$9((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).orElseGet(() -> MobilePushTokenService.findOrCreate$lambda$10(token, mobilePlatform, mobilePlatformVersion, publicKey, profileId, locale, iosSilenceAlerts));
        Intrinsics.checkNotNullExpressionValue((Object)dbMobilePushToken, (String)"orElseGet(...)");
        return dbMobilePushToken;
    }

    private Optional<DbMobilePushToken> findByTokenAndPlatform(String token, MobilePlatform mobilePlatform) {
        Optional optional = this.mobilePushTokenRepository.findById((Object)new DbMobilePushToken.Id(token, mobilePlatform));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        return optional;
    }

    private DbMobilePushToken.Id toDbId(MobilePushToken.Id $this$toDbId) {
        return new DbMobilePushToken.Id($this$toDbId.getToken(), $this$toDbId.getMobilePlatform());
    }

    private static final boolean unregisterPushToken$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void unregisterPushToken$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final MobilePushToken findAll$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MobilePushToken)$tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbMobilePushToken)$tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$10(String $token, MobilePlatform $mobilePlatform, String $mobilePlatformVersion, String $publicKey, ProfileId $profileId, Locale $locale, boolean $iosSilenceAlerts) {
        Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
        Intrinsics.checkNotNullParameter((Object)$mobilePlatform, (String)"$mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        Intrinsics.checkNotNullParameter((Object)$locale, (String)"$locale");
        return new DbMobilePushToken($token, $mobilePlatform, $mobilePlatformVersion, $publicKey, $profileId.getId(), $locale, $iosSilenceAlerts);
    }
}

