/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice;

import de.justsoftware.notificationservice.MobilePushConfiguration;
import de.justsoftware.notificationservice.business.CommonConfigProperties;
import de.justsoftware.notificationservice.business.JunoRestClientService;
import de.justsoftware.notificationservice.business.MobilePushNotificationSendService;
import de.justsoftware.notificationservice.business.MobilePushTokenService;
import de.justsoftware.notificationservice.business.ScheduledMobilePushNotificationStore;
import de.justsoftware.notificationservice.util.MobilePushEncryption;
import de.justsoftware.notificationservice.util.MobilePushEncryptionKt;
import io.netty.channel.ChannelOption;
import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.ClientTransport;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\u000f\u001a\u00020\nH\u0017J\"\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\"\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/notificationservice/MobilePushConfiguration;", "", "()V", "apnsPushSendService", "Lde/justsoftware/notificationservice/business/MobilePushNotificationSendService;", "mobilePushTokenService", "Lde/justsoftware/notificationservice/business/MobilePushTokenService;", "junoApnsRestClient", "Lde/justsoftware/notificationservice/business/JunoRestClientService;", "apnsPushTaskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "clock", "Ljava/time/Clock;", "fcmPushSendService", "junoFcmRestClient", "fcmPushTaskScheduler", "junoBasePathApns", "", "junoHttpClient", "Lreactor/netty/http/client/HttpClient;", "commonConfigProperties", "Lde/justsoftware/notificationservice/business/CommonConfigProperties;", "junoBasePathFcm", "mobilePushEncryption", "Lde/justsoftware/notificationservice/util/MobilePushEncryption;", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushConfiguration.kt\nde/justsoftware/notificationservice/MobilePushConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public class MobilePushConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long TIMEOUT_SECONDS = 60L;

    @Bean
    @NotNull
    public Clock clock() {
        Clock clock = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
        return clock;
    }

    @Bean
    @NotNull
    public HttpClient junoHttpClient() {
        ClientTransport clientTransport = ((HttpClient)((HttpClient)HttpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)60000)).responseTimeout(Duration.ofSeconds(60L)).proxyWithSystemProperties()).doOnConnected(arg_0 -> MobilePushConfiguration.junoHttpClient$lambda$0((Function1)junoHttpClient.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"doOnConnected(...)");
        return (HttpClient)clientTransport;
    }

    @Bean
    @NotNull
    public JunoRestClientService junoApnsRestClient(@Value(value="${just.juno.baseurl.apns}") @NotNull String junoBasePathApns, @NotNull HttpClient junoHttpClient2, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathApns, (String)"junoBasePathApns");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient2, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathApns + "/v1", junoHttpClient2, commonConfigProperties);
    }

    @Bean
    @NotNull
    public JunoRestClientService junoFcmRestClient(@Value(value="${just.juno.baseurl.fcm}") @NotNull String junoBasePathFcm, @NotNull HttpClient junoHttpClient2, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathFcm, (String)"junoBasePathFcm");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient2, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathFcm + "/v1", junoHttpClient2, commonConfigProperties);
    }

    @Bean
    @NotNull
    public MobilePushNotificationSendService apnsPushSendService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull JunoRestClientService junoApnsRestClient, @NotNull TaskScheduler apnsPushTaskScheduler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)junoApnsRestClient, (String)"junoApnsRestClient");
        Intrinsics.checkNotNullParameter((Object)apnsPushTaskScheduler, (String)"apnsPushTaskScheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new MobilePushNotificationSendService(mobilePushTokenService, new ScheduledMobilePushNotificationStore(), junoApnsRestClient, apnsPushTaskScheduler, clock);
    }

    @Bean
    @NotNull
    public MobilePushNotificationSendService fcmPushSendService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull JunoRestClientService junoFcmRestClient, @NotNull TaskScheduler fcmPushTaskScheduler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)junoFcmRestClient, (String)"junoFcmRestClient");
        Intrinsics.checkNotNullParameter((Object)fcmPushTaskScheduler, (String)"fcmPushTaskScheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new MobilePushNotificationSendService(mobilePushTokenService, new ScheduledMobilePushNotificationStore(), junoFcmRestClient, fcmPushTaskScheduler, clock);
    }

    @Bean
    @NotNull
    public TaskScheduler apnsPushTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler;
        ThreadPoolTaskScheduler $this$apnsPushTaskScheduler_u24lambda_u241 = threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        boolean bl = false;
        $this$apnsPushTaskScheduler_u24lambda_u241.setPoolSize(1);
        return (TaskScheduler)threadPoolTaskScheduler;
    }

    @Bean
    @NotNull
    public TaskScheduler fcmPushTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler;
        ThreadPoolTaskScheduler $this$fcmPushTaskScheduler_u24lambda_u242 = threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        boolean bl = false;
        $this$fcmPushTaskScheduler_u24lambda_u242.setPoolSize(1);
        return (TaskScheduler)threadPoolTaskScheduler;
    }

    @Bean
    @NotNull
    public MobilePushEncryption mobilePushEncryption() {
        return MobilePushEncryptionKt.getMobilePushEncryption();
    }

    private static final void junoHttpClient$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

