/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Produced;

public final class WordCountDemo {
    public static final String INPUT_TOPIC = "streams-plaintext-input";
    public static final String OUTPUT_TOPIC = "streams-wordcount-output";

    static Properties getStreamsConfig(String[] args) throws IOException {
        Properties props = new Properties();
        if (args != null && args.length > 0) {
            try (FileInputStream fis = new FileInputStream(args[0]);){
                props.load(fis);
            }
            if (args.length > 1) {
                System.out.println("Warning: Some command line arguments were ignored. This demo only accepts an optional configuration file.");
            }
        }
        props.putIfAbsent("application.id", "streams-wordcount");
        props.putIfAbsent("bootstrap.servers", "localhost:9092");
        props.putIfAbsent("statestore.cache.max.bytes", (Object)0);
        props.putIfAbsent("default.key.serde", Serdes.String().getClass().getName());
        props.putIfAbsent("default.value.serde", Serdes.String().getClass().getName());
        props.putIfAbsent("auto.offset.reset", "earliest");
        return props;
    }

    static void createWordCountStream(StreamsBuilder builder) {
        KStream source = builder.stream(INPUT_TOPIC);
        KTable counts = source.flatMapValues(value -> Arrays.asList(value.toLowerCase(Locale.getDefault()).split("\\W+"))).groupBy((key, value) -> value).count();
        counts.toStream().to(OUTPUT_TOPIC, Produced.with((Serde)Serdes.String(), (Serde)Serdes.Long()));
    }

    public static void main(String[] args) throws IOException {
        Properties props = WordCountDemo.getStreamsConfig(args);
        StreamsBuilder builder = new StreamsBuilder();
        WordCountDemo.createWordCountStream(builder);
        final KafkaStreams streams = new KafkaStreams(builder.build(), props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-wordcount-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            System.exit(1);
        }
        System.exit(0);
    }
}

