/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.PermissionApplicationService;
import de.justsoftware.wikiservice.application.model.ContentCountDto;
import de.justsoftware.wikiservice.application.model.CreateOrUpdateWikiDto;
import de.justsoftware.wikiservice.application.model.PageDto;
import de.justsoftware.wikiservice.application.model.PageDtoKt;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.application.model.WikiMoveTargetDto;
import de.justsoftware.wikiservice.application.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.Subscription;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.business.model.WikiMoveTarget;
import de.justsoftware.wikiservice.business.model.WikiPreview;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.DbWikiOverview;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J6\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010/\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00100\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/wikiservice/application/WikiApplicationService;", "", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "permissionApplicationService", "Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "<init>", "(Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/application/PermissionApplicationService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/DeletionService;)V", "read", "Lde/justsoftware/wikiservice/application/model/WikiDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getWikiList", "Lde/justsoftware/wikiservice/application/model/PageDto;", "Lde/justsoftware/wikiservice/application/model/WikiPreviewDto;", "page", "", "pageSize", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Direction;", "getWikiMoveTargetList", "", "Lde/justsoftware/wikiservice/application/model/WikiMoveTargetDto;", "query", "", "create", "input", "Lde/justsoftware/wikiservice/application/model/CreateOrUpdateWikiDto;", "getContentCount", "Lde/justsoftware/wikiservice/application/model/ContentCountDto;", "update", "updateWikiDto", "delete", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiApplicationService.kt\nde/justsoftware/wikiservice/application/WikiApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1557#2:137\n1628#2,3:138\n*S KotlinDebug\n*F\n+ 1 WikiApplicationService.kt\nde/justsoftware/wikiservice/application/WikiApplicationService\n*L\n77#1:137\n77#1:138,3\n*E\n"})
public class WikiApplicationService {
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final DeletionService deletionService;

    public WikiApplicationService(@NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull ProfileService profileService, @NotNull PermissionApplicationService permissionApplicationService, @NotNull SubscriptionService subscriptionService, @NotNull AuthorizationService authorizationService, @NotNull DeletionService deletionService) {
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.profileService = profileService;
        this.permissionApplicationService = permissionApplicationService;
        this.subscriptionService = subscriptionService;
        this.authorizationService = authorizationService;
        this.deletionService = deletionService;
    }

    @NotNull
    public WikiDto read(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        Wiki wiki = this.wikiService.read(wikiId);
        ProfileDto editor = ProfileDto.Companion.toDto(this.profileService.getById(wiki.getModifiedBy()));
        Subscription subscription = this.subscriptionService.readWiki(wikiId, authContext.getUser());
        boolean isManager = this.authorizationService.mayManageWiki(wikiId, authContext.getUser());
        boolean isWriter = isManager || this.authorizationService.mayWriteWiki(wikiId, authContext.getUser());
        WikiDto.Companion companion = WikiDto.Companion;
        boolean bl = subscription.isSubscribed();
        return companion.toDto(wiki, editor, isManager, isWriter, bl);
    }

    @NotNull
    public PageDto<WikiPreviewDto> getWikiList(int page, int pageSize, @NotNull DbWikiOverview.Companion.Sort sortKey, @NotNull DbWikiOverview.Companion.Direction sortDirection, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page page2 = this.wikiService.getPreviewPage(authContext.getUser(), page, pageSize, sortKey, sortDirection, authContext.getTenantId()).map(arg_0 -> WikiApplicationService.getWikiList$lambda$1(WikiApplicationService::getWikiList$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return PageDtoKt.toPageDto((Page)page2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WikiMoveTargetDto> getWikiMoveTargetList(@NotNull String query, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Iterable $this$map$iv = this.wikiService.getWikiMoveTargets(authContext.getUser(), query, authContext.getTenantId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WikiMoveTarget wikiMoveTarget = (WikiMoveTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WikiMoveTargetDto.Companion.toDto((WikiMoveTarget)it));
        }
        return (List)destination$iv$iv;
    }

    @Transactional
    @NotNull
    public WikiDto create(@NotNull CreateOrUpdateWikiDto input, @NotNull AuthContext authContext) {
        WikiDto wikiDto;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        ProfileDto profile = ProfileDto.Companion.toDto(this.profileService.getById(authContext.getUser()));
        WikiDto it = wikiDto = WikiDto.Companion.toDto(this.wikiService.create(input.getTitle(), input.getDescription(), authContext.getUser(), authContext.getTenantId()), profile, true, true, true);
        boolean bl = false;
        this.permissionApplicationService.setPermissionsForWikiCreation(it.getId(), authContext.getUser().toGranteeId(), authContext);
        return wikiDto;
    }

    @NotNull
    public ContentCountDto getContentCount(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        Integer n = (Integer)this.chapterService.countByWikiIds(SetsKt.setOf((Object)wikiId)).get(wikiId);
        int chapterCount = n != null ? n : 0;
        Integer n2 = (Integer)this.articleService.countByWikiIds(SetsKt.setOf((Object)wikiId)).get(wikiId);
        int articleCount = n2 != null ? n2 : 0;
        return new ContentCountDto((long)chapterCount, (long)articleCount);
    }

    @NotNull
    public WikiDto update(@NotNull WikiId wikiId, @NotNull CreateOrUpdateWikiDto updateWikiDto, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)updateWikiDto, (String)"updateWikiDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteWiki(wikiId);
        Wiki updatedWiki = this.wikiService.update(wikiId, updateWikiDto.getTitle(), updateWikiDto.getDescription(), authContext.getUser());
        WikiDto.Companion companion = WikiDto.Companion;
        ProfileDto profileDto = ProfileDto.Companion.toDto(this.profileService.getById(updatedWiki.getModifiedBy()));
        boolean bl = this.subscriptionService.readWiki(wikiId, authContext.getUser()).isSubscribed();
        boolean bl2 = this.authorizationService.mayManageWiki(wikiId, authContext.getUser());
        return companion.toDto(updatedWiki, profileDto, bl2, true, bl);
    }

    @Transactional
    @NotNull
    public WikiDto delete(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        WikiDto wiki = this.read(wikiId, authContext);
        DeletionId deletionId = DeletionService.create$default((DeletionService)this.deletionService, (ItemId)((ItemId)wikiId), (ProfileId)authContext.getUser(), null, (int)4, null);
        this.wikiService.delete(wikiId, deletionId);
        return wiki;
    }

    private static final WikiPreviewDto getWikiList$lambda$0(WikiPreview it) {
        Intrinsics.checkNotNull((Object)it);
        return WikiPreviewDto.Companion.toDto(it);
    }

    private static final WikiPreviewDto getWikiList$lambda$1(Function1 $tmp0, Object p0) {
        return (WikiPreviewDto)$tmp0.invoke(p0);
    }
}

